/*
 * Decompiled with CFR 0.152.
 */
package com.logicaldoc.core.parser;

import com.logicaldoc.core.conversion.MarkdownConverter;
import com.logicaldoc.core.parser.HTMLParser;
import com.logicaldoc.core.parser.ParseParameters;
import com.logicaldoc.core.parser.ParsingException;
import com.logicaldoc.util.io.FileUtil;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;

public class MarkdownParser
extends HTMLParser {
    @Override
    public void internalParse(InputStream input, ParseParameters parameters, StringBuilder content) throws ParsingException {
        File html = null;
        File md = null;
        try {
            try {
                html = FileUtil.createTempFile("mdparse", ".html");
                md = FileUtil.createTempFile("mdparse", ".md");
                FileUtil.writeFile(input, md.getAbsolutePath());
                MarkdownConverter converter = new MarkdownConverter();
                converter.convert(md, html);
                this.parseHtml(html, parameters, content);
            }
            catch (IOException e) {
                throw new ParsingException(e);
            }
        }
        catch (Throwable throwable) {
            FileUtil.delete(html);
            FileUtil.delete(md);
            throw throwable;
        }
        FileUtil.delete(html);
        FileUtil.delete(md);
    }

    protected void parseHtml(File html, ParseParameters parameters, StringBuilder content) throws ParsingException, IOException {
        Throwable throwable = null;
        Object var5_6 = null;
        try (BufferedInputStream htmlInput = new BufferedInputStream(new FileInputStream(html));){
            super.internalParse(htmlInput, parameters, content);
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }
}

