/*
 * Decompiled with CFR 0.152.
 */
package com.logicaldoc.core.parser;

import com.logicaldoc.core.parser.AbstractParser;
import com.logicaldoc.core.parser.ParseParameters;
import com.logicaldoc.util.StringUtil;
import com.logicaldoc.util.io.FileUtil;
import com.logicaldoc.util.io.ZipUtil;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.io.StringReader;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xml.sax.Attributes;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.DefaultHandler;

public class KOfficeParser
extends AbstractParser {
    private static final Logger log = LoggerFactory.getLogger(KOfficeParser.class);

    @Override
    public void internalParse(InputStream input, ParseParameters parameters, StringBuilder content) {
        block23: {
            try {
                SAXParserFactory factory = SAXParserFactory.newInstance();
                factory.setFeature("http://apache.org/xml/features/disallow-doctype-decl", true);
                factory.setValidating(false);
                SAXParser saxParser = factory.newSAXParser();
                XMLReader xmlReader = saxParser.getXMLReader();
                xmlReader.setFeature("http://xml.org/sax/features/validation", false);
                xmlReader.setFeature("http://apache.org/xml/features/nonvalidating/load-external-dtd", false);
                File mainDocXml = FileUtil.createTempFile("koffice-maindoc", ".xml");
                try {
                    Throwable throwable = null;
                    Object var9_11 = null;
                    try (ZipUtil zipUtil = new ZipUtil();){
                        if (zipUtil.unzip(input, "maindoc.xml", mainDocXml) <= 0L) break block23;
                        Throwable throwable2 = null;
                        Object var12_16 = null;
                        try (FileInputStream mainDocStream = new FileInputStream(mainDocXml);){
                            KOfficeContentHandler contentHandler = new KOfficeContentHandler();
                            xmlReader.setContentHandler(contentHandler);
                            xmlReader.parse(new InputSource(mainDocStream));
                            content.append(StringUtil.writeToString(new StringReader(contentHandler.getContent())));
                        }
                        catch (Throwable throwable3) {
                            if (throwable2 == null) {
                                throwable2 = throwable3;
                            } else if (throwable2 != throwable3) {
                                throwable2.addSuppressed(throwable3);
                            }
                            throw throwable2;
                        }
                    }
                    catch (Throwable throwable4) {
                        if (throwable == null) {
                            throwable = throwable4;
                        } else if (throwable != throwable4) {
                            throwable.addSuppressed(throwable4);
                        }
                        throw throwable;
                    }
                }
                finally {
                    FileUtil.delete(mainDocXml);
                }
            }
            catch (Exception e) {
                log.warn("Failed to extract KOffice text content", e);
            }
        }
    }

    private class KOfficeContentHandler
    extends DefaultHandler {
        private StringBuilder content = new StringBuilder();
        private boolean appendChar = false;

        public String getContent() {
            return this.content.toString();
        }

        @Override
        public void startElement(String namespaceURI, String localName, String rawName, Attributes atts) throws SAXException {
            if (rawName.equalsIgnoreCase("TEXT")) {
                this.appendChar = true;
            }
        }

        @Override
        public void characters(char[] ch, int start, int length) throws SAXException {
            if (this.appendChar) {
                this.content.append(ch, start, length).append(" ");
            }
        }

        @Override
        public void endElement(String namespaceURI, String localName, String qName) throws SAXException {
            this.appendChar = false;
        }
    }
}

