/*
 * Decompiled with CFR 0.152.
 */
package com.logicaldoc.core.parser;

import java.io.IOException;
import java.io.Writer;
import org.xml.sax.Attributes;
import org.xml.sax.ErrorHandler;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;
import org.xml.sax.helpers.DefaultHandler;

class ExtractorHandler
extends DefaultHandler
implements ErrorHandler {
    private static final char SPACE_CHAR = ' ';
    private final Writer writer;
    private boolean space;

    public ExtractorHandler(Writer writer) {
        this.writer = writer;
        this.space = false;
    }

    @Override
    public void startElement(String uri, String local, String name, Attributes attributes) throws SAXException {
        int i = 0;
        while (i < attributes.getLength()) {
            String value = attributes.getValue(i);
            this.characters(value.toCharArray(), 0, value.length());
            ++i;
        }
    }

    @Override
    public void characters(char[] ch, int start, int length) throws SAXException {
        try {
            int i = 0;
            while (i < length) {
                if (Character.isSpaceChar(ch[start + i])) {
                    this.space = true;
                } else {
                    if (this.space) {
                        this.writer.write(32);
                        this.space = false;
                    }
                    this.writer.write(ch[start + i]);
                }
                ++i;
            }
            this.space = true;
        }
        catch (IOException e) {
            throw new SAXException(e.getMessage());
        }
    }

    @Override
    public void warning(SAXParseException exception) {
    }

    @Override
    public void error(SAXParseException exception) {
    }

    @Override
    public void fatalError(SAXParseException exception) {
    }
}

