/*
 * Decompiled with CFR 0.152.
 */
package com.logicaldoc.core.parser;

import com.github.mertakdut.BookSection;
import com.github.mertakdut.Reader;
import com.github.mertakdut.exception.OutOfPagesException;
import com.github.mertakdut.exception.ReadingException;
import com.logicaldoc.core.parser.AbstractParser;
import com.logicaldoc.core.parser.ParseParameters;
import com.logicaldoc.util.io.FileUtil;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import org.apache.commons.lang3.StringUtils;
import org.apache.poi.hslf.usermodel.HSLFSlideShow;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EpubParser
extends AbstractParser {
    private static final Logger log = LoggerFactory.getLogger(EpubParser.class);

    @Override
    public void internalParse(InputStream input, ParseParameters parameters, StringBuilder content) {
        block5: {
            File tmpFile = null;
            try {
                try {
                    tmpFile = FileUtil.createTempFile("epubparser", ".epub");
                    FileUtil.writeFile(input, tmpFile.getAbsolutePath());
                    Reader reader = new Reader();
                    reader.setIsIncludingTextContent(true);
                    reader.setFullContent(tmpFile.getAbsolutePath());
                    this.extractSections(reader, content);
                }
                catch (Exception ex) {
                    log.error(ex.getMessage(), ex);
                    FileUtil.delete(tmpFile);
                    break block5;
                }
            }
            catch (Throwable throwable) {
                FileUtil.delete(tmpFile);
                throw throwable;
            }
            FileUtil.delete(tmpFile);
        }
    }

    private void extractSections(Reader reader, StringBuilder content) throws ReadingException {
        int sectionIndex = 0;
        while (sectionIndex < Integer.MAX_VALUE) {
            block4: {
                try {
                    BookSection bookSection = reader.readSection(sectionIndex);
                    String sectionTextContent = bookSection.getSectionTextContent();
                    if (!StringUtils.isNotEmpty((CharSequence)sectionTextContent)) break block4;
                    if (content.length() > 0) {
                        content.append("\n");
                    }
                    content.append(sectionTextContent);
                }
                catch (OutOfPagesException t) {
                    break;
                }
            }
            ++sectionIndex;
        }
    }

    @Override
    public int countPages(InputStream input, String filename) {
        try {
            Throwable throwable = null;
            Object var4_6 = null;
            try (HSLFSlideShow pptDoc = new HSLFSlideShow(input);){
                return pptDoc.getSlides().size();
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (IOException e) {
            log.error(e.getMessage(), e);
            return 1;
        }
    }
}

