/*
 * Decompiled with CFR 0.152.
 */
package com.logicaldoc.core.parser;

import com.logicaldoc.core.parser.ParseParameters;
import com.logicaldoc.core.parser.RTFParser;
import com.logicaldoc.util.StringUtil;
import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.StringReader;
import org.apache.poi.hwpf.HWPFDocument;
import org.apache.poi.hwpf.extractor.WordExtractor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DOCParser
extends RTFParser {
    private static final Logger log = LoggerFactory.getLogger(DOCParser.class);

    @Override
    public String parse(InputStream input, ParseParameters parameterObject) {
        try {
            Throwable throwable = null;
            Object var4_6 = null;
            try (BufferedInputStream bis = new BufferedInputStream(input);){
                bis.mark(Integer.MAX_VALUE);
                String tmp = this.extractTextAsWord(bis);
                this.resetStream(bis);
                if (tmp.length() == 0) {
                    tmp = super.extractText(bis);
                }
                if (tmp != null) {
                    tmp = tmp.replaceAll("[\\p{Cntrl}&&[^\\n]]", " ");
                }
                return StringUtil.writeToString(new StringReader(tmp));
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (Exception e) {
            log.warn("Failed to extract Word text content", e);
            return "";
        }
    }

    private void resetStream(BufferedInputStream bis) {
        try {
            bis.reset();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private String extractTextAsWord(BufferedInputStream bis) {
        String tmp = "";
        try {
            Throwable throwable = null;
            Object var4_6 = null;
            try (WordExtractor extractor = new WordExtractor((InputStream)bis);){
                tmp = extractor.getText();
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return tmp;
    }

    @Override
    public int countPages(InputStream input, String filename) {
        try {
            Throwable throwable = null;
            Object var4_6 = null;
            try (HWPFDocument wordDoc = new HWPFDocument(input);){
                return wordDoc.getSummaryInformation().getPageCount();
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (IOException e) {
            log.error(e.getMessage(), e);
            return 1;
        }
    }
}

