/*
 * Decompiled with CFR 0.152.
 */
package com.logicaldoc.core.parser;

import com.logicaldoc.core.conversion.FormatConverterManager;
import com.logicaldoc.core.parser.AbstractParser;
import com.logicaldoc.core.parser.ParseParameters;
import com.logicaldoc.core.parser.Parser;
import com.logicaldoc.core.parser.ParserFactory;
import com.logicaldoc.core.store.Store;
import com.logicaldoc.util.io.FileUtil;
import com.logicaldoc.util.spring.Context;
import java.io.File;
import java.io.InputStream;
import org.apache.commons.io.FileUtils;

public class CatchAllParser
extends AbstractParser {
    @Override
    public void internalParse(InputStream input, ParseParameters parameters, StringBuilder content) {
        if (parameters.getDocument() == null) {
            this.parse1(input, parameters, content);
        } else {
            this.parse2(parameters, content);
        }
    }

    private void parse2(ParseParameters parameters, StringBuilder content) {
        try {
            FormatConverterManager manager = Context.get(FormatConverterManager.class);
            manager.convertToPdf(parameters.getDocument(), parameters.getFileVersion(), null);
            Store store = Context.get(Store.class);
            String pdfResource = store.getResourceName(parameters.getDocument(), parameters.getFileVersion() != null ? parameters.getFileVersion() : parameters.getDocument().getFileVersion(), "conversion.pdf");
            if (store.exists(parameters.getDocument().getId(), pdfResource)) {
                Parser parser = ParserFactory.getParser("pdf");
                content.append(parser.parse(store.getStream(parameters.getDocument().getId(), pdfResource), new ParseParameters(null, "output.pdf", null, parameters.getEncoding(), parameters.getLocale(), parameters.getTenant())));
            } else {
                log.warn("Cannot convert the file {} into pdf in order to parse the contents", (Object)parameters.getFileName());
            }
        }
        catch (Exception t) {
            log.error(t.getMessage(), t);
        }
    }

    private void parse1(InputStream input, ParseParameters parameters, StringBuilder content) {
        block10: {
            FormatConverterManager manager = Context.get(FormatConverterManager.class);
            File inputFile = null;
            File outputPdf = null;
            try {
                try {
                    inputFile = FileUtil.createTempFile("input", parameters.getFileName());
                    outputPdf = FileUtil.createTempFile("output", ".pdf");
                    FileUtils.copyInputStreamToFile(input, inputFile);
                    if (!inputFile.exists() || inputFile.length() <= 0L) break block10;
                    manager.convertFile(inputFile, parameters.getFileName(), outputPdf, "pdf", null);
                    if (outputPdf.exists() && outputPdf.length() > 0L) {
                        Parser parser = ParserFactory.getParser("pdf");
                        content.append(parser.parse(outputPdf, "output.pdf", parameters.getEncoding(), parameters.getLocale(), parameters.getTenant(), null, null));
                        break block10;
                    }
                    log.warn("Cannot convert the file {} into pdf in order to parse the contents", (Object)parameters.getFileName());
                }
                catch (Exception t) {
                    log.error(t.getMessage(), t);
                    if (inputFile != null && inputFile.exists()) {
                        FileUtil.delete(inputFile);
                    }
                    if (outputPdf != null && outputPdf.exists()) {
                        FileUtil.delete(outputPdf);
                    }
                }
            }
            finally {
                if (inputFile != null && inputFile.exists()) {
                    FileUtil.delete(inputFile);
                }
                if (outputPdf != null && outputPdf.exists()) {
                    FileUtil.delete(outputPdf);
                }
            }
        }
    }
}

