/*
 * Decompiled with CFR 0.152.
 */
package com.logicaldoc.core.parser;

import com.logicaldoc.core.document.Document;
import com.logicaldoc.core.parser.ParseParameters;
import com.logicaldoc.core.parser.Parser;
import com.logicaldoc.core.parser.ParsingException;
import com.logicaldoc.core.parser.ParsingTimeoutException;
import com.logicaldoc.util.spring.Context;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Arrays;
import java.util.Locale;
import java.util.concurrent.Callable;
import java.util.concurrent.CancellationException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractParser
implements Parser {
    protected static final Logger log = LoggerFactory.getLogger(AbstractParser.class);

    @Override
    public String parse(File file, String filename, String encoding, Locale locale, String tenant) throws ParsingException {
        return this.parse(file, filename, encoding, locale, tenant, null, null);
    }

    @Override
    public String parse(File file, String filename, String encoding, Locale locale, String tenant, Document document, String fileVersion) throws ParsingException {
        try {
            Throwable throwable = null;
            Object var9_11 = null;
            try (FileInputStream is = new FileInputStream(file);){
                return this.parse(is, new ParseParameters(document, filename, fileVersion, encoding, locale, tenant));
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (IOException e) {
            log.error(e.getMessage());
            return "";
        }
    }

    @Override
    public String parse(InputStream input, String filename, String encoding, Locale locale, String tenant) throws ParsingException {
        return this.parse(input, new ParseParameters(null, filename, null, encoding, locale, tenant));
    }

    @Override
    public String parse(InputStream input, ParseParameters parameters) throws ParsingException {
        if (log.isDebugEnabled()) {
            log.debug("Parse started");
        }
        StringBuilder content = new StringBuilder();
        parameters.setLocale(this.getLocale(parameters.getLocale()));
        parameters.setTenant(this.getTenant(parameters.getLocale(), parameters.getTenant()));
        long timeout = this.getTimeout(parameters.getTenant());
        if (timeout <= 0L) {
            this.parseInCurrentThread(input, parameters, content);
        } else {
            try {
                this.parseInNewThreadAndWait(input, parameters, content, timeout);
            }
            catch (ParsingTimeoutException pte) {
                if (this.getTimeoutRetain(parameters.getTenant())) {
                    log.warn("Got parsing timeout, but retain the extracted content");
                }
                throw pte;
            }
        }
        if (log.isDebugEnabled()) {
            log.debug("Parse Finished");
        }
        return content.toString();
    }

    private boolean getTimeoutRetain(String tenant) {
        return Context.get().getProperties().getBoolean(tenant + ".parser.timeout.retain", true);
    }

    private int getTimeout(String tenant) {
        try {
            return Context.get().getProperties().getInt(tenant + ".parser.timeout", 120);
        }
        catch (Exception e) {
            return 120;
        }
    }

    private void parseInNewThreadAndWait(InputStream input, ParseParameters parameters, StringBuilder content, long timeout) throws ParsingException {
        ExecutorService executor = Executors.newSingleThreadExecutor();
        try {
            String ret = "";
            try {
                ret = (String)executor.invokeAll(Arrays.asList(new InternalParseTask(input, parameters, content)), timeout, TimeUnit.SECONDS).get(0).get();
            }
            catch (InterruptedException ie) {
                log.warn("Interrupted parse");
                ret = "interrupted";
                Thread.currentThread().interrupt();
            }
            catch (CancellationException e) {
                log.warn("Parsing timeout");
                ret = "timeout";
            }
            catch (Exception e) {
                log.warn(e.getMessage(), e);
                ret = e.getMessage();
            }
            if ("interrupted".equals(ret) || "timeout".equals(ret)) {
                throw new ParsingTimeoutException(ret);
            }
            if (!"completed".equals(ret)) {
                throw new ParsingException(ret);
            }
        }
        finally {
            executor.shutdownNow();
        }
    }

    private void parseInCurrentThread(InputStream input, ParseParameters parameters, StringBuilder content) throws ParsingException {
        try {
            this.internalParse(input, parameters, content);
        }
        catch (ParsingException pe) {
            throw pe;
        }
        catch (Exception e) {
            throw new ParsingException(e);
        }
    }

    private String getTenant(Locale locale, String tenant) {
        return locale != null ? tenant : "default";
    }

    private Locale getLocale(Locale locale) {
        return locale != null ? locale : Locale.ENGLISH;
    }

    protected abstract void internalParse(InputStream var1, ParseParameters var2, StringBuilder var3) throws IOException, ParsingException;

    @Override
    public int countPages(InputStream input, String filename) {
        return 1;
    }

    @Override
    public int countPages(File file, String filename) {
        try {
            Throwable throwable = null;
            Object var4_6 = null;
            try (FileInputStream is = new FileInputStream(file);){
                return this.countPages(is, filename);
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (IOException e) {
            log.error(e.getMessage());
            return 1;
        }
    }

    class InternalParseTask
    implements Callable<String> {
        private InputStream is;
        private ParseParameters parameters;
        private StringBuilder content;

        public InternalParseTask(InputStream is, ParseParameters parameters, StringBuilder content) {
            this.is = is;
            this.parameters = parameters;
            this.content = content;
        }

        @Override
        public String call() throws ParsingException {
            try {
                AbstractParser.this.internalParse(this.is, this.parameters, this.content);
                return "completed";
            }
            catch (ParsingException pe) {
                throw pe;
            }
            catch (Exception ee) {
                throw new ParsingException(ee.getMessage(), ee);
            }
        }
    }
}

