/*
 * Decompiled with CFR 0.152.
 */
package com.logicaldoc.core.parser;

import com.logicaldoc.core.parser.AbstractParser;
import com.logicaldoc.core.parser.ParseParameters;
import com.logicaldoc.util.StringUtil;
import java.io.InputStream;
import java.io.StringReader;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xml.sax.Attributes;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.DefaultHandler;

public class AbiWordParser
extends AbstractParser {
    private static final Logger log = LoggerFactory.getLogger(AbiWordParser.class);

    @Override
    public void internalParse(InputStream input, ParseParameters parameters, StringBuilder content) {
        try {
            SAXParserFactory factory = SAXParserFactory.newInstance();
            factory.setFeature("http://xml.org/sax/features/external-general-entities", false);
            factory.setFeature("http://xml.org/sax/features/external-parameter-entities", false);
            factory.setValidating(false);
            SAXParser saxParser = factory.newSAXParser();
            XMLReader xmlReader = saxParser.getXMLReader();
            xmlReader.setFeature("http://xml.org/sax/features/validation", false);
            xmlReader.setFeature("http://apache.org/xml/features/nonvalidating/load-external-dtd", false);
            AbiWordContentHandler contentHandler = new AbiWordContentHandler();
            xmlReader.setContentHandler(contentHandler);
            xmlReader.parse(new InputSource(input));
            content.append(StringUtil.writeToString(new StringReader(contentHandler.getContent())));
        }
        catch (Exception e) {
            log.warn("Failed to extract AbiWord text content", e);
        }
    }

    private class AbiWordContentHandler
    extends DefaultHandler {
        private StringBuilder content = new StringBuilder();
        private boolean appendChar = false;

        public String getContent() {
            String tmp = this.content.toString();
            if (tmp != null && tmp.length() > 0) {
                tmp = tmp.replaceAll("[<>\"]", "");
            }
            return tmp;
        }

        @Override
        public void startElement(String namespaceURI, String localName, String rawName, Attributes atts) throws SAXException {
            if (rawName.startsWith("p")) {
                this.appendChar = true;
            }
        }

        @Override
        public void characters(char[] ch, int start, int length) throws SAXException {
            if (this.appendChar) {
                this.content.append(ch, start, length).append(" ");
            }
        }

        @Override
        public void endElement(String namespaceURI, String localName, String qName) throws SAXException {
            this.appendChar = false;
        }
    }
}

