/*
 * Decompiled with CFR 0.152.
 */
package com.logicaldoc.core.metadata.validation;

import com.logicaldoc.core.PersistenceException;
import com.logicaldoc.core.RunLevel;
import com.logicaldoc.core.automation.Automation;
import com.logicaldoc.core.automation.AutomationException;
import com.logicaldoc.core.history.History;
import com.logicaldoc.core.metadata.Attribute;
import com.logicaldoc.core.metadata.ExtensibleObject;
import com.logicaldoc.core.metadata.Template;
import com.logicaldoc.core.metadata.TemplateDAO;
import com.logicaldoc.core.metadata.validation.ValidationError;
import com.logicaldoc.core.metadata.validation.ValidationException;
import com.logicaldoc.core.security.user.User;
import com.logicaldoc.core.security.user.UserDAO;
import com.logicaldoc.util.spring.Context;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.hibernate.LazyInitializationException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Validator {
    private static final Logger log = LoggerFactory.getLogger(Validator.class);

    public void validate(ExtensibleObject object, Template template, History transaction) throws ValidationException, AutomationException {
        if (!RunLevel.current().aspectEnabled("validation")) {
            return;
        }
        if (transaction == null) {
            return;
        }
        if (object.getDeleted() != 0 || template == null) {
            return;
        }
        this.setUser(transaction);
        template = this.initializeAttributes(template);
        HashMap<String, String> errors = new HashMap<String, String>();
        this.validateAttributes(object, template, transaction, errors);
        this.executeObjectValidation(object, template, transaction, errors);
        if (!errors.isEmpty()) {
            ArrayList<ValidationError> errorsList = new ArrayList<ValidationError>();
            for (Map.Entry entry : errors.entrySet()) {
                Attribute att = template.getAttribute((String)entry.getKey());
                if (att != null) {
                    errorsList.add(new ValidationError((String)entry.getKey(), att.getLabel(), (String)entry.getValue()));
                    continue;
                }
                errorsList.add(new ValidationError((String)entry.getKey(), (String)entry.getValue()));
            }
            throw new ValidationException(errorsList);
        }
    }

    private Template initializeAttributes(Template template) {
        if (template != null) {
            try {
                int attributesCount = template.getAttributes().size();
                if (log.isDebugEnabled()) {
                    log.debug("Initialized {} attributes", (Object)attributesCount);
                }
            }
            catch (LazyInitializationException e) {
                log.debug("Got error {} trying to reload the template {}", (Object)e.getMessage(), (Object)template.getId());
                TemplateDAO tDao = Context.get(TemplateDAO.class);
                try {
                    template = (Template)tDao.findById(template.getId());
                    tDao.initialize(template);
                }
                catch (PersistenceException pe) {
                    log.warn(pe.getMessage(), pe);
                }
            }
        }
        return template;
    }

    private void validateAttributes(ExtensibleObject object, Template template, History transaction, Map<String, String> errors) throws AutomationException {
        for (String attributeName : template.getAttributeNames()) {
            Attribute templateAttribute;
            Attribute attribute = object.getAttribute(attributeName);
            if (attribute == null || !StringUtils.isNotEmpty((CharSequence)(templateAttribute = template.getAttribute(attributeName)).getValidation())) continue;
            this.executeAttributeValidation(object, transaction, errors, attributeName, attribute, templateAttribute);
        }
    }

    private void executeObjectValidation(ExtensibleObject object, Template template, History transaction, Map<String, String> errors) throws AutomationException {
        HashMap<String, Object> automationDictionary = new HashMap<String, Object>();
        automationDictionary.put("object", object);
        automationDictionary.put("event", transaction);
        automationDictionary.put("errors", errors);
        if (errors.isEmpty() && StringUtils.isNotEmpty((CharSequence)template.getValidation())) {
            Automation script = new Automation("validator", transaction != null && transaction.getUser() != null ? transaction.getUser().getLocale() : Locale.ENGLISH, object.getTenantId());
            script.evaluate(template.getValidation(), automationDictionary);
        }
    }

    private void executeAttributeValidation(ExtensibleObject object, History transaction, Map<String, String> errors, String attributeName, Attribute attribute, Attribute templateAttribute) throws AutomationException {
        HashMap<String, Object> fieldValidationDictionary = new HashMap<String, Object>();
        fieldValidationDictionary.put("object", object);
        fieldValidationDictionary.put("event", transaction);
        fieldValidationDictionary.put("errors", errors);
        fieldValidationDictionary.put("attributeName", attributeName);
        fieldValidationDictionary.put("attribute", attribute);
        fieldValidationDictionary.put("value", attribute.getValue());
        ValidationError error = new ValidationError(attributeName, attribute.getLabel(), null);
        fieldValidationDictionary.put("error", error);
        Automation script = new Automation("validator-" + attributeName, transaction != null && transaction.getUser() != null ? transaction.getUser().getLocale() : Locale.getDefault(), object.getTenantId());
        script.evaluate(templateAttribute.getValidation(), fieldValidationDictionary);
        if (StringUtils.isNotEmpty((CharSequence)error.getDescription())) {
            errors.put(attributeName, error.getDescription());
        }
    }

    private void setUser(History transaction) {
        User user;
        User user2 = user = transaction != null && transaction.getUser() != null ? transaction.getUser() : null;
        if (user == null && transaction != null && transaction.getUserId() != null) {
            UserDAO uDao = Context.get(UserDAO.class);
            try {
                user = (User)uDao.findById(transaction.getUserId());
                transaction.setUser(user);
            }
            catch (PersistenceException e) {
                log.warn(e.getMessage());
            }
        }
    }
}

