/*
 * Decompiled with CFR 0.152.
 */
package com.logicaldoc.core.metadata.validation;

import com.logicaldoc.core.PersistenceException;
import com.logicaldoc.core.metadata.validation.ValidationError;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.lang.StringUtils;

public class ValidationException
extends PersistenceException {
    private static final long serialVersionUID = 1L;
    private final Map<String, ValidationError> errors = new HashMap<String, ValidationError>();

    public ValidationException(Collection<ValidationError> errors) {
        if (errors != null) {
            for (ValidationError error : errors) {
                this.errors.put(error.getAttribute(), error);
            }
        }
    }

    public ValidationException(Collection<ValidationError> errors, Throwable cause) {
        super(cause);
        if (errors != null) {
            for (ValidationError error : errors) {
                this.errors.put(error.getAttribute(), error);
            }
        }
    }

    public ValidationException(String message, Throwable cause) {
        super(message, cause);
        this.errors.put("", new ValidationError(null, message));
    }

    public ValidationException(String message) {
        super(message);
        this.errors.put("", new ValidationError(null, message));
    }

    public Map<String, ValidationError> getErrors() {
        return this.errors;
    }

    public void addError(ValidationError error) {
        this.errors.put(error.getAttribute(), error);
    }

    @Override
    public String getMessage() {
        if (this.errors.isEmpty()) {
            return super.getMessage();
        }
        return this.errors.keySet().stream().map(k -> (StringUtils.isNotEmpty(this.errors.get(k).getLabel()) ? this.errors.get(k).getLabel() : k) + (StringUtils.isNotEmpty(k) ? ": " : "") + this.errors.get(k).getDescription()).collect(Collectors.joining("; "));
    }
}

