/*
 * Decompiled with CFR 0.152.
 */
package com.logicaldoc.core.metadata.initialization;

import com.logicaldoc.core.PersistenceException;
import com.logicaldoc.core.RunLevel;
import com.logicaldoc.core.automation.Automation;
import com.logicaldoc.core.automation.AutomationException;
import com.logicaldoc.core.history.History;
import com.logicaldoc.core.metadata.Attribute;
import com.logicaldoc.core.metadata.ExtensibleObject;
import com.logicaldoc.core.metadata.Template;
import com.logicaldoc.core.metadata.TemplateDAO;
import com.logicaldoc.core.security.user.User;
import com.logicaldoc.core.security.user.UserDAO;
import com.logicaldoc.util.spring.Context;
import java.util.HashMap;
import java.util.Locale;
import org.apache.commons.lang3.StringUtils;
import org.hibernate.LazyInitializationException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Initializer {
    private static final Logger log = LoggerFactory.getLogger(Initializer.class);

    public void initialize(ExtensibleObject object, Template template, History transaction) {
        if (!RunLevel.current().aspectEnabled("initialization")) {
            return;
        }
        if (object.getId() != 0L) {
            return;
        }
        if (object.getDeleted() != 0 || template == null) {
            return;
        }
        this.setUser(transaction);
        template = this.initializeAttributes(template);
        for (String attributeName : template.getAttributeNames()) {
            try {
                Attribute attribute = object.getAttribute(attributeName);
                Attribute templateAttribute = template.getAttribute(attributeName);
                if (attribute == null || templateAttribute == null || attribute.getValue() != null || !StringUtils.isNotEmpty((CharSequence)templateAttribute.getInitialization())) continue;
                this.executeInitialization(object, transaction, attributeName, attribute, templateAttribute);
            }
            catch (Exception e) {
                log.error(e.getMessage(), e);
            }
        }
    }

    private Template initializeAttributes(Template template) {
        try {
            int attributesCount = template.getAttributeNames().size();
            if (log.isDebugEnabled()) {
                log.debug("Initialized {} attributes", (Object)attributesCount);
            }
        }
        catch (LazyInitializationException e) {
            log.debug("Got error {} trying to reload the template {}", (Object)e.getMessage(), (Object)template.getId());
            TemplateDAO tDao = Context.get(TemplateDAO.class);
            try {
                template = (Template)tDao.findById(template.getId());
                tDao.initialize(template);
            }
            catch (PersistenceException pe) {
                log.warn(pe.getMessage(), pe);
            }
        }
        return template;
    }

    private void executeInitialization(ExtensibleObject object, History transaction, String attributeName, Attribute attribute, Attribute templateAttribute) throws AutomationException {
        HashMap<String, Object> fieldValidationDictionary = new HashMap<String, Object>();
        fieldValidationDictionary.put("object", object);
        fieldValidationDictionary.put("event", transaction);
        fieldValidationDictionary.put("attributeName", attributeName);
        fieldValidationDictionary.put("attribute", attribute);
        Automation script = new Automation("initializer-" + attributeName, transaction != null && transaction.getUser() != null ? transaction.getUser().getLocale() : Locale.getDefault(), object.getTenantId());
        script.evaluate(templateAttribute.getInitialization(), fieldValidationDictionary);
    }

    private void setUser(History transaction) {
        User user;
        User user2 = user = transaction != null && transaction.getUser() != null ? transaction.getUser() : null;
        if (user == null && transaction != null && transaction.getUserId() != null) {
            UserDAO uDao = Context.get(UserDAO.class);
            try {
                user = (User)uDao.findById(transaction.getUserId());
                transaction.setUser(user);
            }
            catch (PersistenceException e) {
                log.warn(e.getMessage());
            }
        }
    }
}

