/*
 * Decompiled with CFR 0.152.
 */
package com.logicaldoc.core.metadata;

import com.logicaldoc.core.metadata.AbstractAttributeSet;
import com.logicaldoc.core.metadata.Attribute;
import com.logicaldoc.core.security.AccessControlEntry;
import com.logicaldoc.core.security.Secure;
import jakarta.persistence.Cacheable;
import jakarta.persistence.CollectionTable;
import jakarta.persistence.Column;
import jakarta.persistence.ElementCollection;
import jakarta.persistence.Entity;
import jakarta.persistence.JoinColumn;
import jakarta.persistence.MapKeyColumn;
import jakarta.persistence.OrderBy;
import jakarta.persistence.Table;
import jakarta.persistence.Transient;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

@Entity
@Table(name="ld_template")
@Cacheable
public class Template
extends AbstractAttributeSet
implements Secure<AccessControlEntry> {
    private static final long serialVersionUID = 1L;
    @Column(name="ld_validation")
    private String validation;
    @Transient
    private Set<AccessControlEntry> accessControlList = new HashSet<AccessControlEntry>();
    @ElementCollection
    @CollectionTable(name="ld_template_ext", joinColumns={@JoinColumn(name="ld_templateid")})
    @MapKeyColumn(name="ld_name", length=255)
    @OrderBy(value="ld_position ASC, ld_name ASC")
    private Map<String, Attribute> templateAttributes = new HashMap<String, Attribute>();

    @Override
    public Map<String, Attribute> getTemplateAttributes() {
        return this.templateAttributes;
    }

    @Override
    public void setTemplateAttributes(Map<String, Attribute> templateAttributes) {
        this.templateAttributes = templateAttributes;
    }

    public String getValidation() {
        return this.validation;
    }

    public void setValidation(String validation) {
        this.validation = validation;
    }

    @Override
    public Set<AccessControlEntry> getAccessControlList() {
        return this.accessControlList;
    }

    @Override
    public void setAccessControlList(Set<AccessControlEntry> accessControlList) {
        this.accessControlList = accessControlList;
    }

    @Override
    public AccessControlEntry getAccessControlEntry(long groupId) {
        return this.getAccessControlList().stream().filter(ace -> ace.getGroupId() == groupId).findFirst().orElse(null);
    }

    @Override
    public void addAccessControlEntry(AccessControlEntry ace) {
        if (!this.getAccessControlList().add(ace)) {
            this.getAccessControlList().remove(ace);
            this.getAccessControlList().add(ace);
        }
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = super.hashCode();
        result = 31 * result + (this.validation == null ? 0 : this.validation.hashCode());
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Template other = (Template)obj;
        return !(this.validation == null ? other.validation != null : !this.validation.equals(other.validation));
    }
}

