/*
 * Decompiled with CFR 0.152.
 */
package com.logicaldoc.core.metadata;

import com.logicaldoc.core.HibernatePersistentObjectDAO;
import com.logicaldoc.core.PersistenceException;
import com.logicaldoc.core.PersistentObject;
import com.logicaldoc.core.metadata.Template;
import com.logicaldoc.core.metadata.TemplateDAO;
import com.logicaldoc.core.security.AccessControlEntry;
import com.logicaldoc.core.security.Permission;
import com.logicaldoc.core.security.user.Group;
import com.logicaldoc.core.security.user.GroupDAO;
import com.logicaldoc.core.security.user.User;
import com.logicaldoc.core.security.user.UserDAO;
import com.logicaldoc.core.threading.ThreadPools;
import com.logicaldoc.util.spring.Context;
import com.logicaldoc.util.sql.SqlUtil;
import jakarta.annotation.Resource;
import jakarta.transaction.Transactional;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Repository;

@Repository(value="templateDAO")
@Transactional
public class HibernateTemplateDAO
extends HibernatePersistentObjectDAO<Template>
implements TemplateDAO {
    private static final String TENANT_ID_EQUAL = ".tenantId=";
    @Resource(name="userDAO")
    protected UserDAO userDAO;

    public HibernateTemplateDAO() {
        super(Template.class);
        this.log = LoggerFactory.getLogger(HibernateTemplateDAO.class);
    }

    @Override
    public List<Template> findAll() {
        try {
            return this.findByWhere(" 1=1", "_entity.name", null);
        }
        catch (PersistenceException e) {
            this.log.error(e.getMessage(), e);
            return new ArrayList<Template>();
        }
    }

    @Override
    public List<Template> findAll(long tenantId) {
        try {
            return this.findByWhere(" _entity.tenantId=" + tenantId, "_entity.name", null);
        }
        catch (PersistenceException e) {
            this.log.error(e.getMessage(), e);
            return new ArrayList<Template>();
        }
    }

    @Override
    public Template findByName(String name, long tenantId) throws PersistenceException {
        PersistentObject template = null;
        List coll = this.findByWhere("_entity.name = '" + SqlUtil.doubleQuotes(name) + "' and _entity.tenantId=" + tenantId, null, null);
        if (CollectionUtils.isNotEmpty(coll)) {
            template = (Template)coll.iterator().next();
        }
        if (template != null && template.getDeleted() == 1) {
            template = null;
        }
        return template;
    }

    @Override
    public void delete(long id, int code) throws PersistenceException {
        if (!this.checkStoringAspect()) {
            return;
        }
        Template template = (Template)this.findById(id);
        if (this.countDocs(id) > 0) {
            throw new PersistenceException(String.format("Some documents are referencing the template %s (%d)", template.getName(), template.getId()));
        }
        if (this.countFolders(id) > 0) {
            throw new PersistenceException(String.format("Some folders are referencing the template %s (%d)", template.getName(), template.getId()));
        }
        if (template != null) {
            template.setDeleted(code);
            template.setName(template.getName() + "." + template.getId());
            this.saveOrUpdate(template);
        }
    }

    @Override
    public void store(Template template) throws PersistenceException {
        boolean isNew = template.getId() == 0L;
        super.store(template);
        this.removeForbiddenPermissionsForGuests(template);
        if (isNew) {
            this.flush();
            this.storeAclAsync(template);
        } else {
            this.storeAcl(template);
        }
    }

    private void storeAclAsync(Template template) {
        ThreadPools.get().schedule(() -> {
            try {
                String documentWriteCheckQuery = "select count(*) from ld_template where ld_id=" + template.getId();
                int count = 0;
                int tests = 0;
                while (count == 0 && tests < 100) {
                    count = this.queryForInt(documentWriteCheckQuery);
                    Thread.sleep(1000L);
                    ++tests;
                }
                if (count > 0) {
                    if (this.log.isDebugEnabled()) {
                        this.log.debug("Record of template {} has been written", (Object)template.getId());
                    }
                    this.storeAcl(template);
                }
            }
            catch (PersistenceException ex) {
                this.log.error(ex.getMessage(), ex);
            }
            catch (InterruptedException ie) {
                Thread.currentThread().interrupt();
            }
            return null;
        }, "TemplateSecuritySave", 100L);
    }

    private void storeAcl(Template template) throws PersistenceException {
        this.jdbcUpdate("delete from ld_template_acl where ld_templateid=" + template.getId());
        for (AccessControlEntry ace : template.getAccessControlList()) {
            this.jdbcUpdate("insert into ld_template_acl(ld_templateid, ld_groupid, ld_write, ld_read) values (" + template.getId() + ", " + ace.getGroupId() + ", " + ace.getWrite() + ", " + ace.getRead() + ")");
        }
        if (this.log.isDebugEnabled()) {
            this.log.debug("Stored security settings of template {}", (Object)template.getId());
        }
    }

    private void removeForbiddenPermissionsForGuests(Template template) throws PersistenceException {
        GroupDAO gDao = Context.get(GroupDAO.class);
        for (AccessControlEntry ace : template.getAccessControlList()) {
            Group group = (Group)gDao.findById(ace.getGroupId());
            if (group == null || !group.isGuest()) continue;
            ace.setWrite(0);
        }
    }

    public int countFolders(long id) {
        try {
            return this.queryForInt("select count(*) from ld_folder where ld_deleted=0 and ld_templateid=" + id);
        }
        catch (PersistenceException e) {
            this.log.error(e.getMessage(), e);
            return 0;
        }
    }

    @Override
    public int countDocs(long id) throws PersistenceException {
        return this.queryForInt("select count(*) from ld_document where ld_deleted=0 and ld_templateid=" + id);
    }

    @Override
    public List<Template> findByType(int type, long tenantId) throws PersistenceException {
        return this.findByWhere("_entity.type =" + type + " and _entity.tenantId=" + tenantId, " order by _entity.name asc", null);
    }

    @Override
    public void initialize(Template template) {
        block2: {
            try {
                this.refresh(template);
                this.log.trace("Initialized {} attributes", (Object)template.getTemplateAttributes().size());
                template.getAccessControlList().clear();
                this.queryForResultSet("select ld_groupid,ld_write,ld_read from ld_template_acl where ld_templateid=" + template.getId(), null, null, rows -> {
                    while (rows.next()) {
                        AccessControlEntry ace = new AccessControlEntry(rows.getLong(1));
                        ace.setWrite(rows.getInt(2));
                        ace.setRead(rows.getInt(3));
                        template.addAccessControlEntry(ace);
                    }
                });
                this.log.trace("Initialized {} aces", (Object)template.getAccessControlList().size());
            }
            catch (Exception e) {
                if (!this.log.isErrorEnabled()) break block2;
                this.log.error(e.getMessage(), e);
            }
        }
    }

    private boolean isWriteOrReadEnable(long templateId, long userId, boolean write) {
        boolean result = true;
        try {
            Set<Permission> permissions = this.getAllowedPermissions(templateId, userId);
            if (write) {
                return permissions.contains((Object)Permission.WRITE);
            }
            return permissions.contains((Object)Permission.READ);
        }
        catch (Exception e) {
            if (this.log.isErrorEnabled()) {
                this.log.error(e.getMessage(), e);
            }
            result = false;
            return result;
        }
    }

    @Override
    public boolean isWriteEnable(long templateId, long userId) {
        return this.isWriteOrReadEnable(templateId, userId, true);
    }

    @Override
    public boolean isReadEnable(long templateId, long userId) {
        return this.isWriteOrReadEnable(templateId, userId, false);
    }

    @Override
    public Set<Permission> getAllowedPermissions(long templateId, long userId) {
        HashSet<Permission> permissions = new HashSet<Permission>();
        try {
            User user = (User)this.userDAO.findById(userId);
            if (user == null) {
                return permissions;
            }
            if (user.isMemberOf("admin")) {
                return Permission.all();
            }
            Set<Group> groups = user.getGroups();
            if (groups.isEmpty()) {
                return permissions;
            }
            StringBuilder query = new StringBuilder("select ld_write as LDWRITE");
            query.append(" from ld_template_acl ");
            query.append(" where ");
            query.append(" ld_templateid=" + templateId);
            query.append(" and ld_groupid in (select ld_groupid from ld_usergroup where ld_userid=");
            query.append(Long.toString(userId));
            query.append(")");
            this.queryForResultSet(query.toString(), null, null, rows -> {
                while (rows.next()) {
                    permissions.add(Permission.READ);
                    if (rows.getInt("LDWRITE") != 1) continue;
                    permissions.add(Permission.WRITE);
                }
            });
        }
        catch (Exception e) {
            this.log.error(e.getMessage(), e);
        }
        return permissions;
    }

    @Override
    public Template clone(long id, String cloneName) throws PersistenceException {
        Template originalTemplate = (Template)this.findById(id, true);
        this.initialize(originalTemplate);
        Template clonedTemplate = new Template();
        clonedTemplate.setName(cloneName);
        if (originalTemplate.getLabel() != null) {
            clonedTemplate.setLabel(originalTemplate.getLabel() + "-Clone");
        }
        clonedTemplate.setDescription(originalTemplate.getDescription());
        clonedTemplate.setReadonly(originalTemplate.getReadonly());
        clonedTemplate.setValidation(originalTemplate.getValidation());
        clonedTemplate.setTemplateAttributes(originalTemplate.getTemplateAttributes().entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue)));
        this.store(clonedTemplate);
        this.jdbcUpdate("insert into ld_template_acl(ld_templateid, ld_groupid, ld_read, ld_write) select " + clonedTemplate.getId() + ", ld_groupid, ld_read, ld_write from ld_template_acl where ld_templateid=" + id);
        this.initialize(clonedTemplate);
        return clonedTemplate;
    }
}

