/*
 * Decompiled with CFR 0.152.
 */
package com.logicaldoc.core.metadata;

import com.logicaldoc.core.HibernatePersistentObjectDAO;
import com.logicaldoc.core.PersistenceException;
import com.logicaldoc.core.PersistentObject;
import com.logicaldoc.core.metadata.Attribute;
import com.logicaldoc.core.metadata.AttributeOptionDAO;
import com.logicaldoc.core.metadata.AttributeSet;
import com.logicaldoc.core.metadata.AttributeSetDAO;
import com.logicaldoc.core.metadata.Template;
import com.logicaldoc.core.metadata.TemplateDAO;
import com.logicaldoc.util.sql.SqlUtil;
import jakarta.annotation.Resource;
import jakarta.transaction.Transactional;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Repository;

@Repository(value="attributeSetDAO")
@Transactional
public class HibernateAttributeSetDAO
extends HibernatePersistentObjectDAO<AttributeSet>
implements AttributeSetDAO {
    private static final String TENANT_ID_EQUAL = ".tenantId=";
    @Resource(name="attributeOptionDAO")
    protected AttributeOptionDAO optionsDao;
    @Resource(name="templateDAO")
    protected TemplateDAO templateDao;

    public HibernateAttributeSetDAO() {
        super(AttributeSet.class);
        this.log = LoggerFactory.getLogger(HibernateAttributeSetDAO.class);
    }

    @Override
    public List<AttributeSet> findAll() throws PersistenceException {
        return this.findByWhere(" 1=1", " order by _entity.name", null);
    }

    @Override
    public List<AttributeSet> findAll(long tenantId) throws PersistenceException {
        return this.findByWhere(" _entity.tenantId=" + tenantId, "_entity.name", null);
    }

    @Override
    public AttributeSet findByName(String name, long tenantId) throws PersistenceException {
        List coll = this.findByWhere("_entity.name = '" + SqlUtil.doubleQuotes(name) + "' and _entity.tenantId=" + tenantId, null, null);
        PersistentObject template = null;
        if (CollectionUtils.isNotEmpty(coll)) {
            template = (AttributeSet)coll.iterator().next();
        }
        if (template != null && template.getDeleted() == 1) {
            template = null;
        }
        return template;
    }

    @Override
    public void delete(long id, int code) throws PersistenceException {
        if (!this.checkStoringAspect()) {
            return;
        }
        AttributeSet set = (AttributeSet)this.findById(id);
        if (set == null) {
            return;
        }
        set.setDeleted(code);
        set.setName(set.getName() + "." + set.getId());
        this.saveOrUpdate(set);
        this.optionsDao.deleteBySetIdAndAttribute(id, null);
        List templates = this.templateDao.findAll(set.getTenantId());
        for (Template template : templates) {
            this.templateDao.store(template);
        }
    }

    @Override
    public List<AttributeSet> findByType(int type, long tenantId) throws PersistenceException {
        return this.findByWhere("_entity.type =" + type + " and _entity.tenantId=" + tenantId, "_entity.name asc", null);
    }

    @Override
    public void store(AttributeSet set) throws PersistenceException {
        if (!this.checkStoringAspect()) {
            return;
        }
        this.enforceSetSpecInAllAttributes(set);
    }

    private void enforceSetSpecInAllAttributes(AttributeSet set) throws PersistenceException {
        for (Attribute att : set.getAttributes().values()) {
            att.setSetId(set.getId());
        }
        super.store(set);
        set = (AttributeSet)this.findById(set.getId());
        this.initialize(set);
        for (Attribute att : set.getAttributes().values()) {
            att.setSetId(set.getId());
        }
        super.store(set);
        this.optionsDao.deleteOrphaned(set.getId(), set.getAttributeNames());
    }

    @Override
    public Map<Long, AttributeSet> load(long tenantId) throws PersistenceException {
        HashMap<Long, AttributeSet> map = new HashMap<Long, AttributeSet>();
        List<AttributeSet> all = this.findAll(tenantId);
        for (AttributeSet set : all) {
            map.put(set.getId(), set);
        }
        return map;
    }

    @Override
    public Map<String, Attribute> findAttributes(long tenantId, Long setId) throws PersistenceException {
        ArrayList<AttributeSet> sets = new ArrayList<AttributeSet>();
        if (setId != null) {
            sets.add((AttributeSet)this.findById(setId));
        } else {
            sets.addAll(this.findAll(tenantId));
        }
        TreeMap<String, Attribute> attributes = new TreeMap<String, Attribute>();
        for (AttributeSet set : sets) {
            this.initialize(set);
            Map<String, Attribute> localAttributes = set.getTemplateAttributes();
            for (Map.Entry<String, Attribute> entry : localAttributes.entrySet()) {
                if (attributes.containsKey(entry.getKey())) continue;
                attributes.put(entry.getKey(), entry.getValue());
            }
        }
        return attributes;
    }

    @Override
    public void initialize(AttributeSet attributeSet) throws PersistenceException {
        block2: {
            try {
                this.refresh(attributeSet);
                this.log.trace("Initialized {} attributes", (Object)attributeSet.getTemplateAttributes().size());
            }
            catch (Exception e) {
                if (!this.log.isErrorEnabled()) break block2;
                this.log.error(e.getMessage(), e);
            }
        }
    }
}

