/*
 * Decompiled with CFR 0.152.
 */
package com.logicaldoc.core.metadata;

import com.logicaldoc.core.HibernatePersistentObjectDAO;
import com.logicaldoc.core.PersistenceException;
import com.logicaldoc.core.metadata.AttributeOption;
import com.logicaldoc.core.metadata.AttributeOptionDAO;
import com.logicaldoc.util.sql.SqlUtil;
import jakarta.transaction.Transactional;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.lang.StringUtils;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Repository;

@Repository(value="attributeOptionDAO")
@Transactional
public class HibernateAttributeOptionDAO
extends HibernatePersistentObjectDAO<AttributeOption>
implements AttributeOptionDAO {
    private static final String SET_ID = "setId";

    public HibernateAttributeOptionDAO() {
        super(AttributeOption.class);
        this.log = LoggerFactory.getLogger(HibernatePersistentObjectDAO.class);
    }

    @Override
    public void deleteBySetIdAndAttribute(long setId, String attribute) throws PersistenceException {
        List<AttributeOption> options = this.findByAttribute(setId, attribute);
        for (AttributeOption option : options) {
            this.del(option, 1);
        }
    }

    @Override
    public List<AttributeOption> findByAttribute(long setId, String attribute) throws PersistenceException {
        return this.findByAttributeAndCategory(setId, attribute, null);
    }

    @Override
    public List<AttributeOption> findByAttributeAndCategory(long setId, String attribute, String category) throws PersistenceException {
        List<AttributeOption> coll;
        if (StringUtils.isEmpty(attribute)) {
            if (StringUtils.isEmpty(category)) {
                HashMap<String, Object> params = new HashMap<String, Object>();
                params.put(SET_ID, setId);
                coll = this.findByObjectQuery("from AttributeOption _opt where _opt.deleted=0 and _opt.setId = :setId order by _opt.position asc", params, null);
            } else {
                HashMap<String, Object> params = new HashMap<String, Object>();
                params.put(SET_ID, setId);
                params.put("category", category);
                coll = this.findByObjectQuery("from AttributeOption _opt where _opt.deleted=0 and _opt.setId = :setId and _opt.category = :category order by _opt.position asc", params, null);
            }
        } else if (StringUtils.isEmpty(category)) {
            HashMap<String, Object> params = new HashMap<String, Object>();
            params.put(SET_ID, setId);
            params.put("attribute", attribute);
            coll = this.findByObjectQuery("from AttributeOption _opt where _opt.deleted=0 and _opt.setId = :setId and _opt.attribute = :attribute order by _opt.position asc", params, null);
        } else {
            HashMap<String, Object> params = new HashMap<String, Object>();
            params.put(SET_ID, setId);
            params.put("category", category);
            params.put("attribute", attribute);
            coll = this.findByObjectQuery("from AttributeOption _opt where _opt.deleted=0 and _opt.setId = :setId and _opt.attribute = :attribute and _opt.category = :category order by _opt.position asc", params, null);
        }
        return coll;
    }

    @Override
    public Map<String, List<AttributeOption>> findByAttributeAsMap(long setId, String attribute) throws PersistenceException {
        List<AttributeOption> coll = this.findByAttribute(setId, attribute);
        return coll.stream().collect(Collectors.groupingBy(AttributeOption::getCategory));
    }

    @Override
    public void delete(long id, int code) throws PersistenceException {
        if (!this.checkStoringAspect()) {
            return;
        }
        AttributeOption option = (AttributeOption)this.findById(id);
        this.del(option, code);
    }

    private void del(AttributeOption option, int code) {
        if (option != null) {
            option.setDeleted(code);
            option.setValue(option.getValue() + "." + option.getId());
        }
    }

    @Override
    public void deleteOrphaned(long setId, Collection<String> currentAttributes) throws PersistenceException {
        if (currentAttributes == null || currentAttributes.isEmpty() || !this.checkStoringAspect()) {
            return;
        }
        StringBuilder buf = new StringBuilder();
        for (String name : currentAttributes) {
            if (buf.length() == 0) {
                buf.append("('");
            } else {
                buf.append(",'");
            }
            buf.append(SqlUtil.doubleQuotes(name));
            buf.append("'");
        }
        buf.append(")");
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put(SET_ID, setId);
        List<AttributeOption> options = this.findByQuery("from AttributeOption _opt where _opt.setId = :setId and _opt.attribute not in " + buf.toString(), params, AttributeOption.class, null);
        for (AttributeOption option : options) {
            this.del(option, 1);
        }
    }
}

