/*
 * Decompiled with CFR 0.152.
 */
package com.logicaldoc.core.metadata;

import com.logicaldoc.core.PersistentObject;
import com.logicaldoc.core.metadata.Attribute;
import com.logicaldoc.core.metadata.Extensible;
import jakarta.persistence.MappedSuperclass;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import org.apache.commons.collections.CollectionUtils;

@MappedSuperclass
public abstract class ExtensibleObject
extends PersistentObject
implements Extensible {
    private static final long serialVersionUID = 1L;

    @Override
    public List<Attribute> getValueAttributes(String name) {
        Set<String> valueNames = this.getValueAttributesName(name);
        ArrayList<Attribute> values = new ArrayList<Attribute>();
        for (String n : valueNames) {
            Attribute val = this.getAttributes().get(n);
            val.setName(n);
            values.add(val);
        }
        return values;
    }

    @Override
    public List<Object> getValues(String name) {
        List<Attribute> attrs = this.getValueAttributes(name);
        return attrs.stream().map(a -> a.getValue()).toList();
    }

    @Override
    public Object getValue(String name) {
        Attribute att = this.getAttribute(name);
        if (att != null) {
            return att.getValue();
        }
        return null;
    }

    @Override
    public Attribute getAttribute(String name) {
        if (this.getAttributes() != null && this.getAttributes().get(name) != null) {
            return this.getAttributes().get(name);
        }
        return null;
    }

    @Override
    public List<String> getAttributeNames() {
        List<String> names = new ArrayList<String>();
        if (this.getAttributes() != null) {
            names = this.getAttributes().keySet().stream().toList();
        }
        return names;
    }

    @Override
    public List<String> getAttributeNames(long setId) {
        ArrayList<String> names = new ArrayList<String>();
        if (this.getAttributes() != null) {
            for (String name : this.getAttributes().keySet()) {
                Attribute att = this.getAttribute(name);
                if (att.getSetId() == null || setId != att.getSetId()) continue;
                names.add(name);
            }
        }
        return names;
    }

    @Override
    public void removeAttribute(String name) {
        if (this.getAttributes() != null && this.getAttributes().containsKey(name)) {
            Set<String> valueNames = this.getValueAttributesName(name);
            for (String n : valueNames) {
                this.getAttributes().remove(n);
            }
        }
    }

    @Override
    public Attribute getAttributeAtPosition(int position) {
        if (position < 0) {
            return null;
        }
        ArrayList<Attribute> attrs = new ArrayList<Attribute>(this.getAttributes().values());
        if (position >= attrs.size()) {
            return null;
        }
        Attribute attribute = null;
        for (Attribute extendedAttribute : attrs) {
            if (extendedAttribute.getPosition() != position) continue;
            attribute = extendedAttribute;
            break;
        }
        return attribute;
    }

    @Override
    public List<Attribute> setValues(String name, List<Object> values) {
        Set<String> valNames = this.getValueAttributesName(name);
        for (String n : valNames) {
            if (name.equals(n)) continue;
            this.removeAttribute(n);
        }
        ArrayList<Attribute> attrs = new ArrayList<Attribute>();
        if (CollectionUtils.isEmpty(values)) {
            return attrs;
        }
        Attribute master = this.setValue(name, values.get(0));
        attrs.add(master);
        if (values.size() > 1) {
            master.setMultiple(1);
            DecimalFormat nf = new DecimalFormat("0000");
            int i = 1;
            while (i < values.size()) {
                Attribute attribute = this.setValue(name + "-" + nf.format(i), values.get(i));
                attribute.setParent(name);
                attrs.add(attribute);
                ++i;
            }
        }
        for (Attribute attribute : attrs) {
            attribute.setPosition(master.getPosition());
        }
        return attrs;
    }

    @Override
    public void setAttribute(String name, Attribute attribute) {
        Attribute newAttribute = new Attribute(attribute);
        Attribute oldAttribute = this.getAttributes().get(name);
        if (oldAttribute != null) {
            newAttribute.setPosition(oldAttribute.getPosition());
            newAttribute.setLabel(oldAttribute.getLabel());
        } else {
            newAttribute.setPosition(this.getLastPosition() + 1);
        }
        this.getAttributes().put(name, newAttribute);
    }

    @Override
    public Attribute setValue(String name, Object value) {
        Attribute ext = this.getAttribute(name);
        if (ext == null) {
            ext = new Attribute();
            ext.setPosition(this.getLastPosition() + 1);
        }
        ext.setValue(value);
        this.getAttributes().put(name, ext);
        return this.getAttributes().get(name);
    }

    protected int getLastPosition() {
        int position = 0;
        if (this.getAttributes() != null) {
            for (Attribute att : this.getAttributes().values()) {
                if (position >= att.getPosition()) continue;
                position = att.getPosition();
            }
        }
        return position;
    }

    protected Set<String> getValueAttributesName(String name) {
        TreeSet<String> attNames = new TreeSet<String>();
        for (String n : this.getAttributes().keySet()) {
            if (!n.equals(name) && !name.equals(this.getAttribute(n).getParent())) continue;
            attNames.add(n);
        }
        return attNames;
    }
}

