/*
 * Decompiled with CFR 0.152.
 */
package com.logicaldoc.core.metadata;

import com.logicaldoc.core.PersistentObject;
import jakarta.persistence.Cacheable;
import jakarta.persistence.Column;
import jakarta.persistence.Entity;
import jakarta.persistence.Table;

@Entity
@Table(name="ld_extoption")
@Cacheable
public class AttributeOption
extends PersistentObject
implements Comparable<AttributeOption> {
    private static final long serialVersionUID = 1L;
    @Column(name="ld_setid", nullable=false)
    private long setId;
    @Column(name="ld_attribute", nullable=false)
    private String attribute;
    @Column(name="ld_value", nullable=false)
    private String value;
    @Column(name="ld_category")
    private String category;
    @Column(name="ld_label")
    private String label;
    @Column(name="ld_position", nullable=false)
    private int position = 0;

    public AttributeOption() {
    }

    public AttributeOption(long setId, String attribute, String value, String category) {
        this(setId, attribute, value);
        this.category = category;
    }

    public AttributeOption(long setId, String attribute, String value) {
        this();
        this.setId = setId;
        this.attribute = attribute;
        this.value = value;
    }

    public long getSetId() {
        return this.setId;
    }

    public void setSetId(long setId) {
        this.setId = setId;
    }

    public String getAttribute() {
        return this.attribute;
    }

    public void setAttribute(String attribute) {
        this.attribute = attribute;
    }

    public String getValue() {
        return this.value;
    }

    public void setValue(String value) {
        this.value = value;
    }

    public String getLabel() {
        return this.label;
    }

    public void setLabel(String label) {
        this.label = label;
    }

    public int getPosition() {
        return this.position;
    }

    public void setPosition(int position) {
        this.position = position;
    }

    public String getCategory() {
        return this.category;
    }

    public void setCategory(String category) {
        this.category = category;
    }

    @Override
    public int compareTo(AttributeOption other) {
        if (this.equals(other)) {
            return 0;
        }
        return Integer.compare(this.position, other.position);
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = super.hashCode();
        result = 31 * result + (int)(this.setId ^ this.setId >>> 32);
        result = 31 * result + (this.value == null ? 0 : this.value.hashCode());
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        AttributeOption other = (AttributeOption)obj;
        if (this.setId != other.setId) {
            return false;
        }
        return !(this.value == null ? other.value != null : !this.value.equals(other.value));
    }
}

