/*
 * Decompiled with CFR 0.152.
 */
package com.logicaldoc.core.metadata;

import com.logicaldoc.core.metadata.Attribute;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.stream.Collectors;

class AttributeMapWrapper
extends HashMap<String, Attribute> {
    private static final long serialVersionUID = 1L;
    private Map<String, Attribute> wrappedAttributesMap;

    public AttributeMapWrapper(Map<String, Attribute> wrappedAttributesMap) {
        this.wrappedAttributesMap = wrappedAttributesMap;
    }

    @Override
    public int size() {
        return this.wrappedAttributesMap.size();
    }

    @Override
    public boolean isEmpty() {
        return this.wrappedAttributesMap.isEmpty();
    }

    @Override
    public boolean containsKey(Object key) {
        return this.wrappedAttributesMap.containsKey(key);
    }

    @Override
    public boolean containsValue(Object value) {
        return this.wrappedAttributesMap.containsValue(value);
    }

    @Override
    public Attribute get(Object key) {
        return this.wrappedAttributesMap.get(key);
    }

    @Override
    public Attribute put(String key, Attribute value) {
        if (value instanceof Attribute) {
            Attribute ta = value;
            return this.wrappedAttributesMap.put(key, ta);
        }
        return null;
    }

    @Override
    public Attribute remove(Object key) {
        return this.wrappedAttributesMap.remove(key);
    }

    @Override
    public void putAll(Map<? extends String, ? extends Attribute> m) {
        for (Map.Entry<String, Attribute> e : m.entrySet().stream().collect(Collectors.toMap(String.class::cast, v -> (Attribute)((Object)v))).entrySet()) {
            Attribute attribute = e.getValue();
            if (!(attribute instanceof Attribute)) continue;
            Attribute ta = attribute;
            this.wrappedAttributesMap.put(e.getKey(), ta);
        }
    }

    @Override
    public void clear() {
        this.wrappedAttributesMap.clear();
    }

    @Override
    public Set<String> keySet() {
        return this.wrappedAttributesMap.keySet();
    }

    @Override
    public Collection<Attribute> values() {
        return this.wrappedAttributesMap.values();
    }

    @Override
    public Set<Map.Entry<String, Attribute>> entrySet() {
        return this.wrappedAttributesMap.entrySet().stream().map(e -> new Map.Entry<String, Attribute>(){

            @Override
            public String getKey() {
                return (String)e.getKey();
            }

            @Override
            public Attribute getValue() {
                return (Attribute)e.getValue();
            }

            @Override
            public Attribute setValue(Attribute value) {
                if (value instanceof Attribute) {
                    Attribute tv = value;
                    return e.setValue(tv);
                }
                return value;
            }
        }).collect(Collectors.toSet());
    }

    @Override
    public boolean equals(Object o) {
        return this.wrappedAttributesMap.equals(o);
    }

    @Override
    public int hashCode() {
        return this.wrappedAttributesMap.hashCode();
    }

    @Override
    public Attribute getOrDefault(Object key, Attribute defaultValue) {
        Attribute ta = this.wrappedAttributesMap.get(key);
        if (ta != null) {
            return ta;
        }
        return defaultValue;
    }

    @Override
    public void forEach(BiConsumer<? super String, ? super Attribute> action) {
        this.wrappedAttributesMap.forEach(action);
    }

    @Override
    public void replaceAll(BiFunction<? super String, ? super Attribute, ? extends Attribute> function) {
        throw new UnsupportedOperationException();
    }

    @Override
    public Attribute putIfAbsent(String key, Attribute value) {
        if (value instanceof Attribute) {
            Attribute ta = value;
            return this.wrappedAttributesMap.putIfAbsent(key, ta);
        }
        return null;
    }

    @Override
    public boolean remove(Object key, Object value) {
        return this.wrappedAttributesMap.remove(key, value);
    }

    @Override
    public boolean replace(String key, Attribute oldValue, Attribute newValue) {
        if (oldValue instanceof Attribute) {
            Attribute oldTA = oldValue;
            if (newValue instanceof Attribute) {
                Attribute newTA = newValue;
                return this.wrappedAttributesMap.replace(key, oldTA, newTA);
            }
        }
        return false;
    }

    @Override
    public Attribute replace(String key, Attribute value) {
        if (value instanceof Attribute) {
            Attribute ta = value;
            return this.wrappedAttributesMap.replace(key, ta);
        }
        return null;
    }

    @Override
    public Attribute computeIfAbsent(String key, Function<? super String, ? extends Attribute> mappingFunction) {
        throw new UnsupportedOperationException();
    }

    @Override
    public Attribute computeIfPresent(String key, BiFunction<? super String, ? super Attribute, ? extends Attribute> remappingFunction) {
        throw new UnsupportedOperationException();
    }

    @Override
    public Attribute compute(String key, BiFunction<? super String, ? super Attribute, ? extends Attribute> remappingFunction) {
        throw new UnsupportedOperationException();
    }

    @Override
    public Attribute merge(String key, Attribute value, BiFunction<? super Attribute, ? super Attribute, ? extends Attribute> remappingFunction) {
        throw new UnsupportedOperationException();
    }
}

