/*
 * Decompiled with CFR 0.152.
 */
package com.logicaldoc.core.metadata;

import com.logicaldoc.core.document.Document;
import com.logicaldoc.core.folder.Folder;
import com.logicaldoc.core.security.user.User;
import jakarta.annotation.Nullable;
import jakarta.persistence.Column;
import jakarta.persistence.Embeddable;
import jakarta.persistence.Transient;
import java.io.Serializable;
import java.lang.runtime.SwitchBootstraps;
import java.util.Date;
import java.util.Objects;

@Embeddable
public class Attribute
implements Comparable<Attribute>,
Serializable {
    private static final long serialVersionUID = 1L;
    public static final int TYPE_STRING = 0;
    public static final int TYPE_INT = 1;
    public static final int TYPE_DOUBLE = 2;
    public static final int TYPE_DATE = 3;
    public static final int TYPE_USER = 4;
    public static final int TYPE_BOOLEAN = 5;
    public static final int TYPE_FOLDER = 6;
    public static final int TYPE_DOCUMENT = 7;
    public static final int TYPE_SECTION = 8;
    public static final int EDITOR_DEFAULT = 0;
    public static final int EDITOR_LISTBOX = 1;
    @Transient
    protected String name;
    @Column(name="ld_label", length=255)
    protected String label;
    @Column(name="ld_parent", length=255)
    protected String parent;
    @Column(name="ld_dependson", length=255)
    protected String dependsOn;
    @Column(name="ld_setid")
    protected Long setId;
    @Column(name="ld_mandatory", nullable=false)
    protected int mandatory = 0;
    @Column(name="ld_hidden", nullable=false)
    protected int hidden = 0;
    @Column(name="ld_readonly", nullable=false)
    protected int readonly = 0;
    @Column(name="ld_multiple", nullable=false)
    protected int multiple = 0;
    @Column(name="ld_type", nullable=false)
    protected int type = 0;
    @Column(name="ld_editor", nullable=false)
    protected int editor = 0;
    @Column(name="ld_position", nullable=false)
    protected int position = 0;
    @Column(name="ld_stringvalue")
    protected String stringValue;
    @Column(name="ld_stringvalues")
    protected String stringValues;
    @Column(name="ld_intvalue")
    protected Long intValue;
    @Column(name="ld_doublevalue")
    protected Double doubleValue;
    @Column(name="ld_datevalue", columnDefinition="DATETIME(3)")
    protected Date dateValue;
    @Column(name="ld_validation")
    private String validation;
    @Column(name="ld_initialization")
    private String initialization;

    public Attribute() {
    }

    public Attribute(Attribute source) {
        this.name = source.name;
        this.label = source.label;
        this.stringValue = source.stringValue;
        this.stringValues = source.stringValues;
        this.intValue = source.intValue;
        this.doubleValue = source.doubleValue;
        this.dateValue = source.dateValue;
        this.type = source.type;
        this.hidden = source.hidden;
        this.readonly = source.readonly;
        this.mandatory = source.mandatory;
        this.position = source.position;
        this.editor = source.editor;
        this.setId = source.setId;
        this.multiple = source.multiple;
        this.parent = source.parent;
        this.dependsOn = source.dependsOn;
        this.validation = source.validation;
        this.initialization = source.initialization;
    }

    public String getStringValue() {
        return this.stringValue;
    }

    public void setStringValue(String stringValue) {
        this.stringValue = stringValue;
    }

    public Long getIntValue() {
        return this.intValue;
    }

    public void setIntValue(Long intValue) {
        this.intValue = intValue;
    }

    public Double getDoubleValue() {
        return this.doubleValue;
    }

    public void setDoubleValue(Double doubleValue) {
        this.doubleValue = doubleValue;
    }

    public Date getDateValue() {
        return this.dateValue;
    }

    public void setDateValue(Date dateValue) {
        this.dateValue = dateValue;
    }

    @Nullable
    public Boolean getBooleanValue() {
        if (this.intValue != null) {
            if (this.intValue.intValue() == 1) {
                return true;
            }
            return false;
        }
        return null;
    }

    public void setBooleanValue(Boolean booleanValue) {
        this.type = 5;
        this.intValue = booleanValue != null ? Long.valueOf(booleanValue != false ? 1L : 0L) : null;
    }

    public int getType() {
        return this.type;
    }

    public void setType(int type) {
        this.type = type;
    }

    public boolean isSection() {
        return this.type == 8;
    }

    public Object getValue() {
        switch (this.type) {
            case 2: {
                return this.getDoubleValue();
            }
            case 3: {
                return this.getDateValue();
            }
            case 1: 
            case 4: 
            case 6: 
            case 7: {
                return this.getIntValue();
            }
            case 5: {
                if (this.getIntValue() == null) {
                    return null;
                }
                if (this.getIntValue().intValue() == 1) {
                    return true;
                }
                return false;
            }
        }
        return this.getStringValue();
    }

    public Object getDisplayValue() {
        if (this.type == 4 || this.type == 7) {
            return this.getStringValue();
        }
        return this.getValue();
    }

    public void setValue(Object value) {
        if (value == null) {
            this.setStringValue(null);
            this.setIntValue(null);
            this.setDoubleValue(null);
            this.setDateValue(null);
            this.setBooleanValue(null);
            return;
        }
        Object object = value;
        Objects.requireNonNull(object);
        Object object2 = object;
        int n = 0;
        switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{String.class, Integer.class, Long.class, Double.class, Date.class, User.class, Folder.class, Document.class, Boolean.class}, (Object)object2, n)) {
            case 0: {
                String string = (String)object2;
                this.type = 0;
                this.setStringValue(string);
                break;
            }
            case 1: {
                Integer integer = (Integer)object2;
                this.type = 1;
                this.setIntValue((long)integer);
                break;
            }
            case 2: {
                Long longVal = (Long)object2;
                this.type = 1;
                this.setIntValue(longVal);
                break;
            }
            case 3: {
                Double doubleVal = (Double)object2;
                this.type = 2;
                this.setDoubleValue(doubleVal);
                break;
            }
            case 4: {
                Date date = (Date)object2;
                this.type = 3;
                this.setDateValue(date);
                break;
            }
            case 5: {
                User user = (User)object2;
                this.type = 4;
                this.intValue = user.getId();
                this.stringValue = user.getUsername();
                break;
            }
            case 6: {
                Folder folder = (Folder)object2;
                this.type = 6;
                this.intValue = folder.getId();
                this.stringValue = folder.getName();
                break;
            }
            case 7: {
                Document document = (Document)object2;
                this.type = 7;
                this.intValue = document.getId();
                this.stringValue = document.getFileName();
                break;
            }
            case 8: {
                Boolean bool = (Boolean)object2;
                this.type = 5;
                this.intValue = bool != false ? 1L : 0L;
                break;
            }
            default: {
                throw new IllegalArgumentException("Not a String, Long, Double, Date, Boolean, User, Folder value");
            }
        }
    }

    public int getMandatory() {
        return this.mandatory;
    }

    public void setMandatory(int mandatory) {
        this.mandatory = mandatory;
    }

    public int getPosition() {
        return this.position;
    }

    public void setPosition(int position) {
        this.position = position;
    }

    @Override
    public int compareTo(Attribute o) {
        return Integer.compare(this.getPosition(), o.getPosition());
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.name == null ? 0 : this.name.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Attribute other = (Attribute)obj;
        return !(this.name == null ? other.name != null : !this.name.equals(other.name));
    }

    public String getLabel() {
        return this.label;
    }

    public void setLabel(String label) {
        this.label = label;
    }

    public int getEditor() {
        return this.editor;
    }

    public void setEditor(int editor) {
        this.editor = editor;
    }

    public int getHidden() {
        return this.hidden;
    }

    public void setHidden(int hidden) {
        this.hidden = hidden;
    }

    public Long getSetId() {
        return this.setId;
    }

    public void setSetId(Long setId) {
        this.setId = setId;
    }

    public int getMultiple() {
        return this.multiple;
    }

    public void setMultiple(int multiple) {
        this.multiple = multiple;
    }

    public String getParent() {
        return this.parent;
    }

    public void setParent(String parent) {
        this.parent = parent;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getStringValues() {
        return this.stringValues;
    }

    public void setStringValues(String stringValues) {
        this.stringValues = stringValues;
    }

    public String getDependsOn() {
        return this.dependsOn;
    }

    public void setDependsOn(String dependsOn) {
        this.dependsOn = dependsOn;
    }

    public int getReadonly() {
        return this.readonly;
    }

    public void setReadonly(int readonly) {
        this.readonly = readonly;
    }

    public String getValidation() {
        return this.validation;
    }

    public void setValidation(String validation) {
        this.validation = validation;
    }

    public String getInitialization() {
        return this.initialization;
    }

    public void setInitialization(String initialization) {
        this.initialization = initialization;
    }
}

