/*
 * Decompiled with CFR 0.152.
 */
package com.logicaldoc.core.metadata;

import com.logicaldoc.core.metadata.Attribute;
import com.logicaldoc.core.metadata.AttributeMapWrapper;
import com.logicaldoc.core.metadata.ExtensibleObject;
import com.logicaldoc.core.metadata.Template;
import jakarta.persistence.Column;
import jakarta.persistence.MappedSuperclass;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import org.apache.commons.collections.CollectionUtils;

@MappedSuperclass
public abstract class AbstractAttributeSet
extends ExtensibleObject {
    private static final long serialVersionUID = 1L;
    public static final int TYPE_DEFAULT = 0;
    @Column(name="ld_name", length=255, nullable=false)
    private String name;
    @Column(name="ld_label", length=255)
    private String label;
    @Column(name="ld_description", length=2000)
    private String description;
    @Column(name="ld_readonly", nullable=false)
    private int readonly = 0;
    @Column(name="ld_type", nullable=false)
    private int type = 0;

    public abstract Map<String, Attribute> getTemplateAttributes();

    public abstract void setTemplateAttributes(Map<String, Attribute> var1);

    public Attribute getTemplateAttribute(String name) {
        return this.getTemplateAttributes().get(name);
    }

    @Override
    public Map<String, Attribute> getAttributes() {
        return new AttributeMapWrapper(this.getTemplateAttributes());
    }

    @Override
    public void setAttributes(Map<String, Attribute> attributes) {
        this.getTemplateAttributes().clear();
        for (Map.Entry<String, Attribute> att : attributes.entrySet()) {
            Attribute attribute = att.getValue();
            if (!(attribute instanceof Attribute)) continue;
            Attribute ta = attribute;
            this.getTemplateAttributes().put(att.getKey(), ta);
        }
    }

    @Override
    public List<Attribute> getValueAttributes(String name) {
        Set<String> valueNames = this.getValueAttributesName(name);
        ArrayList<Attribute> values = new ArrayList<Attribute>();
        for (String n : valueNames) {
            Attribute val = this.getTemplateAttributes().get(n);
            val.setName(n);
            values.add(val);
        }
        return values;
    }

    @Override
    protected Set<String> getValueAttributesName(String name) {
        TreeSet<String> attNames = new TreeSet<String>();
        for (String n : this.getTemplateAttributes().keySet()) {
            if (!n.equals(name) && !name.equals(this.getAttribute(n).getParent())) continue;
            attNames.add(n);
        }
        return attNames;
    }

    @Override
    public List<Object> getValues(String name) {
        List<Attribute> attrs = this.getValueAttributes(name);
        return attrs.stream().map(a -> a.getValue()).toList();
    }

    @Override
    public Object getValue(String name) {
        Attribute att = this.getAttribute(name);
        if (att != null) {
            return att.getValue();
        }
        return null;
    }

    @Override
    public Attribute getAttribute(String name) {
        if (this.getTemplateAttributes() != null && this.getTemplateAttributes().get(name) != null) {
            return this.getTemplateAttributes().get(name);
        }
        return null;
    }

    @Override
    public List<String> getAttributeNames() {
        List<String> names = new ArrayList<String>();
        if (this.getTemplateAttributes() != null) {
            names = this.getTemplateAttributes().keySet().stream().toList();
        }
        return names;
    }

    @Override
    public List<String> getAttributeNames(long setId) {
        ArrayList<String> names = new ArrayList<String>();
        if (this.getTemplateAttributes() != null) {
            for (String attributeName : this.getTemplateAttributes().keySet()) {
                Attribute att = this.getAttribute(attributeName);
                if (att.getSetId() == null || setId != att.getSetId()) continue;
                names.add(attributeName);
            }
        }
        return names;
    }

    @Override
    public void removeAttribute(String name) {
        if (this.getTemplateAttributes() != null && this.getTemplateAttributes().containsKey(name)) {
            Set<String> valueNames = this.getValueAttributesName(name);
            for (String n : valueNames) {
                this.getTemplateAttributes().remove(n);
            }
        }
    }

    @Override
    public Attribute getAttributeAtPosition(int position) {
        if (position < 0) {
            return null;
        }
        ArrayList<Attribute> attrs = new ArrayList<Attribute>(this.getTemplateAttributes().values());
        if (position >= attrs.size()) {
            return null;
        }
        Attribute attribute = null;
        for (Attribute extendedAttribute : attrs) {
            if (extendedAttribute.getPosition() != position) continue;
            attribute = extendedAttribute;
            break;
        }
        return attribute;
    }

    @Override
    public List<Attribute> setValues(String name, List<Object> values) {
        Set<String> valNames = this.getValueAttributesName(name);
        for (String n : valNames) {
            if (name.equals(n)) continue;
            this.removeAttribute(n);
        }
        ArrayList<Attribute> attrs = new ArrayList<Attribute>();
        if (CollectionUtils.isEmpty(values)) {
            return attrs;
        }
        Attribute master = this.setValue(name, values.get(0));
        attrs.add(master);
        if (values.size() > 1) {
            master.setMultiple(1);
            DecimalFormat nf = new DecimalFormat("0000");
            int i = 1;
            while (i < values.size()) {
                Attribute attribute = this.setValue(name + "-" + nf.format(i), values.get(i));
                attribute.setParent(name);
                attrs.add(attribute);
                ++i;
            }
        }
        for (Attribute attribute : attrs) {
            attribute.setPosition(master.getPosition());
        }
        return attrs;
    }

    @Override
    public void setAttribute(String name, Attribute attr) {
        if (attr instanceof Attribute) {
            Attribute attribute = attr;
            Attribute newAttribute = new Attribute(attribute);
            Attribute oldAttribute = this.getTemplateAttributes().get(name);
            if (oldAttribute != null) {
                newAttribute.setPosition(oldAttribute.getPosition());
                newAttribute.setLabel(oldAttribute.getLabel());
            } else {
                newAttribute.setPosition(this.getLastPosition() + 1);
            }
            this.getTemplateAttributes().put(name, newAttribute);
        }
    }

    @Override
    public Attribute setValue(String name, Object value) {
        Attribute ext = this.getAttribute(name);
        if (ext == null) {
            ext = new Attribute();
            ext.setPosition(this.getLastPosition() + 1);
        }
        ext.setValue(value);
        this.getTemplateAttributes().put(name, ext);
        return ext;
    }

    @Override
    protected int getLastPosition() {
        int position = 0;
        if (this.getTemplateAttributes() != null) {
            for (Attribute att : this.getTemplateAttributes().values()) {
                if (position >= att.getPosition()) continue;
                position = att.getPosition();
            }
        }
        return position;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public int getReadonly() {
        return this.readonly;
    }

    public void setReadonly(int readonly) {
        this.readonly = readonly;
    }

    public int getType() {
        return this.type;
    }

    public void setType(int type) {
        this.type = type;
    }

    public String getLabel() {
        return this.label;
    }

    public void setLabel(String label) {
        this.label = label;
    }

    @Override
    public Long getTemplateId() {
        return null;
    }

    @Override
    public void setTemplateId(Long templateId) {
    }

    @Override
    public String getTemplateName() {
        return null;
    }

    @Override
    public void setTemplateName(String templateName) {
    }

    @Override
    public Template getTemplate() {
        return null;
    }

    @Override
    public void setTemplate(Template template) {
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = super.hashCode();
        result = 31 * result + (this.name == null ? 0 : this.name.hashCode());
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        AbstractAttributeSet other = (AbstractAttributeSet)obj;
        return !(this.name == null ? other.name != null : !this.name.equals(other.name));
    }
}

