/*
 * Decompiled with CFR 0.152.
 */
package com.logicaldoc.core.lock;

import com.logicaldoc.core.PersistenceException;
import com.logicaldoc.core.generic.Generic;
import com.logicaldoc.core.generic.GenericDAO;
import com.logicaldoc.util.config.ContextProperties;
import jakarta.annotation.Resource;
import java.util.ArrayList;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component(value="lockManager")
public class LockManager {
    private static final String LOCK = "lock";
    protected Logger log = LoggerFactory.getLogger(LockManager.class);
    @Resource(name="genericDAO")
    protected GenericDAO genericDao;
    @Resource(name="ContextProperties")
    protected ContextProperties config;

    public List<String> getAllTransactions() {
        try {
            return this.genericDao.queryForList("select ld_string1 from ld_generic where ld_type='lock' and ld_string1 is not null", String.class);
        }
        catch (PersistenceException e) {
            this.log.error(e.getMessage(), e);
            return new ArrayList<String>();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean get(String lockName, String transactionId) {
        GregorianCalendar cal = new GregorianCalendar();
        cal.add(13, this.config.getInt("lock.wait", 10));
        Date ldDate = cal.getTime();
        while (new Date().before(ldDate)) {
            block8: {
                if (!this.getInternal(lockName, transactionId)) break block8;
                this.log.debug("Acquired lock {}", (Object)lockName);
                return true;
            }
            try {
                LockManager lockManager = this;
                synchronized (lockManager) {
                    this.wait(1000L);
                }
            }
            catch (PersistenceException e) {
                this.log.warn(e.getMessage(), e);
            }
            catch (InterruptedException ie) {
                this.log.warn("Interrupted", ie);
                Thread.currentThread().interrupt();
            }
        }
        this.log.warn("Unable to get lock  {}", (Object)lockName);
        return false;
    }

    private String getSubType(String lockName) {
        return lockName + "-" + this.config.getProperty("id");
    }

    public void release(String lockName, String transactionId) throws PersistenceException {
        if (lockName == null || transactionId == null) {
            return;
        }
        Generic lock = this.genericDao.findByAlternateKey(LOCK, this.getSubType(lockName), null, 1L);
        if (lock != null && transactionId.equals(lock.getString1())) {
            lock.setDate1(null);
            lock.setString1(null);
            try {
                this.genericDao.store(lock);
            }
            catch (PersistenceException e) {
                this.log.warn(e.getMessage(), e);
            }
        }
    }

    protected boolean getInternal(String lockName, String transactionId) throws PersistenceException {
        Date today = new Date();
        Generic lock = this.genericDao.findByAlternateKey(LOCK, this.getSubType(lockName), null, 1L);
        try {
            if (lock == null) {
                this.log.debug("Lock {} not found", (Object)lockName);
                lock = new Generic(LOCK, this.getSubType(lockName));
                lock.setString1(transactionId);
                lock.setDate1(today);
            }
            GregorianCalendar cal = new GregorianCalendar();
            cal.add(13, -this.config.getInt("lock.ttl"));
            Date ldDate = cal.getTime();
            if (lock.getDate1() == null || lock.getDate1().before(ldDate)) {
                this.log.debug("Lock {} expired", (Object)lockName);
                lock.setDate1(today);
                lock.setString1(transactionId);
            }
            if (lock.getString1() == null || transactionId.equals(lock.getString1())) {
                lock.setDate1(today);
                lock.setString1(transactionId);
                return true;
            }
            return false;
        }
        finally {
            try {
                this.genericDao.store(lock);
            }
            catch (PersistenceException e) {
                this.log.warn(e.getMessage(), e);
            }
        }
    }
}

