/*
 * Decompiled with CFR 0.152.
 */
package com.logicaldoc.core.job;

import com.logicaldoc.core.job.AbstractJob;
import com.logicaldoc.util.config.ContextProperties;
import jakarta.annotation.Resource;
import java.lang.runtime.SwitchBootstraps;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.time.DateUtils;
import org.quartz.CronScheduleBuilder;
import org.quartz.JobBuilder;
import org.quartz.JobDataMap;
import org.quartz.JobDetail;
import org.quartz.JobKey;
import org.quartz.ScheduleBuilder;
import org.quartz.Scheduler;
import org.quartz.SchedulerException;
import org.quartz.SimpleScheduleBuilder;
import org.quartz.Trigger;
import org.quartz.TriggerBuilder;
import org.quartz.TriggerKey;
import org.quartz.impl.matchers.GroupMatcher;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component(value="jobManager")
public class JobManager {
    public static final String JOB = "job";
    public static final String TENANT_ID = "tenantId";
    public static final String MISSFIRE_RUNNOW = "runnow";
    public static final String MISSFIRE_IGNORE = "ignore";
    private static final Logger log = LoggerFactory.getLogger(JobManager.class);
    @Resource(name="Scheduler")
    protected Scheduler scheduler;
    @Resource(name="ContextProperties")
    protected ContextProperties config;

    public void schedule(AbstractJob job, Map<String, Object> dictionary, Object ... triggers) throws SchedulerException {
        HashMap<Object, Map<String, Object>> trgs = new HashMap<Object, Map<String, Object>>();
        Object[] objectArray = triggers;
        int n = triggers.length;
        int n2 = 0;
        while (n2 < n) {
            Object trigger = objectArray[n2];
            trgs.put(trigger, new HashMap());
            ++n2;
        }
        this.schedule(job, dictionary, trgs);
    }

    public void schedule(AbstractJob job, Map<String, Object> dictionary, Map<Object, Map<String, Object>> triggers) throws SchedulerException {
        dictionary = dictionary == null ? new HashMap<String, Object>() : new HashMap<String, Object>(dictionary);
        dictionary.computeIfAbsent(TENANT_ID, k -> job.getTenantId());
        dictionary.computeIfAbsent(JOB, k -> job);
        JobKey jobKey = JobKey.jobKey((String)job.getName(), (String)job.getGroup());
        JobDetail jobDetail = this.scheduler.getJobDetail(jobKey);
        if (jobDetail != null) {
            this.scheduler.deleteJob(jobKey);
        }
        jobDetail = JobBuilder.newJob(job.getClass()).withIdentity(job.getName(), job.getGroup()).withDescription(job.getDescription() != null ? job.getDescription() : "").usingJobData(new JobDataMap(dictionary)).build();
        HashSet<Trigger> trgs = new HashSet<Trigger>();
        for (Object triggerSpec : triggers.keySet()) {
            Trigger trig = this.prepareTrigger(job, triggerSpec, triggers);
            trgs.add(trig);
        }
        this.scheduler.scheduleJob(jobDetail, trgs, true);
    }

    public void scheduleNow(AbstractJob job, Map<String, Object> dictionary) throws SchedulerException {
        this.schedule(job, dictionary, DateUtils.addMilliseconds((Date)new Date(), (int)500));
    }

    private Trigger prepareTrigger(AbstractJob job, Object triggerSpec, Map<Object, Map<String, Object>> triggersMap) {
        if (!triggersMap.get(triggerSpec).containsKey(TENANT_ID)) {
            triggersMap.get(triggerSpec).put(TENANT_ID, job.getTenantId());
        }
        Object object = triggerSpec;
        Objects.requireNonNull(object);
        Object object2 = object;
        int n = 0;
        return switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{Date.class, String.class}, (Object)object2, n)) {
            case 0 -> {
                Date dateSpec = (Date)object2;
                SimpleScheduleBuilder schedule = SimpleScheduleBuilder.simpleSchedule();
                schedule = MISSFIRE_RUNNOW.equals(this.getMissfireInstruction(job.getGroup())) ? schedule.withMisfireHandlingInstructionFireNow() : schedule.withMisfireHandlingInstructionIgnoreMisfires();
                SimpleDateFormat df = new SimpleDateFormat("yyyyMMdd_HHmmss");
                yield TriggerBuilder.newTrigger().withIdentity(job.getName() + "-" + df.format(triggerSpec), job.getGroup()).usingJobData(new JobDataMap(triggersMap.get(triggerSpec))).startAt(dateSpec).withSchedule((ScheduleBuilder)schedule).build();
            }
            case 1 -> {
                String cronSpec = (String)object2;
                CronScheduleBuilder schedule = CronScheduleBuilder.cronSchedule((String)cronSpec);
                schedule = MISSFIRE_RUNNOW.equals(this.getMissfireInstruction(job.getGroup())) ? schedule.withMisfireHandlingInstructionFireAndProceed() : schedule.withMisfireHandlingInstructionDoNothing();
                yield TriggerBuilder.newTrigger().withIdentity(job.getName() + "-" + String.valueOf(triggerSpec), job.getGroup()).usingJobData(new JobDataMap(triggersMap.get(triggerSpec))).withSchedule((ScheduleBuilder)schedule).build();
            }
            default -> {
                log.warn("Skipping trigger {} because not a string nor a date", triggerSpec);
                yield null;
            }
        };
    }

    public String getMissfireInstruction(String group) {
        return this.config.getProperty("job." + group + ".missfire", MISSFIRE_RUNNOW);
    }

    public int getMissfireMax(String group) {
        return this.config.getInt("job." + group + ".missfire.max", 2);
    }

    public List<String> getGroups() throws SchedulerException {
        return this.scheduler.getJobGroupNames();
    }

    public List<JobDetail> getJobs(String group, Long tenantId) throws SchedulerException {
        Set jobKeys = this.scheduler.getJobKeys(StringUtils.isNotEmpty((CharSequence)group) ? GroupMatcher.groupEquals((String)group) : GroupMatcher.anyJobGroup());
        ArrayList<JobDetail> jobs = new ArrayList<JobDetail>();
        for (JobKey key : jobKeys) {
            JobDetail job = this.getJob(key.getName(), key.getGroup());
            if (tenantId != null && !tenantId.equals(job.getJobDataMap().get((Object)TENANT_ID))) continue;
            jobs.add(job);
        }
        jobs.sort((jobDetails1, jobDetails2) -> {
            int cmp = jobDetails1.getKey().getGroup().compareTo(jobDetails2.getKey().getGroup());
            if (cmp == 0) {
                cmp = jobDetails1.getKey().getName().compareTo(jobDetails2.getKey().getName());
            }
            return cmp;
        });
        return jobs;
    }

    public JobDetail getJob(String name, String group) throws SchedulerException {
        return this.scheduler.getJobDetail(JobKey.jobKey((String)name, (String)group));
    }

    public List<Trigger> getTriggersOfJob(String name, String group) throws SchedulerException {
        return this.scheduler.getTriggersOfJob(JobKey.jobKey((String)name, (String)group)).stream().collect(Collectors.toList());
    }

    public void unscheduleJob(String name, String group) throws SchedulerException {
        JobDetail job;
        if (this.scheduler != null && (job = this.scheduler.getJobDetail(JobKey.jobKey((String)name, (String)group))) != null) {
            this.scheduler.deleteJob(JobKey.jobKey((String)name, (String)group));
        }
    }

    public void unscheduleTrigger(String name, String group) throws SchedulerException {
        Trigger trigger;
        if (this.scheduler != null && (trigger = this.scheduler.getTrigger(TriggerKey.triggerKey((String)name, (String)group))) != null) {
            this.scheduler.unscheduleJob(TriggerKey.triggerKey((String)name, (String)group));
        }
    }

    public List<Trigger> getTriggers(String group, Long tenantId) throws SchedulerException {
        Set triggerKeys = this.scheduler.getTriggerKeys(StringUtils.isNotEmpty((CharSequence)group) ? GroupMatcher.triggerGroupEquals((String)group) : GroupMatcher.anyTriggerGroup());
        ArrayList<Trigger> triggers = new ArrayList<Trigger>();
        for (TriggerKey key : triggerKeys) {
            Trigger trigger = this.getTrigger(key.getName(), key.getGroup());
            if (tenantId != null && !tenantId.equals(trigger.getJobDataMap().get((Object)TENANT_ID))) continue;
            triggers.add(trigger);
        }
        triggers.sort((o1, o2) -> {
            int cmp = o1.getKey().getGroup().compareTo(o2.getKey().getGroup());
            if (cmp == 0) {
                cmp = o1.getKey().getName().compareTo(o2.getKey().getName());
            }
            return cmp;
        });
        return triggers;
    }

    public Trigger getTrigger(String name, String group) throws SchedulerException {
        return this.scheduler.getTrigger(TriggerKey.triggerKey((String)name, (String)group));
    }
}

