/*
 * Decompiled with CFR 0.152.
 */
package com.logicaldoc.core.imaging;

import com.logicaldoc.core.conversion.FormatConverterManager;
import com.logicaldoc.core.imaging.ImageZone;
import com.logicaldoc.core.util.GhostUtil;
import com.logicaldoc.util.io.FileUtil;
import com.logicaldoc.util.spring.Context;
import java.awt.AlphaComposite;
import java.awt.Color;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.RenderingHints;
import java.awt.geom.AffineTransform;
import java.awt.image.BufferedImage;
import java.awt.image.ColorModel;
import java.awt.image.LookupOp;
import java.awt.image.RenderedImage;
import java.awt.image.ShortLookupTable;
import java.awt.image.WritableRaster;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import javax.imageio.ImageIO;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.io.IOUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ImageUtil {
    private static final Logger log = LoggerFactory.getLogger(ImageUtil.class);
    private static final short[] invertTable = new short[256];

    static {
        int i = 0;
        while (i < 256) {
            ImageUtil.invertTable[i] = (short)(255 - i);
            ++i;
        }
    }

    private ImageUtil() {
    }

    public static void save(String content, File file) throws IOException {
        BufferedImage image = null;
        byte[] imageByte = Base64.decodeBase64((String)content);
        ByteArrayInputStream bis = new ByteArrayInputStream(imageByte);
        image = ImageIO.read(bis);
        bis.close();
        ImageIO.write((RenderedImage)image, file.getName().contains(".") ? FileUtil.getExtension(file.getName()).toLowerCase() : "jpg", file);
    }

    public static void cropToFile(String content, ImageZone zone, File file) throws IOException {
        File tmpFile = null;
        try {
            tmpFile = FileUtil.createTempFile("zonalocr", "." + FileUtil.getExtension(file.getName()));
            ImageUtil.save(content, tmpFile);
            ImageUtil.cropToFile(tmpFile, zone, file);
        }
        catch (Throwable throwable) {
            FileUtil.delete(tmpFile);
            throw throwable;
        }
        FileUtil.delete(tmpFile);
    }

    private static void cropToFile(File originalFile, ImageZone zone, File file) throws IOException {
        BufferedImage scanImage = ImageIO.read(originalFile);
        BufferedImage zoneImage = ImageUtil.crop(scanImage, zone);
        ImageIO.write((RenderedImage)zoneImage, FileUtil.getExtension(file.getName()), file);
    }

    public static BufferedImage crop(BufferedImage originalImage, ImageZone zone) {
        int width = originalImage.getWidth();
        int height = originalImage.getHeight();
        int x = (int)(zone.getLeft() * (double)width);
        int y = (int)(zone.getTop() * (double)height);
        int w = (int)(zone.getWidth() * (double)width);
        int h = (int)(zone.getHeight() * (double)height);
        return originalImage.getSubimage(x, y, w, h);
    }

    public static BufferedImage cropCenterSquare(BufferedImage originalImage, int squareSize) {
        int width = originalImage.getWidth();
        int height = originalImage.getHeight();
        int x = width < squareSize ? 0 : (int)((double)width / 2.0) - (int)((double)squareSize / 2.0);
        int y = height < squareSize ? 0 : (int)((double)height / 2.0) - (int)((double)squareSize / 2.0);
        int w = width < squareSize ? width : squareSize;
        int h = height < squareSize ? height : squareSize;
        return originalImage.getSubimage(x, y, w, h);
    }

    public static int[] cropVisibleContent(File src, File dst) throws IOException {
        BufferedImage srcImage = ImageIO.read(src);
        int top = ImageUtil.getVisibleTop(srcImage);
        int bottom = ImageUtil.getVisibleBottom(srcImage);
        int left = ImageUtil.getVisibleLeft(srcImage);
        int right = ImageUtil.getVisibleRight(srcImage);
        BufferedImage croppedImage = srcImage.getSubimage(left - 1, top - 1, right - left + 2, bottom - top + 2);
        ImageIO.write((RenderedImage)croppedImage, "png", dst);
        return new int[]{croppedImage.getWidth(), croppedImage.getHeight()};
    }

    private static int getVisibleRight(BufferedImage srcImage) {
        int right = 1;
        int x = 0;
        while (x < srcImage.getWidth()) {
            int y = 1;
            while (y < srcImage.getHeight()) {
                Color pixelColor = new Color(srcImage.getRGB(x, y));
                if (!pixelColor.equals(Color.WHITE) && x > right) {
                    right = x;
                    break;
                }
                ++y;
            }
            ++x;
        }
        return right;
    }

    private static int getVisibleLeft(BufferedImage srcImage) {
        int left = srcImage.getWidth() - 1;
        int x = srcImage.getWidth() - 1;
        while (x > 0) {
            int y = 1;
            while (y < srcImage.getHeight()) {
                Color pixelColor = new Color(srcImage.getRGB(x, y));
                if (!pixelColor.equals(Color.WHITE) && x < left) {
                    left = x;
                    break;
                }
                ++y;
            }
            --x;
        }
        return left;
    }

    private static int getVisibleBottom(BufferedImage srcImage) {
        int bottom = 0;
        int x = 0;
        while (x < srcImage.getWidth()) {
            int y = 0;
            while (y < srcImage.getHeight()) {
                Color pixelColor = new Color(srcImage.getRGB(x, y));
                if (!pixelColor.equals(Color.WHITE) && y > bottom) {
                    bottom = y;
                    break;
                }
                ++y;
            }
            ++x;
        }
        return bottom;
    }

    private static int getVisibleTop(BufferedImage srcImage) {
        int top = srcImage.getHeight() - 1;
        int x = 1;
        while (x < srcImage.getWidth()) {
            int y = srcImage.getHeight() - 1;
            while (y > 0) {
                Color pixelColor = new Color(srcImage.getRGB(x, y));
                if (!pixelColor.equals(Color.WHITE) && y < top) {
                    top = y;
                    break;
                }
                --y;
            }
            ++x;
        }
        return top;
    }

    public static void paste(BufferedImage container, BufferedImage imageIn, float opaque, int x, int y) {
        Graphics2D g2d = container.createGraphics();
        g2d.setComposite(AlphaComposite.getInstance(3, opaque));
        g2d.drawImage((Image)imageIn, x, y, null);
        g2d.dispose();
    }

    public static String encode(File image) throws IOException {
        byte[] bytes = IOUtils.toByteArray(new FileInputStream(image));
        return Base64.encodeBase64String((byte[])bytes);
    }

    public static void printFirstPage(File originalFile, String originalFileName, File out) throws IOException {
        String outputExt;
        String inputExt = FileUtil.getExtension(originalFileName).toLowerCase();
        if (inputExt.equals(outputExt = FileUtil.getExtension(out.getName()).toLowerCase())) {
            FileUtil.copyFile(originalFile, out);
        } else {
            File pdfFile = FileUtil.createTempFile("firstpage", ".pdf");
            try {
                if (!"pdf".equals(inputExt)) {
                    FormatConverterManager manager = Context.get(FormatConverterManager.class);
                    manager.convertFile(originalFile, originalFileName, pdfFile, outputExt, null);
                } else {
                    pdfFile = originalFile;
                }
                GhostUtil.print(pdfFile, out, 1);
            }
            finally {
                FileUtil.delete(pdfFile);
            }
        }
    }

    public static boolean isBlack(BufferedImage image, int x, int y) {
        if (image.getType() == 12) {
            WritableRaster raster = image.getRaster();
            int pixelRGBValue = raster.getSample(x, y, 0);
            return pixelRGBValue == 0;
        }
        int luminanceValue = 140;
        return ImageUtil.isBlack(image, x, y, luminanceValue);
    }

    public static boolean isBlack(BufferedImage image, int x, int y, int luminanceCutOff) {
        double luminance = 0.0;
        if (x < 0 || y < 0 || x > image.getWidth() || y > image.getHeight()) {
            return false;
        }
        try {
            int pixelRGBValue = image.getRGB(x, y);
            int r = pixelRGBValue >> 16 & 0xFF;
            int g = pixelRGBValue >> 8 & 0xFF;
            int b = pixelRGBValue & 0xFF;
            luminance = (double)r * 0.299 + (double)g * 0.587 + (double)b * 0.114;
        }
        catch (Exception e) {
            log.warn(e.getMessage(), e);
        }
        return luminance < (double)luminanceCutOff;
    }

    public static BufferedImage rotate(BufferedImage image, double angle, int cx, int cy) {
        int width = image.getWidth(null);
        int height = image.getHeight(null);
        int minX = 0;
        int minY = 0;
        int maxX = 0;
        int maxY = 0;
        int[] nArray = new int[8];
        nArray[2] = width;
        nArray[4] = width;
        nArray[5] = height;
        nArray[7] = height;
        int[] corners = nArray;
        double theta = Math.toRadians(angle);
        int i = 0;
        while (i < corners.length) {
            int x = (int)(Math.cos(theta) * (double)(corners[i] - cx) - Math.sin(theta) * (double)(corners[i + 1] - cy) + (double)cx);
            int y = (int)(Math.sin(theta) * (double)(corners[i] - cx) + Math.cos(theta) * (double)(corners[i + 1] - cy) + (double)cy);
            if (x > maxX) {
                maxX = x;
            }
            if (x < minX) {
                minX = x;
            }
            if (y > maxY) {
                maxY = y;
            }
            if (y < minY) {
                minY = y;
            }
            i += 2;
        }
        cx -= minX;
        cy -= minY;
        BufferedImage bi = new BufferedImage(maxX - minX, maxY - minY, image.getType());
        Graphics2D g2 = bi.createGraphics();
        g2.setRenderingHint(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_BICUBIC);
        g2.setBackground(Color.white);
        g2.fillRect(0, 0, bi.getWidth(), bi.getHeight());
        AffineTransform at = new AffineTransform();
        at.rotate(theta, cx, cy);
        g2.setTransform(at);
        g2.drawImage((Image)image, -minX, -minY, null);
        g2.dispose();
        return bi;
    }

    public static BufferedImage scale(BufferedImage image, int targetWidth, int targetHeight) {
        int type = image.getTransparency() == 1 ? 1 : 2;
        BufferedImage tmp = new BufferedImage(targetWidth, targetHeight, type);
        Graphics2D g2 = tmp.createGraphics();
        g2.setRenderingHint(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_BICUBIC);
        g2.drawImage(image, 0, 0, targetWidth, targetHeight, null);
        g2.dispose();
        return tmp;
    }

    public static BufferedImage getSubImage(BufferedImage image, int x, int y, int width, int height) {
        int type = image.getTransparency() == 1 ? 1 : 2;
        BufferedImage tmp = new BufferedImage(width, height, type);
        Graphics2D g2 = tmp.createGraphics();
        g2.drawImage((Image)image.getSubimage(x, y, width, height), 0, 0, null);
        g2.dispose();
        return tmp;
    }

    public static BufferedImage convertToBinary(BufferedImage image) {
        BufferedImage tmp = new BufferedImage(image.getWidth(), image.getHeight(), 12);
        Graphics2D g2 = tmp.createGraphics();
        g2.drawImage((Image)image, 0, 0, null);
        g2.dispose();
        return tmp;
    }

    public static BufferedImage convertToGrayscale(BufferedImage image) {
        BufferedImage tmp = new BufferedImage(image.getWidth(), image.getHeight(), 10);
        Graphics2D g2 = tmp.createGraphics();
        g2.drawImage((Image)image, 0, 0, null);
        g2.dispose();
        return tmp;
    }

    public static BufferedImage invertColors(BufferedImage image) {
        BufferedImage tmp = new BufferedImage(image.getWidth(), image.getHeight(), image.getType());
        LookupOp invertOp = new LookupOp(new ShortLookupTable(0, invertTable), null);
        return invertOp.filter(image, tmp);
    }

    public static BufferedImage rotate(BufferedImage image, double angle) {
        double theta = Math.toRadians(angle);
        double sin = Math.abs(Math.sin(theta));
        double cos = Math.abs(Math.cos(theta));
        int w = image.getWidth();
        int h = image.getHeight();
        int newW = (int)Math.floor((double)w * cos + (double)h * sin);
        int newH = (int)Math.floor((double)h * cos + (double)w * sin);
        BufferedImage tmp = new BufferedImage(newW, newH, image.getType());
        Graphics2D g2d = tmp.createGraphics();
        g2d.setRenderingHint(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_BICUBIC);
        g2d.translate((double)(newW - w) / 2.0, (double)(newH - h) / 2.0);
        g2d.rotate(theta, (double)w / 2.0, (double)h / 2.0);
        g2d.drawImage((Image)image, 0, 0, null);
        g2d.dispose();
        return tmp;
    }

    public static BufferedImage clone(BufferedImage bi) {
        ColorModel cm = bi.getColorModel();
        boolean isAlphaPremultiplied = cm.isAlphaPremultiplied();
        WritableRaster raster = bi.copyData(null);
        return new BufferedImage(cm, raster, isAlphaPremultiplied, null);
    }

    public static BufferedImage decode(String text) {
        BufferedImage image = new BufferedImage(1, 1, 2);
        Graphics2D graphics2d = image.createGraphics();
        Font font = new Font("TimesNewRoman", 1, 32);
        graphics2d.setFont(font);
        FontMetrics fontmetrics = graphics2d.getFontMetrics();
        int width = fontmetrics.stringWidth(text);
        int height = fontmetrics.getHeight();
        graphics2d.dispose();
        image = new BufferedImage(width, height, 2);
        graphics2d = image.createGraphics();
        graphics2d.setRenderingHint(RenderingHints.KEY_ALPHA_INTERPOLATION, RenderingHints.VALUE_ALPHA_INTERPOLATION_QUALITY);
        graphics2d.setRenderingHint(RenderingHints.KEY_COLOR_RENDERING, RenderingHints.VALUE_COLOR_RENDER_QUALITY);
        graphics2d.setFont(font);
        fontmetrics = graphics2d.getFontMetrics();
        graphics2d.setColor(Color.DARK_GRAY);
        graphics2d.drawString(text, 0, fontmetrics.getAscent());
        graphics2d.dispose();
        return image;
    }

    public static BufferedImage generateTransparentSinglePixelPng() {
        BufferedImage transparentPng = new BufferedImage(1, 1, 2);
        transparentPng.setRGB(0, 0, 1, 1, new int[1], 0, 1);
        return transparentPng;
    }

    public static byte[] getBytes(BufferedImage image) throws IOException {
        Throwable throwable = null;
        Object var2_3 = null;
        try (ByteArrayOutputStream out = new ByteArrayOutputStream();){
            ImageIO.write((RenderedImage)image, "png", out);
            out.flush();
            return out.toByteArray();
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }
}

