/*
 * Decompiled with CFR 0.152.
 */
package com.logicaldoc.core.i18n;

import com.logicaldoc.util.LocaleUtil;
import com.logicaldoc.util.io.ResourceUtil;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.StringReader;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class StopWords {
    private static final Logger log = LoggerFactory.getLogger(StopWords.class);
    private static final Map<Locale, Set<String>> cacheMap = new HashMap<Locale, Set<String>>();

    private StopWords() {
    }

    public static Set<String> getStopWords(String locale) {
        return cacheMap.computeIfAbsent(LocaleUtil.toLocale(locale), StopWords::loadStopWords);
    }

    public static Set<String> getStopWords(Locale locale) {
        return cacheMap.computeIfAbsent(locale, StopWords::loadStopWords);
    }

    private static Set<String> loadStopWords(Locale locale) {
        Object resource = "/stopwords/stopwords_" + String.valueOf(locale) + ".txt";
        if (!ResourceUtil.existsResource((String)resource)) {
            resource = "/stopwords/stopwords_" + locale.getLanguage() + ".txt";
        }
        if (!ResourceUtil.existsResource((String)resource)) {
            resource = "/stopwords/stopwords_en.txt";
        }
        log.debug("Loading stopwords from: {}", resource);
        try {
            Throwable throwable = null;
            Object var3_5 = null;
            try (BufferedReader reader = new BufferedReader(new StringReader(ResourceUtil.readAsString((String)resource)));){
                String line = "";
                HashSet<String> words = new HashSet<String>();
                while ((line = reader.readLine()) != null) {
                    words.add(line.trim());
                }
                return words;
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (IOException e) {
            log.warn(e.getMessage(), e);
            return Collections.emptySet();
        }
    }
}

