/*
 * Decompiled with CFR 0.152.
 */
package com.logicaldoc.core.i18n;

import com.logicaldoc.core.i18n.Language;
import com.logicaldoc.util.LocaleUtil;
import com.logicaldoc.util.config.ContextProperties;
import com.logicaldoc.util.plugin.PluginRegistry;
import com.logicaldoc.util.spring.Context;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.java.plugin.registry.Extension;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LanguageManager {
    private static final Logger log = LoggerFactory.getLogger(LanguageManager.class);
    private static LanguageManager languageManager;
    private Map<Locale, Language> languages = new HashMap<Locale, Language>();

    private LanguageManager() {
        this.init();
    }

    public void init() {
        this.languages.clear();
        PluginRegistry registry = PluginRegistry.getInstance();
        if (registry == null) {
            return;
        }
        Collection<Object> extensions = new ArrayList();
        try {
            extensions = registry.getExtensions("logicaldoc-core", "Language");
        }
        catch (Exception exception) {
            log.error(exception.getMessage());
        }
        for (Extension extension : extensions) {
            String language = extension.getParameter("locale").valueAsString();
            String analyzer = extension.getParameter("analyzer").valueAsString();
            log.debug("analyzer = {}", (Object)analyzer);
            try {
                Locale locale = LocaleUtil.toLocale(language);
                Language lang = new Language(locale);
                if (StringUtils.isNotEmpty(analyzer) && !"-".equals(analyzer)) {
                    lang.setAnalyzerClass(analyzer);
                } else {
                    lang.setAnalyzerClass("org.apache.lucene.analysis." + lang.getLanguage() + "." + lang.getLocale().getDisplayName(Locale.ENGLISH) + "Analyzer");
                }
                this.languages.put(locale, lang);
                log.info("Added new Language: {}", (Object)language);
            }
            catch (Exception e) {
                log.error(e.getMessage());
            }
        }
    }

    public static LanguageManager getInstance() {
        if (languageManager == null) {
            languageManager = new LanguageManager();
        }
        return languageManager;
    }

    public List<Language> getLanguages() {
        ArrayList<Language> langs = new ArrayList<Language>();
        langs.addAll(this.languages.values());
        Collections.sort(langs);
        return langs;
    }

    public List<Language> getActiveLanguages(String tenantName) {
        ContextProperties config = Context.get().getProperties();
        if (config == null) {
            return this.getLanguages();
        }
        ArrayList<Language> actives = new ArrayList<Language>();
        for (Language l : this.getLanguages()) {
            if (!"enabled".equals(config.getProperty(tenantName + ".lang." + String.valueOf(l)))) continue;
            actives.add(l);
        }
        return actives;
    }

    public Language getLanguage(Locale locale) {
        return this.languages.get(locale);
    }

    public void addLanguage(Locale locale, Language lang) {
        this.languages.put(locale, lang);
    }

    public List<String> getLanguagesAsString(String tenantName) {
        ArrayList<String> languages2 = new ArrayList<String>();
        for (Language lang : this.getActiveLanguages(tenantName)) {
            languages2.add(lang.getLocale().toString());
        }
        return languages2;
    }
}

