/*
 * Decompiled with CFR 0.152.
 */
package com.logicaldoc.core.i18n;

import com.logicaldoc.core.i18n.StopWords;
import com.logicaldoc.core.searchengine.StandardSearchEngine;
import java.lang.reflect.Constructor;
import java.util.HashSet;
import java.util.Locale;
import java.util.Set;
import org.apache.commons.lang.StringUtils;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.analysis.CharArraySet;
import org.apache.lucene.analysis.core.SimpleAnalyzer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tartarus.snowball.SnowballProgram;

public class Language
implements Comparable<Language> {
    private static final Logger log = LoggerFactory.getLogger(Language.class);
    private Locale locale;
    private Set<String> stopWords = new HashSet<String>();
    private Analyzer analyzer;
    private String analyzerClass;
    private SnowballProgram stemmer;

    public Language(Locale locale) {
        this.locale = locale;
    }

    public Locale getLocale() {
        return this.locale;
    }

    public String getLanguage() {
        return this.locale.getLanguage();
    }

    public String getDisplayLanguage() {
        return this.locale.getDisplayLanguage();
    }

    public String getDefaultDisplayLanguage() {
        return this.locale.getDisplayLanguage(Locale.ENGLISH);
    }

    public Set<String> getStopWords() {
        return StopWords.getStopWords(this.locale);
    }

    public void setStopWords(Set<String> stopWords) {
        this.stopWords = stopWords;
    }

    public String getAnalyzerClass() {
        return this.analyzerClass;
    }

    public void setAnalyzerClass(String analyzerClass) {
        this.analyzerClass = analyzerClass;
    }

    public Analyzer getAnalyzer() {
        if (this.analyzer == null && !StringUtils.isEmpty(this.analyzerClass)) {
            this.initAnalyzer();
        }
        if (this.analyzer == null) {
            this.analyzer = new SimpleAnalyzer();
            log.debug("Using default simple analyzer");
        }
        this.analyzer.setVersion(StandardSearchEngine.VERSION);
        return this.analyzer;
    }

    private void initAnalyzer() {
        Class<?> aClass = null;
        try {
            aClass = Class.forName(this.analyzerClass);
        }
        catch (Exception t) {
            log.error("{} not found", (Object)this.analyzerClass);
        }
        if (aClass != null && this.stopWords != null && !this.stopWords.isEmpty()) {
            try {
                Constructor<?> constructor = aClass.getConstructor(CharArraySet.class);
                if (constructor != null) {
                    this.analyzer = (Analyzer)constructor.newInstance(new CharArraySet(this.stopWords, false));
                }
            }
            catch (Exception e) {
                log.debug("constructor (Version matchVersion, Set<?> stopwords)  not found");
            }
        }
        if (aClass != null && this.analyzer == null) {
            try {
                this.analyzer = (Analyzer)aClass.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
            }
            catch (Exception e) {
                log.debug("constructor without arguments not found");
            }
        }
    }

    public void setAnalyzer(Analyzer analyzer) {
        this.analyzer = analyzer;
    }

    public String toString() {
        return this.locale.toString();
    }

    public int hashCode() {
        return this.toString().hashCode();
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        return this.toString().equals(obj.toString());
    }

    @Override
    public int compareTo(Language o) {
        if ("standard".equals(this.toString())) {
            return -1;
        }
        if ("standard".equals(o.toString())) {
            return 1;
        }
        return this.toString().compareToIgnoreCase(o.toString());
    }

    public SnowballProgram getStemmer() {
        if (this.stemmer == null) {
            String stemmerClass = "org.tartarus.snowball.ext." + this.getLocale().getDisplayName(Locale.ENGLISH) + "Stemmer";
            try {
                Constructor<?> constructor;
                Class<?> clazz = Class.forName(stemmerClass);
                if (clazz != null && (constructor = clazz.getConstructor(new Class[0])) != null) {
                    this.stemmer = (SnowballProgram)constructor.newInstance(new Object[0]);
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return this.stemmer;
    }
}

