/*
 * Decompiled with CFR 0.152.
 */
package com.logicaldoc.core.i18n;

import java.text.ParseException;
import java.text.ParsePosition;
import java.text.SimpleDateFormat;
import java.util.Date;

public class DateBean
extends Date {
    private static final String YYYY_MM_DD = "yyyyMMdd";
    private static final String YYYY_MMDD_HMMSS = "yyyyMMdd HHmmss";
    private static final long serialVersionUID = 1L;

    public static String toCompactString() {
        SimpleDateFormat targetFormat = new SimpleDateFormat();
        targetFormat.applyPattern(YYYY_MMDD_HMMSS);
        return targetFormat.format(new DateBean());
    }

    public static Date dateFromCompactString(String compactString) {
        SimpleDateFormat targetFormat = new SimpleDateFormat(YYYY_MMDD_HMMSS);
        if (compactString.length() < 9) {
            targetFormat = new SimpleDateFormat(YYYY_MM_DD);
        }
        try {
            return targetFormat.parse(compactString);
        }
        catch (ParseException e) {
            return null;
        }
    }

    public static String toCompactString(Date date) {
        SimpleDateFormat df = new SimpleDateFormat(YYYY_MM_DD);
        return df.format(date);
    }

    public static String toCompactString(String date, String dateFormat) {
        if (date != null && !date.equals("")) {
            return DateBean.convertDate(dateFormat, YYYY_MMDD_HMMSS, date);
        }
        return "";
    }

    public static String convertDate(String formatIn, String formatOut, String dateIn) {
        try {
            if (dateIn.length() > 8) {
                return new SimpleDateFormat(formatOut).format(new SimpleDateFormat(formatIn).parse(dateIn, new ParsePosition(0)));
            }
            return new SimpleDateFormat(formatOut).format(new SimpleDateFormat(YYYY_MM_DD).parse(dateIn, new ParsePosition(0)));
        }
        catch (Exception ex) {
            return null;
        }
    }
}

