/*
 * Decompiled with CFR 0.152.
 */
package com.logicaldoc.core.history;

import com.logicaldoc.core.PersistenceException;
import com.logicaldoc.core.PersistentObject;
import com.logicaldoc.core.security.Client;
import com.logicaldoc.core.security.Session;
import com.logicaldoc.core.security.user.User;
import com.logicaldoc.core.security.user.UserDAO;
import com.logicaldoc.util.spring.Context;
import jakarta.persistence.Column;
import jakarta.persistence.MappedSuperclass;
import jakarta.persistence.Table;
import jakarta.persistence.Transient;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.context.annotation.ClassPathScanningCandidateComponentProvider;
import org.springframework.core.type.filter.AnnotationTypeFilter;
import org.springframework.core.type.filter.TypeFilter;

@MappedSuperclass
public abstract class History
extends PersistentObject
implements Comparable<History> {
    public static final String ASPECT = "saveHistory";
    private static final long serialVersionUID = 1L;
    private static final Logger log = LoggerFactory.getLogger(History.class);
    @Column(name="ld_date", columnDefinition="DATETIME(3)")
    private Date date = new Date();
    @Column(name="ld_userid")
    private Long userId;
    @Column(name="ld_username", length=255)
    private String username = "";
    @Column(name="ld_userlogin", length=255)
    private String userLogin = "";
    @Column(name="ld_event", length=255)
    protected String event = "";
    @Column(name="ld_comment")
    private String comment = "";
    @Column(name="ld_path")
    private String path = null;
    @Column(name="ld_notified", nullable=false)
    private int notified = 0;
    @Column(name="ld_sessionid", length=255)
    private String sessionId = "";
    @Column(name="ld_keylabel", length=255)
    private String keyLabel = "";
    @Column(name="ld_ip", length=255)
    private String ip;
    @Column(name="ld_geolocation", length=255)
    private String geolocation;
    @Column(name="ld_device", length=255)
    private String device;
    @Transient
    private String tenant = null;
    @Transient
    private User user;
    @Transient
    private boolean notifyEvent = true;

    public String getPath() {
        return this.path;
    }

    public void setPath(String path) {
        this.path = path;
    }

    public Date getDate() {
        return this.date;
    }

    public void setDate(Date date) {
        this.date = date;
    }

    public void setEvent(String event) {
        this.event = event;
    }

    public String getEvent() {
        return this.event;
    }

    public String getUsername() {
        return this.username;
    }

    public void setUsername(String username) {
        this.username = username;
    }

    public String getComment() {
        return this.comment;
    }

    public void setComment(String comment) {
        this.comment = comment;
    }

    public int getNotified() {
        return this.notified;
    }

    public void setNotified(int notified) {
        this.notified = notified;
    }

    public String getSessionId() {
        return this.sessionId;
    }

    public void setSessionId(String sessionId) {
        this.sessionId = sessionId;
    }

    public User getUser() {
        if (this.user == null && this.userId != null && this.userId != 0L) {
            UserDAO uDao = Context.get(UserDAO.class);
            try {
                this.user = (User)uDao.findById(this.userId);
                uDao.initialize(this.user);
            }
            catch (PersistenceException e) {
                log.error(e.getMessage(), e);
            }
        }
        return this.user;
    }

    public void setSession(Session session) {
        if (session != null) {
            this.setUser(session.getUser());
            this.setSessionId(session.getSid());
            this.setKeyLabel(session.getKeyLabel());
            this.setTenantId(session.getTenantId());
            this.setTenant(session.getTenantName());
            if (session.getClient() != null) {
                this.setClient(session.getClient());
            }
        }
    }

    public void setUser(User user) {
        this.user = user;
        if (user != null) {
            this.setUserId(user.getId());
            this.setUserLogin(user.getUsername());
            this.setUsername(user.getFullName());
            this.setTenantId(user.getTenantId());
        }
    }

    public void setClient(Client client) {
        if (client == null) {
            this.ip = null;
            this.geolocation = null;
            this.device = null;
        } else {
            this.ip = client.getAddress();
            this.device = client.getDevice() != null ? client.getDevice().toString() : null;
            this.geolocation = client.getGeolocation() != null ? client.getGeolocation().toString() : null;
        }
    }

    public String getTenant() {
        return this.tenant;
    }

    public void setTenant(String tenant) {
        this.tenant = tenant;
    }

    public String getUserLogin() {
        return this.userLogin;
    }

    public void setUserLogin(String login) {
        this.userLogin = login;
    }

    public boolean isNotifyEvent() {
        return this.notifyEvent;
    }

    public void setNotifyEvent(boolean notifyEvent) {
        this.notifyEvent = notifyEvent;
    }

    public String getIp() {
        return this.ip;
    }

    public void setIp(String ip) {
        this.ip = ip;
    }

    public Long getUserId() {
        return this.userId;
    }

    public void setUserId(Long userId) {
        this.userId = userId;
    }

    public String getGeolocation() {
        return this.geolocation;
    }

    public void setGeolocation(String geolocation) {
        this.geolocation = geolocation;
    }

    public String getDevice() {
        return this.device;
    }

    public void setDevice(String device) {
        this.device = device;
    }

    public String getKeyLabel() {
        return this.keyLabel;
    }

    public void setKeyLabel(String keyLabel) {
        this.keyLabel = keyLabel;
    }

    protected void copyAttributesFrom(History source) {
        this.setTenantId(source.getTenantId());
        this.setDate(source.getDate());
        this.setCreation(source.getCreation());
        this.setUser(source.getUser());
        this.event = source.event;
        this.setComment(source.getComment());
        this.setPath(source.getPath());
        this.setNotified(source.getNotified());
        this.setSessionId(source.getSessionId());
        this.setUserId(source.getUserId());
        this.setUsername(source.getUsername());
        this.setUserLogin(source.getUserLogin());
        this.setTenant(source.getTenant());
        this.setNotifyEvent(this.isNotifyEvent());
        this.setIp(source.getIp());
        this.setDevice(source.getDevice());
        this.setGeolocation(source.getGeolocation());
        this.setKeyLabel(source.getKeyLabel());
    }

    @Override
    public String toString() {
        return this.getId() + " - " + this.event;
    }

    @Override
    public int compareTo(History other) {
        return this.getDate().compareTo(other.getDate());
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = super.hashCode();
        result = 31 * result + (this.date == null ? 0 : this.date.hashCode());
        result = 31 * result + (this.event == null ? 0 : this.event.hashCode());
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        History other = (History)obj;
        if (this.date == null ? other.date != null : this.date.getTime() != other.date.getTime()) {
            return false;
        }
        return !(this.event == null ? other.event != null : !this.event.equals(other.event));
    }

    public static Collection<String> eventTables() {
        ArrayList<String> tables = new ArrayList<String>();
        ClassPathScanningCandidateComponentProvider scanner = new ClassPathScanningCandidateComponentProvider(false);
        scanner.addIncludeFilter((TypeFilter)new AnnotationTypeFilter(Table.class));
        for (BeanDefinition bd : scanner.findCandidateComponents("com.logicaldoc")) {
            String beanClassName = bd.getBeanClassName();
            try {
                Class<?> beanClass = Class.forName(beanClassName);
                Table annotation = beanClass.getAnnotation(Table.class);
                if (annotation == null || !StringUtils.isNotEmpty(annotation.name()) || !History.class.isAssignableFrom(beanClass)) continue;
                tables.add(annotation.name());
            }
            catch (Exception e) {
                log.error(e.getMessage(), e);
            }
        }
        return tables;
    }
}

