/*
 * Decompiled with CFR 0.152.
 */
package com.logicaldoc.core.history;

import com.logicaldoc.core.HibernatePersistentObjectDAO;
import com.logicaldoc.core.PersistenceException;
import com.logicaldoc.core.PersistentObjectDAO;
import com.logicaldoc.core.RunLevel;
import com.logicaldoc.core.communication.EventCollector;
import com.logicaldoc.core.history.History;
import com.logicaldoc.core.security.TenantDAO;
import com.logicaldoc.util.config.ContextProperties;
import com.logicaldoc.util.spring.Context;
import jakarta.annotation.Resource;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.slf4j.LoggerFactory;

public abstract class HibernateHistoryDAO<T extends History>
extends HibernatePersistentObjectDAO<T>
implements PersistentObjectDAO<T> {
    @Resource(name="ContextProperties")
    protected ContextProperties config;
    private static final Map<Long, String> tenantNames = new HashMap<Long, String>();

    protected HibernateHistoryDAO(Class<T> historyClass) {
        super(historyClass);
        this.log = LoggerFactory.getLogger(HibernateHistoryDAO.class);
    }

    @Override
    public void store(T history) throws PersistenceException {
        String allowedEvents;
        if (!RunLevel.current().aspectEnabled("saveHistory")) {
            return;
        }
        if (((History)history).getDate() == null) {
            ((History)history).setDate(new Date());
        }
        if (((History)history).getComment() != null) {
            ((History)history).setComment(StringUtils.abbreviate(((History)history).getComment(), 4000));
            ((History)history).setComment(((History)history).getComment().trim().replaceAll("[\\p{Cntrl}&&[^\\n]&&[^\\t]&&[^\\r]]", ""));
        }
        if ("all".equals(allowedEvents = this.config.getString(this.getTenantName((History)history) + ".history.events", "all")) || allowedEvents.contains(((History)history).getEvent())) {
            super.store(history);
        }
        EventCollector.get().newEvent((History)history);
    }

    protected String getTenantName(History history) throws PersistenceException {
        if (tenantNames.containsKey(history.getTenantId())) {
            return tenantNames.get(history.getTenantId());
        }
        TenantDAO tenantDao = Context.get(TenantDAO.class);
        String name = tenantDao.getTenantName(history.getTenantId());
        tenantNames.put(history.getTenantId(), name);
        return name;
    }
}

