/*
 * Decompiled with CFR 0.152.
 */
package com.logicaldoc.core.generic;

import com.logicaldoc.core.HibernatePersistentObjectDAO;
import com.logicaldoc.core.PersistenceException;
import com.logicaldoc.core.generic.Generic;
import com.logicaldoc.core.generic.GenericDAO;
import com.logicaldoc.util.sql.SqlUtil;
import jakarta.transaction.Transactional;
import java.util.HashMap;
import java.util.List;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Repository;

@Repository(value="genericDAO")
@Transactional
public class HibernateGenericDAO
extends HibernatePersistentObjectDAO<Generic>
implements GenericDAO {
    private static final String AND = " and ";

    public HibernateGenericDAO() {
        super(Generic.class);
        this.log = LoggerFactory.getLogger(HibernateGenericDAO.class);
    }

    @Override
    public void delete(long genericId, int code) throws PersistenceException {
        if (code == 0) {
            throw new IllegalArgumentException("code cannot be 0");
        }
        if (!this.checkStoringAspect()) {
            return;
        }
        Generic generic = (Generic)this.findById(genericId);
        if (generic != null) {
            generic.setType(generic.getType() + "." + generic.getId());
            generic.setSubtype(generic.getSubtype() + "." + generic.getId());
            generic.setDeleted(code);
            this.saveOrUpdate(generic);
            this.flush();
        }
    }

    @Override
    public Generic findByAlternateKey(String type, String subtype, Long qualifier, long tenantId) throws PersistenceException {
        StringBuilder sb = new StringBuilder(" _entity.type = '" + SqlUtil.doubleQuotes(type) + "' and _entity.subtype='" + SqlUtil.doubleQuotes(subtype) + "' ");
        sb.append(" and _entity.tenantId=" + tenantId);
        if (qualifier != null) {
            sb.append(" and _entity.qualifier=" + String.valueOf(qualifier));
        } else {
            sb.append(" and _entity.qualifier is null");
        }
        List coll = this.findByWhere(sb.toString(), null, null);
        if (CollectionUtils.isNotEmpty(coll)) {
            return (Generic)coll.get(0);
        }
        return null;
    }

    @Override
    public List<Generic> findByTypeAndSubtype(String type, String subtype, Long qualifier, Long tenantId) throws PersistenceException {
        HashMap<String, Object> params = new HashMap<String, Object>();
        Object query = " 1=1 ";
        if (StringUtils.isNotEmpty(type)) {
            query = (String)query + " and _entity.type like :type ";
            params.put("type", type);
        }
        if (StringUtils.isNotEmpty(subtype)) {
            query = (String)query + " and _entity.subtype like :subtype ";
            params.put("subtype", subtype);
        }
        if (qualifier != null) {
            query = (String)query + " and _entity.qualifier = " + String.valueOf(qualifier);
        }
        if (tenantId != null) {
            query = (String)query + " and _entity.tenantId = " + String.valueOf(tenantId);
        }
        return this.findByWhere((String)query, params, null, null);
    }

    @Override
    public void initialize(Generic generic) {
        this.refresh(generic);
        for (String attribute : generic.getAttributes().keySet()) {
            if (generic.getValue(attribute) == null) continue;
            generic.getValue(attribute).toString();
        }
    }

    @Override
    public void store(Generic entity) throws PersistenceException {
        super.store(entity);
        this.flush();
    }
}

