/*
 * Decompiled with CFR 0.152.
 */
package com.logicaldoc.core.folder;

import com.logicaldoc.core.PersistenceException;
import com.logicaldoc.core.folder.FolderDAO;
import com.logicaldoc.core.task.Task;
import com.logicaldoc.core.task.TaskException;
import jakarta.annotation.Resource;
import java.util.List;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component(value="pathCalculator")
public class PathCalculator
extends Task {
    public static final String NAME = "PathCalculator";
    @Resource(name="folderDAO")
    protected FolderDAO folderDao;
    private long processed = 0L;
    private long errors = 0L;

    public PathCalculator() {
        super(NAME);
        this.log = LoggerFactory.getLogger(PathCalculator.class);
    }

    @Override
    public boolean isIndeterminate() {
        return false;
    }

    @Override
    public boolean isConcurrent() {
        return false;
    }

    @Override
    protected void runTask() throws TaskException {
        block6: {
            this.log.info("Start indexing of all documents");
            this.errors = 0L;
            this.processed = 0L;
            try {
                try {
                    List<Long> ids = this.folderDao.queryForList("select ld_id from ld_folder where ld_deleted=0 and ld_path is null", Long.class);
                    this.log.info("Found a total of {} folders to be processed", (Object)ids.size());
                    this.setSize(ids.size());
                    if (ids.isEmpty()) break block6;
                    for (Long id : ids) {
                        this.processFolder(id);
                        if (!this.interruptRequested) continue;
                        break;
                    }
                }
                catch (PersistenceException e) {
                    throw new TaskException(e.getMessage(), e);
                }
            }
            finally {
                this.log.info("Path calculation finished");
                this.log.info("Processed folders: {}", (Object)this.processed);
                this.log.info("Errors: {}", (Object)this.errors);
            }
        }
    }

    private void processFolder(Long id) {
        try {
            try {
                String path = this.folderDao.computePath(id);
                this.folderDao.jdbcUpdate("update ld_folder set ld_path='" + path + "' where ld_id=" + String.valueOf(id));
                ++this.processed;
            }
            catch (Exception e) {
                this.log.error("Error processing folder {}: {}", (Object)id, (Object)e.getMessage());
                this.log.error(e.getMessage(), e);
                ++this.errors;
                this.next();
            }
        }
        finally {
            this.next();
        }
    }

    public FolderDAO getFolderDao() {
        return this.folderDao;
    }
}

