/*
 * Decompiled with CFR 0.152.
 */
package com.logicaldoc.core.folder;

import com.logicaldoc.core.PersistenceException;
import com.logicaldoc.core.folder.FolderHistory;
import com.logicaldoc.core.folder.FolderHistoryDAO;
import com.logicaldoc.core.history.HibernateHistoryDAO;
import com.logicaldoc.util.sql.SqlUtil;
import jakarta.transaction.Transactional;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Repository;

@Repository(value="folderHistoryDAO")
@Transactional
public class HibernateFolderHistoryDAO
extends HibernateHistoryDAO<FolderHistory>
implements FolderHistoryDAO {
    private static final String AND = " and ";
    private static final String DATE_ASC = ".date asc";

    private HibernateFolderHistoryDAO() {
        super(FolderHistory.class);
        this.log = LoggerFactory.getLogger(HibernateFolderHistoryDAO.class);
    }

    @Override
    public List<FolderHistory> findByUserId(long userId) throws PersistenceException {
        return this.findByUserIdAndEvent(userId, null);
    }

    @Override
    public List<FolderHistory> findByFolderId(long folderId) throws PersistenceException {
        return this.findByWhere("_entity.folderId =" + folderId, "_entity.date asc", null);
    }

    @Override
    public List<FolderHistory> findNotNotified(Integer max) throws PersistenceException {
        return this.findByWhere("_entity.notified = 0", "_entity.date asc", max);
    }

    @Override
    public void cleanOldHistories(int ttl) throws PersistenceException {
        this.log.info("cleanOldHistories rows updated: {}", (Object)this.cleanOldRecords(ttl, "ld_folder_history"));
    }

    @Override
    public List<FolderHistory> findByUserIdAndEvent(long userId, String event) throws PersistenceException {
        String query = "_entity.userId =" + userId;
        if (event != null && StringUtils.isNotEmpty(event)) {
            query = query + " and lower(_entity.event) like '" + SqlUtil.doubleQuotes(event.toLowerCase()) + "'";
        }
        return this.findByWhere(query, " order by _entity.date asc", null);
    }

    @Override
    public List<FolderHistory> findByPath(String pathExpression, Date oldestDate, Collection<String> events, Integer max) throws PersistenceException {
        StringBuilder query = new StringBuilder("(_entity.path like :pathExpression or _entity.pathOld like :pathExpression) ");
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("pathExpression", pathExpression);
        if (oldestDate != null) {
            query.append(" and _entity.date >= :oldestDate ");
            params.put("oldestDate", oldestDate);
        }
        if (events != null && !events.isEmpty()) {
            StringBuilder eventsStr = new StringBuilder("(");
            for (String event : events) {
                if (eventsStr.length() > 1) {
                    eventsStr.append(",");
                }
                eventsStr.append("'" + event + "'");
            }
            eventsStr.append(")");
            query.append(" and _entity.event in " + String.valueOf(eventsStr));
        }
        return this.findByWhere(query.toString(), params, " order by _entity.date asc", max);
    }

    @Override
    public List<FolderHistory> findByFolderIdAndEvent(long folderId, String event, Date oldestDate) throws PersistenceException {
        Object query = "_entity.folderId = :folderId and _entity.event = :event ";
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("folderId", folderId);
        params.put("event", event);
        if (oldestDate != null) {
            query = (String)query + " and _entity.date >= :oldestDate ";
            params.put("oldestDate", oldestDate);
        }
        return this.findByWhere((String)query, params, " order by _entity.date asc", null);
    }
}

