/*
 * Decompiled with CFR 0.152.
 */
package com.logicaldoc.core.folder;

import com.logicaldoc.core.HibernatePersistentObjectDAO;
import com.logicaldoc.core.PersistenceException;
import com.logicaldoc.core.PersistentObject;
import com.logicaldoc.core.RunLevel;
import com.logicaldoc.core.document.Document;
import com.logicaldoc.core.document.DocumentDAO;
import com.logicaldoc.core.document.DocumentEvent;
import com.logicaldoc.core.document.DocumentHistory;
import com.logicaldoc.core.document.DocumentManager;
import com.logicaldoc.core.document.DocumentStatus;
import com.logicaldoc.core.document.FolderAccessControlEntry;
import com.logicaldoc.core.document.IndexingStatus;
import com.logicaldoc.core.document.Tag;
import com.logicaldoc.core.folder.Folder;
import com.logicaldoc.core.folder.FolderDAO;
import com.logicaldoc.core.folder.FolderEvent;
import com.logicaldoc.core.folder.FolderHistory;
import com.logicaldoc.core.folder.FolderHistoryDAO;
import com.logicaldoc.core.folder.FolderListener;
import com.logicaldoc.core.folder.FolderListenerManager;
import com.logicaldoc.core.metadata.Attribute;
import com.logicaldoc.core.metadata.Template;
import com.logicaldoc.core.metadata.TemplateDAO;
import com.logicaldoc.core.security.Permission;
import com.logicaldoc.core.security.Session;
import com.logicaldoc.core.security.SessionManager;
import com.logicaldoc.core.security.Tenant;
import com.logicaldoc.core.security.TenantDAO;
import com.logicaldoc.core.security.user.Group;
import com.logicaldoc.core.security.user.GroupDAO;
import com.logicaldoc.core.security.user.User;
import com.logicaldoc.core.security.user.UserDAO;
import com.logicaldoc.core.security.user.UserGroup;
import com.logicaldoc.core.store.Store;
import com.logicaldoc.util.StringUtil;
import com.logicaldoc.util.html.HTMLSanitizer;
import com.logicaldoc.util.spring.Context;
import com.logicaldoc.util.sql.SqlUtil;
import jakarta.annotation.Resource;
import jakarta.transaction.Transactional;
import java.io.IOException;
import java.io.InputStream;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.stream.Collectors;
import org.apache.commons.lang.StringUtils;
import org.hibernate.Hibernate;
import org.slf4j.LoggerFactory;
import org.springframework.jdbc.core.BeanPropertyRowMapper;
import org.springframework.stereotype.Repository;

@Repository(value="folderDAO")
@Transactional
public class HibernateFolderDAO
extends HibernatePersistentObjectDAO<Folder>
implements FolderDAO {
    private static final String ROOT_ID = "rootId";
    private static final String TENANT_ID_EQUAL = ".tenantId=";
    private static final String PARENTID_EQUAL = ".parentId=";
    private static final String FOLDER_ACL_AS_ACL = ".accessControlList as _acl ";
    private static final String SECURITY_REF_IN = ".securityRef in (";
    private static final String SLASH = "/";
    private static final String FROM_FOLDER = " from Folder ";
    private static final String WHERE = " where ";
    private static final String PARENT_ID = "parentId";
    private static final String REPLICATE = "replicate";
    private static final String AND_LDGROUPID_IN = " and A.ld_groupid in (";
    private static final String AND = " and ";
    private static final String SELECT = "select ";
    private static final String LEFT_JOIN = " left join ";
    private static final String SELECT_DISTINCT = "select distinct(";
    private static final String WHERE_GROUP_GROUPID_IN = " where _acl.ace.ace.groupId in (";
    @Resource(name="userDAO")
    protected UserDAO userDAO;
    @Resource(name="folderHistoryDAO")
    protected FolderHistoryDAO historyDAO;
    @Resource(name="Store")
    protected Store store;
    @Resource(name="folderListenerManager")
    protected FolderListenerManager listenerManager;

    public HibernateFolderDAO() {
        super(Folder.class);
        this.log = LoggerFactory.getLogger(HibernateFolderDAO.class);
    }

    @Override
    public void store(Folder folder) throws PersistenceException {
        this.store(folder, null);
    }

    @Override
    public void store(Folder folder, FolderHistory transaction) throws PersistenceException {
        if (!this.checkStoringAspect()) {
            return;
        }
        this.workspaceChecks(folder);
        if (!folder.getName().equals(SLASH)) {
            folder.setName(HTMLSanitizer.sanitizeSimpleText(folder.getName()));
            folder.setName(folder.getName().replace(SLASH, ""));
            folder.setName(folder.getName().replace("\\", ""));
        }
        try {
            Folder parent = this.findFolder(folder.getParentId());
            if (parent == null) {
                throw new PersistenceException("Unexisting parent folder " + folder.getParentId());
            }
            folder.setParentId(parent.getId());
            if (folder.getFoldRef() == null) {
                if (folder.getSecurityRef() != null) {
                    folder.getAccessControlList().clear();
                }
                this.setCreator(folder, transaction);
                this.updateAliases(folder);
            }
            this.setTags(folder);
            if (folder.getTemplate() == null) {
                folder.setOcrTemplateId(null);
                folder.setBarcodeTemplateId(null);
            }
            folder.getAttributes().values().removeIf(Attribute::isSection);
            this.removeForbiddenPermissionsForGuests(folder);
            this.log.debug("Invoke listeners before store");
            HashMap<String, Object> dictionary = new HashMap<String, Object>();
            for (FolderListener listener : this.listenerManager.getListeners()) {
                listener.beforeStore(folder, transaction, dictionary);
            }
            this.saveOrUpdate(folder);
            if (folder.getDeleted() == 0 && StringUtils.isEmpty(folder.getPath())) {
                folder = (Folder)this.findById(folder.getId());
                this.initialize(folder);
                folder.setPath(this.computePath(folder.getId()));
                this.saveOrUpdate(folder);
            }
            if (folder.getDeleted() == 0 && folder.getId() != 0L) {
                folder = (Folder)this.findById(folder.getId());
                this.initialize(folder);
            }
            this.log.debug("Invoke listeners after store");
            for (FolderListener listener : this.listenerManager.getListeners()) {
                listener.afterStore(folder, transaction, dictionary);
            }
            this.saveFolderHistory(new Folder(folder), transaction);
        }
        catch (PersistenceException e) {
            this.handleStoreError(transaction, e);
        }
    }

    private void removeForbiddenPermissionsForGuests(Folder folder) throws PersistenceException {
        GroupDAO gDao = Context.get(GroupDAO.class);
        for (FolderAccessControlEntry ace : folder.getAccessControlList()) {
            Group group = (Group)gDao.findById(ace.getGroupId());
            if (group == null || !group.isGuest()) continue;
            ace.setAdd(0);
            ace.setArchive(0);
            ace.setAutomation(0);
            ace.setCalendar(0);
            ace.setDelete(0);
            ace.setExport(0);
            ace.setImmutable(0);
            ace.setImport(0);
            ace.setMove(0);
            ace.setPassword(0);
            ace.setRename(0);
            ace.setSecurity(0);
            ace.setSign(0);
            ace.setWorkflow(0);
            ace.setWrite(0);
            ace.setCustomid(0);
            ace.setRevision(0);
            ace.setReadingreq(0);
        }
    }

    private void workspaceChecks(Folder folder) throws PersistenceException {
        if (folder.getId() != 0L && folder.getType() == 1) {
            Folder root = this.findRoot(folder.getTenantId());
            if (root == null) {
                return;
            }
            if (folder.getParentId() != root.getId()) {
                throw new PersistenceException("You cannot move a workspace");
            }
            long defaultWorkspaceId = this.queryForLong("select ld_id from ld_folder where ld_parentid = :rootId and ld_name = :name", Map.of(ROOT_ID, root.getId(), "name", "Default"));
            if (folder.getId() == defaultWorkspaceId && !folder.getName().equals("Default")) {
                throw new PersistenceException("You cannot rename the default workspace");
            }
        }
    }

    private void updateAliases(Folder folder) {
        if (folder.getId() != 0L) {
            List<Folder> aliases = this.findAliases(folder.getId(), folder.getTenantId());
            for (Folder alias : aliases) {
                this.initialize(alias);
                alias.setDeleted(folder.getDeleted());
                alias.setDeleteUserId(folder.getDeleteUserId());
                if (folder.getSecurityRef() != null) {
                    alias.setSecurityRef(folder.getSecurityRef());
                } else {
                    alias.setSecurityRef(folder.getId());
                }
                this.saveOrUpdate(alias);
            }
        }
    }

    private void setCreator(Folder folder, FolderHistory transaction) {
        if (transaction != null) {
            if (folder.getId() == 0L && StringUtils.isEmpty(transaction.getEvent())) {
                transaction.setEvent(FolderEvent.CREATED);
            }
            if (FolderEvent.CREATED.toString().equals(transaction.getEvent())) {
                folder.setCreator(transaction.getUser() != null ? transaction.getUser().getFullName() : transaction.getUsername());
                folder.setCreatorId(transaction.getUserId());
            }
        }
    }

    private void handleStoreError(FolderHistory transaction, Throwable e) throws PersistenceException {
        Session session;
        if (transaction != null && StringUtils.isNotEmpty(transaction.getSessionId()) && (session = SessionManager.get().get(transaction.getSessionId())) != null) {
            session.logError(e.getMessage());
        }
        this.log.error(e.getMessage(), e);
        if (e instanceof PersistenceException) {
            PersistenceException pe = (PersistenceException)e;
            throw pe;
        }
        throw new PersistenceException(e);
    }

    private void setTags(Folder folder) {
        Set<Tag> src = folder.getTags();
        if (src != null && !src.isEmpty()) {
            HashSet<Tag> dst = new HashSet<Tag>();
            for (Tag str : src) {
                str.setTenantId(folder.getTenantId());
                String s = str.getTag();
                if (s == null) continue;
                if (s.length() > 255) {
                    s = s.substring(0, 255);
                    str.setTag(s);
                }
                if (dst.contains(str)) continue;
                dst.add(str);
            }
            folder.setTags(dst);
            folder.setTgs(folder.getTagsString());
        }
    }

    @Override
    public List<Folder> findByUserId(long userId) throws PersistenceException {
        List<Folder> folders = new ArrayList<Folder>();
        User user = this.getExistingtUser(userId);
        if (user.isMemberOf("admin")) {
            return this.findAll();
        }
        Set<Group> userGroups = user.getGroups();
        if (!userGroups.isEmpty()) {
            StringBuilder query = new StringBuilder("select distinct(_folder) from Folder _folder  ");
            query.append(" left join _folder.accessControlList as _acl ");
            query.append(WHERE_GROUP_GROUPID_IN);
            query.append(userGroups.stream().map(ug -> Long.toString(ug.getId())).collect(Collectors.joining(",")));
            query.append(")");
            folders = this.findByObjectQuery(query.toString(), new HashMap<String, Object>(), null);
            if (folders.isEmpty()) {
                return folders;
            }
            query = new StringBuilder("select _folder from Folder _folder  where _folder.securityRef in (");
            query.append(folders.stream().map(f -> Long.toString(f.getId())).collect(Collectors.joining(",")));
            query.append(")");
            List tmp = this.findByObjectQuery(query.toString(), null, null);
            for (Folder folder : tmp) {
                if (folders.contains(folder)) continue;
                folders.add(folder);
            }
        }
        return folders;
    }

    private User getExistingtUser(long userId) throws PersistenceException {
        User user = (User)this.userDAO.findById(userId);
        if (user == null) {
            throw new PersistenceException("Unexisting user " + userId);
        }
        return user;
    }

    @Override
    public List<Folder> findByUserId(long userId, long parentId) throws PersistenceException {
        List<Folder> accessibleFolders = new ArrayList<Folder>();
        User user = this.getExistingtUser(userId);
        if (user.isMemberOf("admin")) {
            return this.findByWhere("_entity.id!=_entity.parentId and _entity.parentId=" + parentId, "_entity.name ", null);
        }
        StringBuilder query1 = new StringBuilder();
        Set<Group> allUserGroups = user.getGroups();
        if (allUserGroups.isEmpty()) {
            return accessibleFolders;
        }
        String allUserGroupIds = allUserGroups.stream().map(ug -> Long.toString(ug.getId())).collect(Collectors.joining(","));
        query1.append("select distinct(_entity)  from Folder _entity ");
        query1.append(" left join _entity.accessControlList as _acl ");
        query1.append(WHERE_GROUP_GROUPID_IN);
        query1.append(allUserGroupIds);
        query1.append(")  and _entity.parentId = :parentId and _entity.id != _entity.parentId");
        accessibleFolders = this.findByObjectQuery(query1.toString(), Map.of(PARENT_ID, parentId), null);
        StringBuilder query2 = new StringBuilder("select _entity from Folder _entity where _entity.deleted=0 and _entity.parentId = :parentId ");
        query2.append(" and _entity.securityRef in (");
        query2.append("    select distinct(B.id) from Folder B ");
        query2.append(" left join B.accessControlList as _acl");
        query2.append(WHERE_GROUP_GROUPID_IN);
        query2.append(allUserGroups.stream().map(ug -> Long.toString(ug.getId())).collect(Collectors.joining(",")));
        query2.append("))");
        List coll2 = this.findByObjectQuery(query2.toString(), Map.of(PARENT_ID, parentId), null);
        for (Folder folder : coll2) {
            if (accessibleFolders.contains(folder)) continue;
            accessibleFolders.add(folder);
        }
        Collections.sort(accessibleFolders, (o1, o2) -> -1 * o1.getName().compareTo(o2.getName()));
        return accessibleFolders;
    }

    @Override
    public List<Folder> findChildren(long parentId, Integer max) throws PersistenceException {
        Folder parent = this.findFolder(parentId);
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put(PARENT_ID, parent.getId());
        return this.findByWhere("_entity.parentId = :parentId and _entity.id!=_entity.parentId", params, "_entity.name", max);
    }

    @Override
    public List<Folder> findChildren(long parentId, long userId) throws PersistenceException {
        List<Folder> coll = new ArrayList<Folder>();
        Folder parent = this.findFolder(parentId);
        User user = this.getExistingtUser(userId);
        if (user.isMemberOf("admin")) {
            return this.findChildren(parent.getId(), null);
        }
        Set<Group> groups = user.getGroups();
        if (groups.isEmpty()) {
            return coll;
        }
        StringBuilder query1 = new StringBuilder("select distinct(_entity)  from Folder _entity  ");
        query1.append(" left join _entity.accessControlList as _acl ");
        query1.append(WHERE_GROUP_GROUPID_IN);
        query1.append(groups.stream().map(ug -> Long.toString(ug.getId())).collect(Collectors.joining(",")));
        query1.append(")  and _entity.parentId=" + parent.getId());
        query1.append(" and not(_entity.id=" + parent.getId() + ")");
        coll = this.findByObjectQuery(query1.toString(), null, null);
        StringBuilder query2 = new StringBuilder("select _entity from Folder _entity where _entity.deleted=0 and _entity.parentId = :parentId ");
        query2.append(" and _entity.securityRef in (");
        query2.append("    select distinct(B.id) from Folder B ");
        query2.append(" left join B.accessControlList as _acl");
        query2.append(WHERE_GROUP_GROUPID_IN);
        query2.append(groups.stream().map(ug -> Long.toString(ug.getId())).collect(Collectors.joining(",")));
        query2.append("))");
        query2.append(" and not(_entity.id=" + parent.getId() + ")");
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put(PARENT_ID, parent.getId());
        List<Folder> coll2 = this.findByQuery(query2.toString(), params, Folder.class, null);
        for (Folder folder : coll2) {
            if (coll.contains(folder)) continue;
            coll.add(folder);
        }
        return coll;
    }

    @Override
    public List<Folder> findByParentId(long parentId) {
        ArrayList<Folder> coll = new ArrayList<Folder>();
        Folder parent = null;
        try {
            parent = this.findFolder(parentId);
        }
        catch (PersistenceException e) {
            this.log.error(e.getMessage(), e);
        }
        if (parent == null) {
            return coll;
        }
        Collection ids = this.findFolderIdInTree(parent.getId(), false);
        for (Long id : ids) {
            if (parentId == id) continue;
            try {
                coll.add(this.findFolder(id));
            }
            catch (PersistenceException e) {
                this.log.error(e.getMessage(), e);
            }
        }
        return coll;
    }

    @Override
    public List<Long> findIdsByParentId(long parentId) {
        List<Folder> coll = this.findByParentId(parentId);
        if (coll == null || coll.isEmpty()) {
            return new ArrayList<Long>();
        }
        return coll.stream().map(PersistentObject::getId).toList();
    }

    @Override
    public boolean isPrintAllowed(long folderId, long userId) throws PersistenceException {
        return this.isPermissionAllowed(Permission.PRINT, folderId, userId);
    }

    @Override
    public boolean isWriteAllowed(long folderId, long userId) throws PersistenceException {
        return this.isPermissionAllowed(Permission.WRITE, folderId, userId);
    }

    @Override
    public boolean isDownloadllowed(long id, long userId) throws PersistenceException {
        return this.isPermissionAllowed(Permission.DOWNLOAD, id, userId);
    }

    @Override
    public boolean isMoveAllowed(long id, long userId) throws PersistenceException {
        return this.isPermissionAllowed(Permission.MOVE, id, userId);
    }

    @Override
    public boolean isPreviewAllowed(long id, long userId) throws PersistenceException {
        return this.isPermissionAllowed(Permission.PREVIEW, id, userId);
    }

    @Override
    public boolean isReadAllowed(long folderId, long userId) throws PersistenceException {
        Set<Group> userGroups;
        User user = this.getExistingtUser(userId);
        if (user.isMemberOf("admin")) {
            return true;
        }
        long id = folderId;
        Folder folder = (Folder)this.findById(folderId);
        if (folder == null) {
            return false;
        }
        if (folder.getSecurityRef() != null) {
            id = folder.getSecurityRef();
        }
        if ((userGroups = user.getGroups()).isEmpty()) {
            return false;
        }
        StringBuilder query = new StringBuilder("select distinct(ld_folderid) from ld_folder_acl where ld_read=1 and ld_groupid in (");
        query.append(userGroups.stream().map(g -> Long.toString(g.getId())).collect(Collectors.joining(",")));
        query.append(") and ld_folderid=" + id);
        return this.queryForLong(query.toString()) > 0L;
    }

    @Override
    public Collection<Long> findFolderIdByUserId(long userId, Long parentId, boolean tree) throws PersistenceException {
        return this.findFolderIdByUserIdAndPermission(userId, Permission.READ, parentId, tree);
    }

    @Override
    public boolean hasWriteAccess(Folder folder, long userId) throws PersistenceException {
        if (!this.isWriteAllowed(folder.getId(), userId)) {
            return false;
        }
        List<Folder> children = this.findByParentId(folder.getId());
        for (Folder subFolder : children) {
            if (this.hasWriteAccess(subFolder, userId)) continue;
            return false;
        }
        return true;
    }

    @Override
    public List<Folder> findByGroupId(long groupId) throws PersistenceException {
        if (groupId == 1L) {
            return this.findAll();
        }
        StringBuilder query = new StringBuilder("select distinct(_entity)  from Folder _entity  ");
        query.append(" left join _entity.accessControlList as _acl ");
        query.append(" where _entity.deleted=0 and _acl.ace.ace.groupId =" + groupId);
        List<Folder> coll = this.findByObjectQuery(query.toString(), null, null);
        if (!coll.isEmpty()) {
            StringBuilder query2 = new StringBuilder("select _entity from Folder _entity where _entity.deleted=0 ");
            query2.append(" and _entity.securityRef in (");
            boolean first = true;
            for (Folder folder : coll) {
                if (!first) {
                    query2.append(",");
                }
                query2.append(Long.toString(folder.getId()));
                first = false;
            }
            query2.append(")");
            List coll2 = this.findByObjectQuery(query2.toString(), null, null);
            for (Folder folder : coll2) {
                if (coll.contains(folder)) continue;
                coll.add(folder);
            }
        }
        return coll;
    }

    @Override
    public List<Long> findIdByUserId(long userId, long parentId) throws PersistenceException {
        List<Long> ids = new ArrayList<Long>();
        User user = this.getExistingtUser(userId);
        if (user.isMemberOf("admin")) {
            return this.findIdsByWhere("_entity.parentId=" + parentId, null, null);
        }
        Set<Group> precoll = user.getGroups();
        Iterator<Group> iter = precoll.iterator();
        if (!precoll.isEmpty()) {
            StringBuilder query1 = new StringBuilder("select distinct(A.ld_folderid) from ld_folder_acl A, ld_folder B  where B.ld_deleted=0 and A.ld_folderid=B.ld_id AND A.ld_read=1 and (B.ld_parentid=" + parentId + " OR B.ld_id=" + parentId + ") and A.ld_groupid in (");
            boolean first = true;
            while (iter.hasNext()) {
                if (!first) {
                    query1.append(",");
                }
                Group ug = iter.next();
                query1.append(Long.toString(ug.getId()));
                first = false;
            }
            query1.append(")");
            ids = this.queryForList(query1.toString(), Long.class);
            StringBuilder query2 = new StringBuilder("select B.ld_id from ld_folder B where B.ld_deleted=0 ");
            query2.append(" and B.ld_parentid=" + parentId);
            query2.append(" and B.ld_securityref in (");
            query2.append(query1.toString());
            query2.append(")");
            List<Long> folderids2 = this.queryForList(query2.toString(), Long.class);
            for (Long folderid : folderids2) {
                if (ids.contains(folderid)) continue;
                ids.add(folderid);
            }
        }
        return ids;
    }

    @Override
    public List<Folder> findByName(String name, Long tenantId) throws PersistenceException {
        return this.findByName(null, name, tenantId, true);
    }

    @Override
    public List<Folder> findByName(Folder parent, String name, Long tenantId, boolean caseSensitive) throws PersistenceException {
        StringBuilder query = new StringBuilder("select ld_id from ld_folder where ld_deleted = 0 and ");
        if (caseSensitive) {
            query.append("ld_name like '" + SqlUtil.doubleQuotes(name) + "' ");
        } else {
            query.append("lower(ld_name) like '" + SqlUtil.doubleQuotes(name.toLowerCase()) + "' ");
        }
        if (parent != null) {
            query.append(" and  ld_parentid=" + parent.getId());
            if (tenantId == null) {
                query.append(" and ld_tenantid = " + parent.getTenantId());
            }
        }
        if (tenantId != null) {
            query.append(" and ld_tenantid = " + String.valueOf(tenantId));
        }
        List<Long> ids = this.queryForList(query.toString(), Long.class);
        ArrayList<Folder> folders = new ArrayList<Folder>();
        for (Long id : ids) {
            folders.add((Folder)this.findById(id));
        }
        return folders;
    }

    @Override
    public String computePath(long folderId) throws PersistenceException {
        return this.computePath((Folder)this.findById(folderId));
    }

    @Override
    public String computePath(Folder folder) throws PersistenceException {
        if (folder == null) {
            return null;
        }
        Folder root = this.findRoot(folder.getTenantId());
        if (root == null) {
            return null;
        }
        long rootId = root.getId();
        Object path = !folder.equals(root) ? Long.toString(folder.getId()) : SLASH;
        while (folder != null && folder.getId() != folder.getParentId() && folder.getId() != rootId) {
            if ((folder = (Folder)this.findById(folder.getParentId())) == null) continue;
            StringBuilder sb = new StringBuilder(folder.getId() != rootId ? Long.toString(folder.getId()) : "");
            sb.append(SLASH);
            sb.append((String)path);
            path = sb.toString();
        }
        if (!((String)path).startsWith(SLASH)) {
            path = SLASH + (String)path;
        }
        return path;
    }

    @Override
    public String computePathExtended(long folderId) throws PersistenceException {
        return this.computePathExtended((Folder)this.findById(folderId));
    }

    @Override
    public String computePathExtended(Folder folder) throws PersistenceException {
        if (folder == null) {
            return null;
        }
        Folder root = this.findRoot(folder.getTenantId());
        if (root == null) {
            return null;
        }
        long rootId = root.getId();
        Object path = folder.getId() != rootId ? folder.getName() : "";
        while (folder != null && folder.getId() != folder.getParentId() && folder.getId() != rootId) {
            if ((folder = (Folder)this.findById(folder.getParentId())) == null) continue;
            StringBuilder sb = new StringBuilder(folder.getId() != rootId ? folder.getName() : "");
            sb.append(SLASH);
            sb.append((String)path);
            path = sb.toString();
        }
        if (!((String)path).startsWith(SLASH)) {
            path = SLASH + (String)path;
        }
        return path;
    }

    @Override
    public void saveFolderHistory(Folder folder, FolderHistory transaction) throws PersistenceException {
        Folder parent;
        if (folder == null || transaction == null || !RunLevel.current().aspectEnabled("saveHistory")) {
            return;
        }
        Folder root = this.findRoot(folder.getTenantId());
        if (root == null) {
            throw new PersistenceException(String.format("Unable to find root for folder %s", folder.toString()));
        }
        long rootId = root.getId();
        transaction.setNotified(0);
        transaction.setFolderId(folder.getId());
        transaction.setTenantId(folder.getTenantId());
        Tenant tenant = (Tenant)Context.get(TenantDAO.class).findById(folder.getTenantId());
        if (tenant != null) {
            transaction.setTenant(tenant.getName());
        }
        transaction.setFilename(folder.getId() != rootId ? folder.getName() : SLASH);
        String pathExtended = transaction.getPath();
        if (StringUtils.isEmpty(pathExtended)) {
            pathExtended = this.computePathExtended(folder.getId());
        }
        transaction.setPath(pathExtended);
        transaction.setFolder(folder);
        transaction.setColor(folder.getColor());
        this.historyDAO.store(transaction);
        if (folder.getId() != folder.getParentId() && folder.getId() != rootId && (parent = (Folder)this.findById(folder.getParentId())) != null) {
            this.saveHistoryInParentFolder(parent, folder, transaction, pathExtended);
        }
    }

    private void saveHistoryInParentFolder(Folder parent, Folder folder, FolderHistory transaction, String pathExtended) {
        FolderHistory parentHistory = new FolderHistory(transaction);
        parentHistory.setFolderId(parent.getId());
        parentHistory.setFilename(folder.getName());
        parentHistory.setPath(pathExtended);
        parentHistory.setUser(transaction.getUser());
        parentHistory.setComment("");
        parentHistory.setSessionId(transaction.getSessionId());
        parentHistory.setComment(transaction.getComment());
        parentHistory.setPathOld(transaction.getPathOld());
        parentHistory.setFilenameOld(transaction.getFilenameOld());
        parentHistory.setColor(transaction.getColor());
        if (transaction.getEvent().equals(FolderEvent.CREATED.toString()) || transaction.getEvent().equals(FolderEvent.MOVED.toString())) {
            parentHistory.setEvent(FolderEvent.SUBFOLDER_CREATED);
        } else if (transaction.getEvent().equals(FolderEvent.RENAMED.toString())) {
            parentHistory.setEvent(FolderEvent.SUBFOLDER_RENAMED);
        } else if (transaction.getEvent().equals(FolderEvent.PERMISSION.toString())) {
            parentHistory.setEvent(FolderEvent.SUBFOLDER_PERMISSION);
        } else if (transaction.getEvent().equals(FolderEvent.DELETED.toString())) {
            parentHistory.setEvent(FolderEvent.SUBFOLDER_DELETED);
        } else if (transaction.getEvent().equals(FolderEvent.CHANGED.toString())) {
            parentHistory.setEvent(FolderEvent.SUBFOLDER_CHANGED);
        } else if (transaction.getEvent().equals(FolderEvent.RESTORED.toString())) {
            parentHistory.setEvent(FolderEvent.SUBFOLDER_RESTORED);
        }
        if (StringUtils.isNotEmpty(parentHistory.getEvent())) {
            try {
                this.historyDAO.store(parentHistory);
            }
            catch (PersistenceException e) {
                this.log.warn(e.getMessage(), e);
            }
        }
    }

    @Override
    public List<Folder> findByNameAndParentId(String name, long parentId) throws PersistenceException {
        return this.findByWhere("_entity.parentId=" + parentId + " and _entity.name like '" + SqlUtil.doubleQuotes(name) + "'", null, null);
    }

    @Override
    public List<Folder> findParents(long folderId) throws PersistenceException {
        Folder folder = (Folder)this.findById(folderId);
        if (folder == null) {
            return new ArrayList<Folder>();
        }
        long rootId = this.findRoot(folder.getTenantId()).getId();
        ArrayList<Folder> coll = new ArrayList<Folder>();
        while (folder != null && folder.getId() != rootId && folder.getId() != folder.getParentId()) {
            if ((folder = (Folder)this.findById(folder.getParentId())) == null) continue;
            coll.add(0, folder);
        }
        return coll;
    }

    @Override
    public Folder findWorkspace(long folderId) throws PersistenceException {
        Folder folder = (Folder)this.findById(folderId);
        if (folder != null && folder.isWorkspace()) {
            return folder;
        }
        List<Folder> parents = this.findParents(folderId);
        for (Folder parent : parents) {
            if (SLASH.equals(parent.getName()) || !parent.isWorkspace()) continue;
            return parent;
        }
        return null;
    }

    @Override
    public boolean isPermissionAllowed(Permission permission, long folderId, long userId) throws PersistenceException {
        Set<Permission> permissions = this.getAllowedPermissions(folderId, userId);
        return permissions.contains((Object)permission);
    }

    @Override
    public void restore(long folderId, long parentId, FolderHistory transaction) throws PersistenceException {
        Collection treeIds;
        Folder fld;
        Folder parent = this.findFolder(parentId);
        int count = this.jdbcUpdate("update ld_folder set ld_deleted=0, ld_parentid=" + parent.getId() + ", ld_lastmodified=CURRENT_TIMESTAMP where not ld_type=1 and ld_id=" + folderId);
        if (count == 0) {
            Folder root = this.findRoot(parent.getTenantId());
            this.jdbcUpdate("update ld_folder set ld_deleted=0, ld_parentid=" + root.getId() + ", ld_lastmodified=CURRENT_TIMESTAMP where ld_type=1 and ld_id=" + folderId);
        }
        if ((fld = this.findFolder(folderId)) != null && transaction != null) {
            transaction.setEvent(FolderEvent.RESTORED);
            this.saveFolderHistory(fld, transaction);
        }
        if (!(treeIds = this.findFolderIdInTree(folderId, true)).isEmpty()) {
            String idsStr = treeIds.toString().replace('[', '(').replace(']', ')');
            this.jdbcUpdate("update ld_folder set ld_deleted=0, ld_lastmodified=CURRENT_TIMESTAMP where ld_deleted=1 and ld_id in " + idsStr);
            this.jdbcUpdate("update ld_document set ld_deleted=0, ld_lastmodified=CURRENT_TIMESTAMP where ld_deleted=1 and ld_folderid in " + idsStr);
        }
    }

    @Override
    public Set<Permission> getAllowedPermissions(long folderId, long userId) throws PersistenceException {
        HashSet<Permission> permissions = new HashSet<Permission>();
        User user = this.getExistingtUser(userId);
        if (user.isMemberOf("admin")) {
            return Permission.all();
        }
        Set<Group> userGroups = user.getGroups();
        if (userGroups.isEmpty()) {
            return permissions;
        }
        long id = folderId;
        Folder folder = (Folder)this.findById(folderId);
        if (folder == null) {
            return new HashSet<Permission>();
        }
        if (folder.getSecurityRef() != null) {
            id = folder.getSecurityRef();
            this.log.debug("Use the security reference {}", (Object)id);
        }
        StringBuilder query = new StringBuilder("                 select ld_read as LDREAD, ld_write as LDWRITE, ld_add as LDADD, ld_security as LDSECURITY, ld_immutable as LDIMMUTABLE,\n                 ld_delete as LDDELETE, ld_rename as LDRENAME, ld_import as LDIMPORT, ld_export as LDEXPORT, ld_sign as LDSIGN,\n                 ld_archive as LDARCHIVE, ld_workflow as LDWORKFLOW, ld_download as LDDOWNLOAD, ld_calendar as LDCALENDAR,\n                 ld_subscription as LDSUBSCRIPTION, ld_print as LDPRINT, ld_password as LDPASSWORD, ld_move as LDMOVE, ld_email as LDEMAIL,\n                 ld_automation LDAUTOMATION, ld_store LDSTORE, ld_readingreq LDREADINGREQ, ld_preview LDPREVIEW, ld_customid LDCUSTOMID\n");
        query.append(" from ld_folder_acl ");
        query.append(WHERE);
        query.append(" ld_folderid=" + id);
        query.append(" and ld_groupid in (select ld_groupid from ld_usergroup where ld_userid=");
        query.append(Long.toString(userId));
        query.append(")");
        HashMap<String, Permission> permissionColumn = new HashMap<String, Permission>();
        permissionColumn.put("LDADD", Permission.ADD);
        permissionColumn.put("LDEXPORT", Permission.EXPORT);
        permissionColumn.put("LDIMPORT", Permission.IMPORT);
        permissionColumn.put("LDDELETE", Permission.DELETE);
        permissionColumn.put("LDIMMUTABLE", Permission.IMMUTABLE);
        permissionColumn.put("LDSECURITY", Permission.SECURITY);
        permissionColumn.put("LDRENAME", Permission.RENAME);
        permissionColumn.put("LDWRITE", Permission.WRITE);
        permissionColumn.put("LDREAD", Permission.READ);
        permissionColumn.put("LDSIGN", Permission.SIGN);
        permissionColumn.put("LDARCHIVE", Permission.ARCHIVE);
        permissionColumn.put("LDWORKFLOW", Permission.WORKFLOW);
        permissionColumn.put("LDDOWNLOAD", Permission.DOWNLOAD);
        permissionColumn.put("LDCALENDAR", Permission.CALENDAR);
        permissionColumn.put("LDSUBSCRIPTION", Permission.SUBSCRIPTION);
        permissionColumn.put("LDPRINT", Permission.PRINT);
        permissionColumn.put("LDPASSWORD", Permission.PASSWORD);
        permissionColumn.put("LDMOVE", Permission.MOVE);
        permissionColumn.put("LDEMAIL", Permission.EMAIL);
        permissionColumn.put("LDAUTOMATION", Permission.AUTOMATION);
        permissionColumn.put("LDSTORE", Permission.STORE);
        permissionColumn.put("LDREADINGREQ", Permission.READINGREQ);
        permissionColumn.put("LDPREVIEW", Permission.PREVIEW);
        permissionColumn.put("LDCUSTOMID", Permission.CUSTOMID);
        this.queryForResultSet(query.toString(), null, null, rows -> {
            while (rows.next()) {
                for (Map.Entry entry : permissionColumn.entrySet()) {
                    String column = (String)entry.getKey();
                    Permission permission = (Permission)((Object)((Object)entry.getValue()));
                    if (rows.getInt(column) != 1) continue;
                    permissions.add(permission);
                }
            }
        });
        return permissions;
    }

    @Override
    public Collection<Long> findFolderIdByUserIdInPath(long userId, long parentId) throws PersistenceException {
        List<Long> masterIds;
        HashSet<Long> ids = new HashSet<Long>();
        User user = this.getExistingtUser(userId);
        this.getExistingFolder(parentId);
        if (user.isMemberOf("admin")) {
            return this.findFolderIdInPath(parentId, false);
        }
        StringBuilder query1 = new StringBuilder("select distinct(A.ld_folderid) from ld_folder_acl A where A.ld_read=1 ");
        List<Long> groupIds = user.getUserGroups().stream().map(UserGroup::getGroupId).toList();
        if (!groupIds.isEmpty()) {
            query1.append(AND_LDGROUPID_IN);
            query1.append(StringUtil.arrayToString(groupIds.toArray(new Long[0]), ","));
            query1.append(") ");
        }
        if ((masterIds = this.queryForList(query1.toString(), Long.class)).isEmpty()) {
            return ids;
        }
        StringBuilder query2 = new StringBuilder("select B.ld_id from ld_folder B where B.ld_deleted=0 and ( ");
        if (this.isOracle()) {
            query2.append("(B.ld_id,0) in ( ");
            query2.append(masterIds.stream().map(id -> "(" + String.valueOf(id) + ",0)").collect(Collectors.joining(",")));
            query2.append(" ) ");
        } else {
            query2.append(" B.ld_id in " + masterIds.toString().replace('[', '(').replace(']', ')'));
        }
        query2.append(" or ");
        if (this.isOracle()) {
            query2.append(" (B.ld_securityref,0) in ( ");
            query2.append(masterIds.stream().map(id -> "(" + String.valueOf(id) + ",0)").collect(Collectors.joining(",")));
            query2.append(" ) ");
        } else {
            query2.append(" B.ld_securityref in " + masterIds.toString().replace('[', '(').replace(']', ')'));
        }
        query2.append(" ) ");
        query2.append(AND);
        Collection folderIds = this.findFolderIdInPath(parentId, false);
        if (this.isOracle()) {
            query2.append("( (B.ld_id,0) in ( ");
            query2.append(folderIds.stream().map(id -> "(" + String.valueOf(id) + ",0)").collect(Collectors.joining(",")));
            query2.append(" ) )");
        } else {
            query2.append("  B.ld_id in " + folderIds.toString().replace('[', '(').replace(']', ')'));
        }
        ids.addAll(this.queryForList(query2.toString(), Long.class));
        return ids;
    }

    @Override
    public Collection<Long> findFolderIdByUserIdAndPermission(long userId, Permission permission, Long parentId, boolean tree) throws PersistenceException {
        User user = this.getExistingtUser(userId);
        HashSet<Long> ids = new HashSet<Long>();
        if (user.isMemberOf("admin") && parentId != null) {
            if (tree) {
                return this.findFolderIdInTree(parentId, false);
            }
            StringBuilder query = new StringBuilder("select ld_id from ld_folder where ld_deleted=0 ");
            query.append(" and (ld_id=" + String.valueOf(parentId));
            query.append(" or ld_parentid=" + String.valueOf(parentId));
            query.append(") ");
            return this.queryForList(query.toString(), Long.class);
        }
        StringBuilder query1 = new StringBuilder("select distinct(A.ld_folderid) from ld_folder_acl A where A.ld_read=1 ");
        if (permission != Permission.READ) {
            query1.append(" and A.ld_" + permission.name().toLowerCase() + "=1 ");
        }
        this.appendUserGroupIdsCondition(user, query1);
        List<Long> masterIds = this.queryForList(query1.toString(), Long.class);
        if (masterIds.isEmpty()) {
            return ids;
        }
        String masterIdsString = masterIds.toString().replace('[', '(').replace(']', ')');
        StringBuilder query2 = new StringBuilder("select B.ld_id from ld_folder B where B.ld_deleted=0 ");
        query2.append(" and ( B.ld_id in " + masterIdsString);
        query2.append(" or B.ld_securityref in " + masterIdsString + ") ");
        this.appendParentCondition(parentId, query2, tree);
        ids.addAll(this.queryForList(query2.toString(), Long.class));
        return ids;
    }

    private void appendParentCondition(Long parentId, StringBuilder query, boolean tree) {
        if (parentId != null) {
            query.append(AND);
            if (tree) {
                Collection folderIds = this.findFolderIdInTree(parentId, false);
                if (this.isOracle()) {
                    query.append("( (B.ld_id,0) in ( ");
                    query.append(folderIds.stream().map(id -> "(" + String.valueOf(id) + ",0)").collect(Collectors.joining(",")));
                    query.append(" ) )");
                } else {
                    query.append("  B.ld_id in " + folderIds.toString().replace('[', '(').replace(']', ')'));
                }
            } else {
                query.append(" (B.ld_id=" + String.valueOf(parentId) + " or B.ld_parentId=" + String.valueOf(parentId) + ") ");
            }
        }
    }

    private void appendUserGroupIdsCondition(User user, StringBuilder query) {
        List<String> groupIds = user.getUserGroups().stream().map(g -> Long.toString(g.getGroupId())).toList();
        if (!groupIds.isEmpty()) {
            query.append(AND_LDGROUPID_IN);
            query.append(groupIds.stream().collect(Collectors.joining(",")));
            query.append(") ");
        }
    }

    @Override
    public void deleteAll(Collection<Folder> folders, FolderHistory transaction) throws PersistenceException {
        this.deleteAll(folders, 1, transaction);
    }

    @Override
    public void deleteAll(Collection<Folder> folders, int code, FolderHistory transaction) throws PersistenceException {
        for (Folder folder : folders) {
            FolderHistory deleteHistory = new FolderHistory(transaction);
            deleteHistory.setEvent(FolderEvent.DELETED);
            deleteHistory.setFolderId(folder.getId());
            deleteHistory.setPath(this.computePathExtended(folder.getId()));
            try {
                this.delete(folder.getId(), code, deleteHistory);
            }
            catch (PersistenceException e) {
                this.log.warn("Error deleting folder " + folder.getId() + ", it may be normal", e);
            }
        }
    }

    private void checkIfCanDelete(long folderId) throws PersistenceException {
        Folder folder = (Folder)this.findById(folderId);
        long rootId = this.findRoot(folder.getTenantId()).getId();
        if (folderId == rootId) {
            throw new PersistenceException("You cannot delete folder " + folder.getName() + " - " + folderId);
        }
        if (folder.getName().equals("Default") && folder.getParentId() == rootId) {
            throw new PersistenceException("You cannot delete folder " + folder.getName() + " - " + folderId);
        }
    }

    @Override
    public void delete(long folderId, int code) throws PersistenceException {
        this.checkIfCanDelete(folderId);
        super.delete(folderId, code);
    }

    @Override
    public void delete(long folderId, FolderHistory transaction) throws PersistenceException {
        this.delete(folderId, 1, transaction);
    }

    @Override
    public void delete(long folderId, int delCode, FolderHistory transaction) throws PersistenceException {
        List<Folder> aliases;
        if (!this.checkStoringAspect()) {
            return;
        }
        this.checkIfCanDelete(folderId);
        this.validateTransactionAndUser(transaction);
        Folder folder = (Folder)this.findById(folderId);
        this.prepareHistory(folder, delCode, transaction);
        this.store(folder, transaction);
        if (folder.getFoldRef() == null && folder.getType() != 2 && (aliases = this.findAliases(folder.getId(), folder.getTenantId())) != null && !aliases.isEmpty()) {
            String aliasIds = aliases.stream().map(f -> Long.toString(f.getId())).collect(Collectors.joining(","));
            this.log.debug("Deleting the aliases to folder {}: {}", (Object)folder, (Object)aliasIds);
            int count = this.jdbcUpdate("update set ld_deleted=" + delCode + " from ld_folder where ld_foldref in (" + aliasIds + ")");
            this.log.info("Removed {} aliases pointing to the deleted folder {}", (Object)count, (Object)folderId);
        }
        long updatedRows = this.jdbcUpdate("update ld_folder set ld_securityref=null where ld_securityref=" + folderId);
        this.log.debug("Cleared {} secuerity refs pointing to the deleted folder {}", (Object)updatedRows, (Object)folderId);
    }

    private void validateTransactionAndUser(FolderHistory transaction) throws PersistenceException {
        this.validateTransaction(transaction);
        if (transaction.getUser() == null) {
            throw new PersistenceException("No user specified in transaction");
        }
    }

    private void validateTransaction(FolderHistory transaction) throws PersistenceException {
        if (transaction == null) {
            throw new PersistenceException("No transaction");
        }
    }

    private void prepareHistory(Folder folder, int delCode, FolderHistory transaction) throws PersistenceException {
        transaction.setPath(this.computePathExtended(folder.getId()));
        transaction.setEvent(FolderEvent.DELETED);
        transaction.setFolderId(folder.getId());
        transaction.setTenantId(folder.getTenantId());
        folder.setDeleted(delCode);
        folder.setDeleteUserId(transaction.getUserId());
        if (transaction.getUser() != null) {
            folder.setDeleteUser(transaction.getUser().getFullName());
        } else {
            folder.setDeleteUser(transaction.getUsername());
        }
    }

    @Override
    public void applySecurityToTree(long rootId, FolderHistory transaction) throws PersistenceException {
        this.validateTransaction(transaction);
        if (transaction.getSessionId() == null) {
            throw new PersistenceException("No session specified in transaction");
        }
        if (!this.checkStoringAspect()) {
            return;
        }
        Folder folder = this.getExistingFolder(rootId);
        long securityRef = rootId;
        if (folder.getSecurityRef() != null && folder.getId() != folder.getSecurityRef().longValue()) {
            securityRef = folder.getSecurityRef();
        }
        Collection treeIds = this.findFolderIdInTree(folder.getId(), true);
        String treeIdsString = treeIds.toString().replace('[', '(').replace(']', ')');
        int records = 0;
        records = this.jdbcUpdate("update ld_folder set ld_securityref = :securityRef, ld_lastmodified = :lastModified where not ld_id = :rootId  and ld_id in " + treeIdsString, Map.of("securityRef", securityRef, "lastModified", new Date(), ROOT_ID, rootId));
        this.log.warn("Applied security to {} folders in tree {}", (Object)records, (Object)rootId);
        this.jdbcUpdate("delete from ld_folder_acl where not ld_folderid = :rootId and ld_folderid in " + treeIdsString, Map.of(ROOT_ID, rootId));
        this.log.warn("Removed {} specific rights in tree {}", (Object)records, (Object)rootId);
        if (this.sessionFactory.getCache() != null) {
            this.sessionFactory.getCache().evictEntityData(Folder.class);
            this.sessionFactory.getCache().evictCollectionData(Folder.class.getCanonicalName() + ".accessControlList");
        }
    }

    @Override
    public Folder createAlias(long parentId, long foldRef, FolderHistory transaction) throws PersistenceException {
        Folder targetFolder = this.getExistingFolder(foldRef);
        Folder parentFolder = this.getExistingFolder(parentId);
        List<Folder> parents = this.findParents(parentId);
        parents.add(parentFolder);
        for (Folder p : parents) {
            if (p.getId() != foldRef) continue;
            throw new PersistenceException("Cycle detected. The alias cannot reference a parent folder");
        }
        if (transaction != null) {
            transaction.setTenantId(targetFolder.getTenantId());
        }
        Folder folderVO = new Folder();
        folderVO.setName(targetFolder.getName());
        folderVO.setDescription(targetFolder.getDescription());
        folderVO.setColor(targetFolder.getColor());
        folderVO.setTenantId(targetFolder.getTenantId());
        folderVO.setType(2);
        if (targetFolder.getSecurityRef() != null) {
            folderVO.setSecurityRef(targetFolder.getSecurityRef());
        } else {
            folderVO.setSecurityRef(targetFolder.getId());
        }
        folderVO.setFoldRef(targetFolder.getId());
        Folder aliasFolder = this.create(parentFolder, folderVO, false, transaction);
        if (aliasFolder != null && transaction != null) {
            FolderHistory aliasHistory = new FolderHistory(transaction);
            aliasHistory.setFolder(targetFolder);
            aliasHistory.setEvent(FolderEvent.ALIAS_CREATED);
            this.saveFolderHistory(targetFolder, aliasHistory);
        }
        return aliasFolder;
    }

    @Override
    public Folder create(Folder parent, Folder folderVO, boolean inheritSecurity, FolderHistory transaction) throws PersistenceException {
        if (!Hibernate.isInitialized((parent = this.findFolder(parent)).getAttributes())) {
            this.initialize(parent);
        }
        Folder folder = new Folder();
        folder.setName(folderVO.getName());
        folder.setType(folderVO.getType());
        folder.setDescription(folderVO.getDescription());
        folder.setTenantId(parent.getTenantId());
        folder.setParentId(parent.getId());
        this.setCreator(folder, folderVO);
        this.setUniqueName(folder);
        folder.setTemplate(folderVO.getTemplate());
        folder.setTemplateLocked(folderVO.getTemplateLocked());
        this.setExtendedAttributes(folder, folderVO);
        folder.setQuotaDocs(folderVO.getQuotaDocs());
        folder.setQuotaSize(folderVO.getQuotaSize());
        if (folderVO.getFoldRef() != null) {
            folder.setFoldRef(folderVO.getFoldRef());
            folder.setSecurityRef(folderVO.getSecurityRef());
        } else if (inheritSecurity) {
            if (parent.getSecurityRef() != null) {
                folder.setSecurityRef(parent.getSecurityRef());
            } else {
                folder.setSecurityRef(parent.getId());
            }
        } else if (transaction != null && transaction.getUserId() != 0L) {
            User user = (User)this.userDAO.findById(transaction.getUserId());
            this.userDAO.initialize(user);
            if (!user.isMemberOf("admin")) {
                Group userGroup = user.getUserGroup();
                FolderAccessControlEntry ace = new FolderAccessControlEntry(userGroup.getId());
                ace.setAdd(1);
                ace.setDelete(1);
                ace.setDownload(1);
                ace.setEmail(1);
                ace.setSecurity(1);
                ace.setRead(1);
                ace.setSecurity(1);
                ace.setRename(1);
                ace.setWrite(1);
                folder.addAccessControlEntry(ace);
            }
        }
        if (transaction != null) {
            transaction.setEvent(FolderEvent.CREATED);
        }
        this.replicateParentMetadata(folder, folderVO, parent);
        if (folderVO.getOcrTemplateId() != null) {
            folder.setOcrTemplateId(folderVO.getOcrTemplateId());
        } else {
            folder.setOcrTemplateId(parent.getOcrTemplateId());
        }
        if (folderVO.getBarcodeTemplateId() != null) {
            folder.setBarcodeTemplateId(folderVO.getBarcodeTemplateId());
        } else {
            folder.setBarcodeTemplateId(parent.getBarcodeTemplateId());
        }
        this.store(folder, transaction);
        return folder;
    }

    private void setExtendedAttributes(Folder folder, Folder folderVO) {
        if (folderVO.getAttributes() != null && !folderVO.getAttributes().isEmpty()) {
            for (String name : folderVO.getAttributes().keySet()) {
                folder.getAttributes().put(name, folderVO.getAttributes().get(name));
            }
        }
    }

    private void replicateParentMetadata(Folder folder, Folder folderVO, Folder parent) {
        if (parent.getTemplate() != null && folderVO.getTemplate() == null && folderVO.getFoldRef() == null) {
            folder.setTemplate(parent.getTemplate());
            for (String att : parent.getAttributeNames()) {
                Attribute ext = new Attribute(parent.getAttributes().get(att));
                folder.getAttributes().put(att, ext);
            }
        }
    }

    private void setCreator(Folder folder, Folder folderVO) {
        if (folderVO.getCreation() != null) {
            folder.setCreation(folderVO.getCreation());
        }
        if (folderVO.getCreatorId() != null) {
            folder.setCreatorId(folderVO.getCreatorId());
        }
        if (folderVO.getCreator() != null) {
            folder.setCreator(folderVO.getCreator());
        }
    }

    @Override
    public Folder createPath(Folder parent, String path, boolean inheritSecurity, FolderHistory transaction) throws PersistenceException {
        if (!this.checkStoringAspect()) {
            return null;
        }
        StringTokenizer st = new StringTokenizer(path, SLASH, false);
        Folder root = this.findRoot(parent.getTenantId());
        Folder folder = this.findFolder(parent.getId());
        while (st.hasMoreTokens()) {
            String name = st.nextToken();
            long child = this.queryForLong("select ld_id from ld_folder where ld_deleted=0 and ld_parentid = :folderId and ld_name = :name and ld_tenantid = :tenantId", Map.of("folderId", folder.getId(), "name", name, "tenantId", folder.getTenantId()));
            if (child == 0L) {
                Folder folderVO = new Folder();
                folderVO.setName(name);
                folderVO.setType(root.equals(folder) ? 1 : 0);
                this.initialize(folder);
                folder = this.create(folder, folderVO, inheritSecurity, transaction != null ? new FolderHistory(transaction) : null);
                this.flush();
                continue;
            }
            folder = (Folder)this.findById(child);
        }
        return folder;
    }

    @Override
    public Folder findByPathExtended(String pathExtended, long tenantId) throws PersistenceException {
        if (StringUtils.isEmpty(pathExtended)) {
            return null;
        }
        StringTokenizer st = new StringTokenizer(pathExtended, SLASH, false);
        Folder folder = this.findRoot(tenantId);
        while (st.hasMoreTokens()) {
            String token = st.nextToken();
            if (StringUtils.isEmpty(token)) continue;
            List<Folder> list = this.findByName(folder, token, tenantId, true);
            if (list.isEmpty()) {
                folder = null;
                break;
            }
            folder = list.get(0);
        }
        return folder;
    }

    private void setUniqueName(Folder folder) throws PersistenceException {
        String folderName = folder.getName();
        List<String> collisions = this.queryForList("select ld_name from ld_folder where ld_deleted=0 and ld_parentid=" + folder.getParentId() + " and ld_name like'" + SqlUtil.doubleQuotes(folderName) + "%' and not ld_id=" + folder.getId(), String.class);
        int counter = 1;
        while (collisions.contains(folder.getName())) {
            folder.setName(folderName + "(" + counter++ + ")");
        }
    }

    @Override
    public Folder copy(Folder source, Folder target, String newName, boolean foldersOnly, String securityOption, FolderHistory transaction) throws PersistenceException {
        Folder newFolder = this.internalCopy(source, target, newName, foldersOnly, securityOption, transaction);
        if (REPLICATE.equals(securityOption)) {
            String sourcePath = this.computePathExtended(source.getId());
            String newPath = this.computePathExtended(newFolder.getId());
            Collection childrenIds = this.findFolderIdInTree(newFolder.getId(), false);
            for (Long childId : childrenIds) {
                Folder child = (Folder)this.findById(childId);
                if (child.getSecurityRef() == null || !this.isInPath(source.getId(), child.getSecurityRef())) continue;
                this.initialize(child);
                String relativeSourcePathSecurityRef = this.computePathExtended(child.getSecurityRef()).substring(sourcePath.length());
                String copiedPathSecurityRef = newPath + relativeSourcePathSecurityRef;
                Folder copiedPathSecurityRefFolder = this.findByPathExtended(copiedPathSecurityRef, target.getTenantId());
                if (copiedPathSecurityRefFolder == null) continue;
                child.setSecurityRef(copiedPathSecurityRefFolder.getId());
                this.store(child);
            }
        }
        return newFolder;
    }

    private Folder internalCopy(Folder source, Folder target, String newName, boolean foldersOnly, String securityOption, FolderHistory transaction) throws PersistenceException {
        target = this.internalCopyValidation(source, target, securityOption, transaction);
        Folder newFolder = null;
        newFolder = this.createPath(target, StringUtils.isNotEmpty(newName) ? newName : source.getName(), "inherit".equals(securityOption), new FolderHistory(transaction));
        newFolder.setFoldRef(source.getFoldRef());
        this.replicateSecurityPolicies(source, securityOption, newFolder);
        DocumentDAO docDao = Context.get(DocumentDAO.class);
        DocumentManager docMan = Context.get(DocumentManager.class);
        if (!foldersOnly) {
            TemplateDAO tDao = Context.get(TemplateDAO.class);
            List templates = tDao.findAll(source.getTenantId());
            for (Template template : templates) {
                tDao.initialize(template);
            }
            List<Document> srcDocs = docDao.findByFolder(source.getId(), null);
            for (Document srcDoc : srcDocs) {
                docDao.initialize(srcDoc);
                Document newDoc = new Document(srcDoc);
                newDoc.setId(0L);
                newDoc.setCustomId(null);
                newDoc.setVersion(null);
                newDoc.setFileVersion(null);
                newDoc.setFolder(newFolder);
                newDoc.setIndexingStatus(IndexingStatus.TO_INDEX);
                newDoc.setStatus(DocumentStatus.UNLOCKED);
                newDoc.setImmutable(0);
                newDoc.setBarcoded(0);
                newDoc.setRating(0);
                newDoc.setOcrd(0);
                DocumentHistory documentTransaction = new DocumentHistory();
                documentTransaction.setSessionId(transaction.getSessionId());
                documentTransaction.setUser(transaction.getUser());
                documentTransaction.setUserId(transaction.getUserId());
                documentTransaction.setUsername(transaction.getUsername());
                documentTransaction.setComment(transaction.getComment());
                documentTransaction.setEvent(DocumentEvent.STORED);
                String oldDocResource = this.store.getResourceName(srcDoc, null, null);
                try {
                    Throwable throwable = null;
                    Object var19_21 = null;
                    try (InputStream is = this.store.getStream(srcDoc.getId(), oldDocResource);){
                        docMan.create(is, newDoc, documentTransaction);
                    }
                    catch (Throwable throwable2) {
                        if (throwable == null) {
                            throwable = throwable2;
                        } else if (throwable != throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                        throw throwable;
                    }
                }
                catch (IOException e) {
                    this.log.error(e.getMessage(), e);
                }
            }
        }
        List<Folder> children = this.findChildren(source.getId(), transaction.getUser().getId());
        for (Folder child : children) {
            this.internalCopy(child, newFolder, null, foldersOnly, securityOption, transaction);
        }
        return newFolder;
    }

    private Folder internalCopyValidation(Folder source, Folder target, String securityOption, FolderHistory transaction) throws PersistenceException {
        if (!(securityOption == null || "none".equals(securityOption) || "inherit".equals(securityOption) || REPLICATE.equals(securityOption))) {
            throw new IllegalArgumentException("Invalid security option " + securityOption);
        }
        if (source == null) {
            throw new IllegalArgumentException("Source folder cannot be null");
        }
        if (target == null) {
            throw new IllegalArgumentException("Target folder cannot be null");
        }
        if (transaction == null) {
            throw new IllegalArgumentException("transaction cannot be null");
        }
        if (transaction.getUser() == null) {
            throw new IllegalArgumentException("transaction user cannot be null");
        }
        target = this.findFolder(target);
        if (this.isInPath(source.getId(), target.getId())) {
            throw new IllegalArgumentException("Cannot copy a folder inside the same path");
        }
        return target;
    }

    private void replicateSecurityPolicies(Folder source, String securityOption, Folder newFolder) throws PersistenceException {
        if (REPLICATE.equals(securityOption) && newFolder.getFoldRef() == null) {
            this.initialize(source);
            this.initialize(newFolder);
            if (source.getSecurityRef() != null) {
                newFolder.setSecurityRef(source.getSecurityRef());
            } else {
                newFolder.getAccessControlList().clear();
                for (FolderAccessControlEntry ace : source.getAccessControlList()) {
                    newFolder.addAccessControlEntry(new FolderAccessControlEntry(ace));
                }
            }
            this.store(newFolder);
        }
    }

    @Override
    public void move(Folder source, Folder target, FolderHistory transaction) throws PersistenceException {
        if (source == null) {
            throw new PersistenceException("No source was specified");
        }
        if (target == null) {
            throw new PersistenceException("No target was specified");
        }
        this.validateTransactionAndUser(transaction);
        Folder targetFolder = this.findFolder(target.getId());
        this.initialize(targetFolder);
        if (this.isInPath(source.getId(), targetFolder.getId())) {
            throw new IllegalArgumentException("Cannot move a folder inside the same path");
        }
        this.initialize(source);
        long oldParent = source.getParentId();
        String pathExtendedOld = this.computePathExtended(source.getId());
        transaction.setPathOld(pathExtendedOld);
        String pathOld = this.computePath(source.getId());
        source.setParentId(targetFolder.getId());
        String pathNew = this.computePath(targetFolder.getId()) + SLASH + source.getId();
        source.setPath(pathNew);
        this.setUniqueName(source);
        transaction.setEvent(FolderEvent.MOVED);
        this.store(source, transaction);
        FolderHistory hist = new FolderHistory();
        hist.setFolderId(oldParent);
        hist.setEvent(FolderEvent.SUBFOLDER_MOVED);
        hist.setSessionId(transaction.getSessionId());
        hist.setUserId(transaction.getUserId());
        hist.setUsername(transaction.getUsername());
        hist.setFilename(source.getName());
        hist.setPath(transaction.getPath());
        hist.setPathOld(transaction.getPathOld());
        this.historyDAO.store(hist);
        this.jdbcUpdate("update ld_folder set ld_path=REPLACE(ld_path,'" + pathOld + "/','" + pathNew + "/') where ld_path is not null and ld_path like '" + pathOld + "/%'");
    }

    @Override
    public List<Folder> deleteTree(long folderId, FolderHistory transaction) throws PersistenceException {
        return this.deleteTree(folderId, 1, transaction);
    }

    @Override
    public List<Folder> deleteTree(long folderId, int delCode, FolderHistory transaction) throws PersistenceException {
        return this.deleteTree((Folder)this.findById(folderId), delCode, transaction);
    }

    @Override
    public List<Folder> deleteTree(Folder folder, int delCode, FolderHistory transaction) throws PersistenceException {
        if (!this.checkStoringAspect()) {
            throw new PersistenceException("Tree has not been deleted");
        }
        if (delCode == 0) {
            throw new PersistenceException("Deletion code cannot be 0");
        }
        if (folder == null) {
            throw new PersistenceException("No folder was specified");
        }
        this.validateTransactionAndUser(transaction);
        if (folder.getType() == 2) {
            this.delete(folder.getId(), delCode, transaction);
            return new ArrayList<Folder>();
        }
        ArrayList<Folder> notDeletableFolders = new ArrayList<Folder>();
        this.checkIfCanDelete(folder.getId());
        this.prepareHistory(folder, delCode, transaction);
        this.saveFolderHistory(folder, transaction);
        Collection treeIds = this.findFolderIdInTree(folder.getId(), false);
        treeIds.add(folder.getId());
        String treeIdsString = treeIds.toString().replace('[', '(').replace(']', ')');
        List<Long> ids = this.queryForList("select ld_folderid from ld_document where ld_deleted=0 and ld_immutable=1 and ld_folderid in " + treeIdsString, Long.class);
        if (ids != null && !ids.isEmpty()) {
            this.log.warn("Found undeletable documents in tree {} - {}", (Object)folder.getName(), (Object)folder.getId());
            for (Long id : ids) {
                notDeletableFolders.add((Folder)this.findById(id));
            }
            return notDeletableFolders;
        }
        this.evict(folder);
        int records = this.jdbcUpdate("update ld_folder set ld_deleted=" + delCode + " where  ld_id in " + treeIdsString);
        this.log.warn("Deleted {} folders in tree {} - {}", records, folder.getName(), folder.getId());
        this.jdbcUpdate("update ld_folder set ld_deleteuserid=" + String.valueOf(transaction.getUserId()) + " where  ld_id in " + treeIdsString);
        this.jdbcUpdate("update ld_folder set ld_deleteuser=:user where ld_id in " + treeIdsString, Map.of("user", transaction.getUser().getFullName()));
        int aliases = this.jdbcUpdate("update ld_folder set ld_deleted=" + delCode + " where  ld_foldref in " + treeIdsString);
        this.log.warn("Deleted {} folder aliases in tree {} - {}", aliases, folder.getName(), folder.getId());
        int documents = this.jdbcUpdate("update ld_document set ld_deleted=" + delCode + " where ld_folderid in " + treeIdsString);
        this.log.warn("Deleted {} documents in tree {} - {}", documents, folder.getName(), folder.getId());
        this.jdbcUpdate("update ld_document set ld_deleteuserid=" + String.valueOf(transaction.getUserId()) + " where  ld_folderid in " + treeIdsString);
        this.jdbcUpdate("update ld_document set ld_deleteuser=:user where  ld_folderid in " + treeIdsString, Map.of("user", transaction.getUser().getFullName()));
        if (this.sessionFactory.getCache() != null) {
            this.sessionFactory.getCache().evictEntityData(Folder.class);
        }
        this.log.warn("Deleted {} folders in tree {} - {}", records, folder.getName(), folder.getId());
        return notDeletableFolders;
    }

    public Set<Long> findFolderIdInTree(long rootId, boolean includeDeleted) {
        this.log.debug("findFolderIdInTree, rootID: {}, includeDeleted: {}", (Object)rootId, (Object)includeDeleted);
        HashSet<Long> ids = new HashSet<Long>();
        ids.add(rootId);
        List<Object> lastIds = new ArrayList<Long>();
        lastIds.add(rootId);
        while (!lastIds.isEmpty()) {
            Object idsExpression = "";
            if (this.isOracle()) {
                str = ids.stream().map(id -> "(" + String.valueOf(id) + ",0)").collect(Collectors.joining(","));
                idsExpression = " ( (ld_id,0) not in ( ";
                idsExpression = (String)idsExpression + str;
                idsExpression = (String)idsExpression + ") and (ld_parentid,0) in (";
                idsExpression = (String)idsExpression + str;
                idsExpression = (String)idsExpression + ") ) ";
            } else {
                str = ((Object)ids).toString().replace('[', '(').replace(']', ')');
                idsExpression = "(  ld_id not in " + str + " and ld_parentid in " + str + " ) ";
            }
            lastIds.clear();
            String query = "select ld_id from ld_folder where " + (includeDeleted ? "" : " ld_deleted=0 and ") + (String)idsExpression;
            this.log.debug("Executing query{}", (Object)query);
            try {
                lastIds = this.queryForList(query, Long.class);
                if (lastIds.isEmpty()) continue;
                ids.addAll(lastIds);
            }
            catch (PersistenceException e) {
                this.log.error(e.getMessage(), e);
            }
        }
        if (this.log.isDebugEnabled()) {
            this.log.debug("Got ids {}", (Object)ids);
        }
        return ids;
    }

    public Set<Long> findFolderIdInPath(long rootId, boolean includeDeleted) throws PersistenceException {
        HashSet<Long> ids = new HashSet<Long>();
        Folder rootFolder = null;
        try {
            rootFolder = (Folder)this.findById(rootId);
        }
        catch (PersistenceException e1) {
            this.log.error(e1.getMessage(), e1);
        }
        if (rootFolder == null) {
            this.log.warn("No root folder {}", (Object)rootId);
            return ids;
        }
        String query = "select ld_id from ld_folder where ld_tenantid=" + rootFolder.getTenantId() + (includeDeleted ? "" : " and ld_deleted=0 ");
        ids = new HashSet<Long>(this.queryForList(query = query + " and ld_path like '" + SqlUtil.doubleQuotes(rootFolder.getPath()) + "/%'", Long.class));
        if (!ids.contains(rootId)) {
            ids.add(rootId);
        }
        return ids;
    }

    @Override
    public List<Folder> find(String name, Long tenantId) throws PersistenceException {
        return this.findByName(null, "%" + name + "%", tenantId, false);
    }

    @Override
    public boolean isInPath(long folderId, long targetId) throws PersistenceException {
        for (Folder folder : this.findParents(targetId)) {
            if (folder.getId() != folderId) continue;
            return true;
        }
        return false;
    }

    @Override
    public int count(boolean computeDeleted) {
        try {
            return this.queryForInt("SELECT COUNT(A.ld_id) FROM ld_document A " + (computeDeleted ? "" : "WHERE A.ld_deleted = 0 "));
        }
        catch (PersistenceException e) {
            this.log.error(e.getMessage(), e);
            return 0;
        }
    }

    @Override
    public List<Folder> findWorkspaces(long tenantId) throws PersistenceException {
        Folder root = this.findRoot(tenantId);
        if (root == null) {
            return new ArrayList<Folder>();
        }
        long rootId = root.getId();
        List<Long> wsIds = this.queryForList("select ld_id from ld_folder where (not ld_id=" + rootId + ") and ld_deleted=0 and ld_parentid=" + rootId + " and ld_type=1 and ld_tenantid=" + tenantId + " order by lower(ld_name)", Long.class);
        ArrayList<Folder> workspaces = new ArrayList<Folder>();
        for (Long wsId : wsIds) {
            workspaces.add((Folder)this.findById(wsId));
        }
        return workspaces;
    }

    @Override
    public void initialize(Folder folder) {
        this.refresh(folder);
        if (folder.getAccessControlList() != null) {
            this.log.trace("Initialized {} aces", (Object)folder.getAccessControlList().size());
        }
        if (folder.getTags() != null) {
            this.log.trace("Initialized {} tags", (Object)folder.getTags().size());
        }
        if (folder.getAttributes() != null) {
            this.log.trace("Initialized {} attributes", (Object)folder.getAttributes().keySet().size());
        }
        if (folder.getStores() != null) {
            this.log.trace("Initialized {} stores", (Object)folder.getStores().keySet().size());
        }
    }

    @Override
    public List<Folder> findDeleted(long userId, Integer maxHits) {
        List<Folder> results = new ArrayList<Folder>();
        try {
            String query = "select ld_id, ld_name, ld_lastmodified, ld_color, ld_type from ld_folder where ld_deleted=1 and ld_deleteuserid = " + userId;
            BeanPropertyRowMapper mapper = new BeanPropertyRowMapper(){

                public Object mapRow(ResultSet rs, int rowNum) throws SQLException {
                    Folder fld = new Folder();
                    fld.setId(rs.getLong(1));
                    fld.setName(rs.getString(2));
                    fld.setLastModified(rs.getTimestamp(3));
                    fld.setColor(rs.getString(4));
                    fld.setType(rs.getInt(5));
                    return fld;
                }
            };
            results = this.query(query, mapper, maxHits);
        }
        catch (Exception e) {
            this.log.error(e.getMessage());
        }
        return results;
    }

    @Override
    public Folder findRoot(long tenantId) throws PersistenceException {
        List<Folder> folders = this.findByName(SLASH, tenantId);
        if (!folders.isEmpty()) {
            return folders.get(0);
        }
        return null;
    }

    @Override
    public Folder findDefaultWorkspace(long tenantId) throws PersistenceException {
        Folder root = this.findRoot(tenantId);
        if (root == null) {
            return null;
        }
        List workspaces = this.findByWhere("_entity.parentId=" + root.getId() + " and _entity.name = :wfName and _entity.tenantId=" + tenantId + " and _entity.type=1", Map.of("wfName", "Default"), null, null);
        if (workspaces.isEmpty()) {
            return null;
        }
        return (Folder)workspaces.get(0);
    }

    @Override
    public void updateSecurityRef(long folderId, long rightsFolderId, FolderHistory transaction) throws PersistenceException {
        Folder f = (Folder)this.findById(folderId);
        this.initialize(f);
        Folder rightsFolder = (Folder)this.findById(rightsFolderId);
        long securityRef = rightsFolderId;
        if (rightsFolder.getSecurityRef() != null) {
            securityRef = rightsFolder.getSecurityRef();
        }
        if (transaction != null) {
            transaction.setEvent(FolderEvent.PERMISSION);
        }
        f.setSecurityRef(securityRef);
        this.store(f, transaction);
        this.bulkUpdate("set securityRef=" + securityRef + " where securityRef=" + folderId, null);
    }

    @Override
    public long countDocsInTree(long rootId) {
        try {
            Folder root = this.findFolder(rootId);
            String rootPath = root.getPath();
            if (SLASH.equals(rootPath)) {
                rootPath = "";
            }
            String query = "SELECT COUNT(*) from ld_document D, ld_folder F WHERE D.ld_folderid=F.ld_id and F.ld_deleted=0 and D.ld_deleted=0 and D.ld_tenantid = " + root.getTenantId() + " and (D.ld_folderid=" + rootId + " or F.ld_path like '" + SqlUtil.doubleQuotes(rootPath) + "/%')";
            return this.queryForLong(query);
        }
        catch (PersistenceException e) {
            this.log.error(e.getMessage(), e);
            return 0L;
        }
    }

    @Override
    public long countDocs(long folderId) {
        try {
            Folder folder = this.findFolder(folderId);
            return this.queryForLong("SELECT COUNT(*) from ld_document WHERE ld_deleted=0 and ld_folderid=" + folder.getId());
        }
        catch (PersistenceException e) {
            this.log.error(e.getMessage(), e);
            return 0L;
        }
    }

    @Override
    public long computeTreeSize(long rootId) {
        try {
            Folder root = this.findFolder(rootId);
            String rootPath = root.getPath();
            if (SLASH.equals(rootPath)) {
                rootPath = "";
            }
            long sizeDocs = this.queryForLong("select sum(ld_filesize) from ld_document WHERE ld_deleted=0 and ld_tenantid = " + root.getTenantId() + " and ld_folderid in (SELECT ld_id FROM ld_folder WHERE ld_deleted=0 and (ld_path LIKE'" + SqlUtil.doubleQuotes(rootPath) + "/%' or ld_id=" + rootId + ")) and ld_tenantid=" + root.getTenantId());
            long sizeVersions = this.queryForLong("select sum(V.ld_filesize) as total from ld_version V where V.ld_version = V.ld_fileversion  and V.ld_tenantid = " + root.getTenantId() + " and V.ld_folderid in (SELECT ld_id FROM ld_folder WHERE ld_deleted=0 and ld_tenantid=" + root.getTenantId() + " and (ld_path LIKE'" + SqlUtil.doubleQuotes(rootPath) + "/%' or ld_id=" + rootId + ")) and not exists (select D.ld_id from ld_document D where D.ld_id=V.ld_documentid and D.ld_fileversion=V.ld_fileversion)");
            return sizeDocs + sizeVersions;
        }
        catch (PersistenceException e) {
            this.log.error(e.getMessage(), e);
            return 0L;
        }
    }

    @Override
    public List<Folder> findAliases(Long foldRef, long tenantId) {
        String query = " _entity.tenantId=" + tenantId;
        if (foldRef != null) {
            query = query + " and _entity.foldRef=" + String.valueOf(foldRef);
        }
        try {
            return this.findByWhere(query, null, null);
        }
        catch (PersistenceException e) {
            this.log.error(e.getMessage(), e);
            return new ArrayList<Folder>();
        }
    }

    @Override
    public Folder findFolder(long folderId) throws PersistenceException {
        Folder f = (Folder)this.findById(folderId);
        if (f != null && f.getFoldRef() != null) {
            f = (Folder)this.findById(f.getFoldRef());
        }
        return f;
    }

    private Folder findFolder(Folder folder) throws PersistenceException {
        if (folder.getFoldRef() != null) {
            return (Folder)this.findById(folder.getFoldRef());
        }
        return folder;
    }

    @Override
    public void applyMetadataToTree(long id, FolderHistory transaction) throws PersistenceException {
        if (!this.checkStoringAspect()) {
            return;
        }
        Folder parent = this.getExistingFolder(id);
        this.initialize(parent);
        transaction.setEvent(FolderEvent.CHANGED);
        transaction.setTenantId(parent.getTenantId());
        transaction.setNotifyEvent(false);
        List<Folder> children = this.findChildren(id, null);
        for (Folder folder : children) {
            this.initialize(folder);
            FolderHistory tr = new FolderHistory(transaction);
            tr.setFolderId(folder.getId());
            folder.setTemplate(parent.getTemplate());
            folder.setTemplateLocked(parent.getTemplateLocked());
            for (String name : parent.getAttributeNames()) {
                Attribute ext = new Attribute(parent.getAttributes().get(name));
                folder.getAttributes().put(name, ext);
            }
            this.store(folder, tr);
            this.flush();
            this.applyMetadataToTree(folder.getId(), transaction);
        }
    }

    private Folder getExistingFolder(long id) throws PersistenceException {
        Folder folder = (Folder)this.findById(id);
        if (folder == null) {
            throw new PersistenceException("Unexisting folder " + id);
        }
        return folder;
    }

    @Override
    public void applyTagsToTree(long id, FolderHistory transaction) throws PersistenceException {
        Folder parent = this.getExistingFolder(id);
        this.initialize(parent);
        transaction.setEvent(FolderEvent.CHANGED);
        transaction.setTenantId(parent.getTenantId());
        transaction.setNotifyEvent(false);
        List<Folder> children = this.findChildren(id, null);
        for (Folder folder : children) {
            this.initialize(folder);
            FolderHistory tr = new FolderHistory(transaction);
            tr.setFolderId(folder.getId());
            if (folder.getTags() != null) {
                folder.getTags().clear();
            }
            if (parent.getTags() != null) {
                for (Tag tag : parent.getTags()) {
                    folder.addTag(tag.getTag());
                }
            }
            this.store(folder, tr);
            this.flush();
            this.applyTagsToTree(folder.getId(), transaction);
        }
    }

    @Override
    public void applyGridToTree(long id, FolderHistory transaction) throws PersistenceException {
        Folder parent = this.getExistingFolder(id);
        transaction.setEvent(FolderEvent.CHANGED);
        transaction.setTenantId(parent.getTenantId());
        transaction.setNotifyEvent(false);
        List<Folder> children = this.findChildren(id, null);
        for (Folder folder : children) {
            this.initialize(folder);
            folder.setGrid(parent.getGrid());
            FolderHistory tr = new FolderHistory(transaction);
            tr.setFolderId(folder.getId());
            this.store(folder, tr);
            this.flush();
            this.applyGridToTree(folder.getId(), transaction);
        }
    }

    @Override
    public void applyStoreToTree(long id, FolderHistory transaction) throws PersistenceException {
        Folder parent = this.getExistingFolder(id);
        this.initialize(parent);
        transaction.setEvent(FolderEvent.CHANGED);
        transaction.setTenantId(parent.getTenantId());
        transaction.setNotifyEvent(false);
        List<Folder> children = this.findByParentId(id);
        for (Folder folder : children) {
            this.initialize(folder);
            folder.setStore(parent.getStore());
            FolderHistory tr = new FolderHistory(transaction);
            tr.setFolderId(folder.getId());
            this.store(folder, tr);
            this.flush();
            this.applyStoreToTree(folder.getId(), transaction);
        }
    }

    @Override
    public void applyOCRToTree(long id, FolderHistory transaction) throws PersistenceException {
        Folder parent = this.getExistingFolder(id);
        transaction.setEvent(FolderEvent.CHANGED);
        transaction.setTenantId(parent.getTenantId());
        transaction.setNotifyEvent(false);
        List<Folder> children = this.findByParentId(id);
        for (Folder folder : children) {
            this.initialize(folder);
            folder.setOcrTemplateId(parent.getOcrTemplateId());
            folder.setBarcodeTemplateId(parent.getBarcodeTemplateId());
            FolderHistory tr = new FolderHistory(transaction);
            tr.setFolderId(folder.getId());
            this.store(folder, tr);
            this.flush();
            this.applyOCRToTree(folder.getId(), transaction);
        }
    }

    public List<Long> findFolderIdByTag(String tag) {
        StringBuilder query = new StringBuilder("select distinct(A.ld_folderid) from ld_foldertag A, ld_folder B where A.ld_folderid=B.ld_id and B.ld_deleted= 0");
        query.append(" and lower(ld_tag)='" + SqlUtil.doubleQuotes(tag).toLowerCase() + "'");
        try {
            return this.queryForList(query.toString(), Long.class);
        }
        catch (PersistenceException e) {
            this.log.error(e.getMessage(), e);
            return new ArrayList<Long>();
        }
    }

    private List<Long> findFolderIdByUserIdAndTag(long userId, String tag) throws PersistenceException {
        ArrayList<Long> ids = new ArrayList();
        User user = this.getExistingtUser(userId);
        StringBuilder query = new StringBuilder();
        if (user.isMemberOf("admin")) {
            ids = this.findFolderIdByTag(tag);
        } else {
            Collection<Long> accessibleIds = this.findFolderIdByUserId(userId, null, true);
            query.append("select distinct(C.ld_id) from ld_folder C, ld_foldertag D  where C.ld_id=D.ld_folderid AND C.ld_deleted=0 ");
            if (this.isOracle()) {
                query.append(" and (C.ld_id,0) in ( ");
                query.append(accessibleIds.stream().map(id -> "(" + String.valueOf(id) + ",0)").collect(Collectors.joining(",")));
                query.append(") ");
            } else {
                query.append(" and C.ld_id in (");
                query.append(accessibleIds.stream().map(id -> Long.toString(id)).collect(Collectors.joining(",")));
                query.append(") ");
            }
            query.append(" AND D.ld_tag = '" + SqlUtil.doubleQuotes(tag) + "' ");
            List<Long> folderIds = this.queryForList(query.toString(), Long.class);
            ids.addAll(folderIds);
        }
        return ids;
    }

    @Override
    public List<Folder> findByUserIdAndTag(long userId, String tag, Integer max) throws PersistenceException {
        List<Folder> coll = new ArrayList<Folder>();
        List<Long> ids = this.findFolderIdByUserIdAndTag(userId, tag);
        if (ids.isEmpty()) {
            return coll;
        }
        StringBuilder query = new StringBuilder("select A from Folder A where A.id in (");
        query.append(ids.stream().map(id -> Long.toString(id)).collect(Collectors.joining(",")));
        query.append(")");
        try {
            coll = this.findByObjectQuery(query.toString(), null, max);
        }
        catch (PersistenceException e) {
            this.log.error(e.getMessage(), e);
        }
        return coll;
    }

    @Override
    public List<String> findTags(long folderId) {
        try {
            return this.queryForList("select ld_tag from ld_foldertag where ld_folderid=" + folderId + " order by ld_tag", String.class);
        }
        catch (PersistenceException e) {
            this.log.error(e.getMessage(), e);
            return new ArrayList<String>();
        }
    }

    @Override
    public void merge(Folder source, Folder target, FolderHistory transaction) throws PersistenceException {
        if (!this.checkStoringAspect()) {
            return;
        }
        if (source == null) {
            throw new PersistenceException("Source folder not specified");
        }
        if (target == null) {
            throw new PersistenceException("Target folder not specified");
        }
        this.validateTransactionAndUser(transaction);
        this.log.debug("merge folder {} into folder {}", (Object)target, (Object)source);
        this.checkOutsideParentTree(source, target);
        Session session = this.getSession(transaction);
        this.moveDocumentsOnMerge(source, target, transaction, session);
        this.log.debug("move non-clashing folders fom folder {} to folder {}", (Object)source, (Object)target);
        List<Folder> foldersInSource = this.findByParentId(source.getId());
        for (Folder folder : foldersInSource) {
            if (!this.findByNameAndParentId(folder.getName(), target.getId()).isEmpty()) continue;
            this.move(folder, target, new FolderHistory(transaction));
        }
        foldersInSource = this.findByParentId(source.getId());
        for (Folder fldSource : foldersInSource) {
            List<Folder> foldersInTarget = this.findByNameAndParentId(fldSource.getName(), target.getId());
            if (foldersInTarget.isEmpty()) continue;
            this.merge(fldSource, foldersInTarget.get(0), new FolderHistory(transaction));
        }
        this.deleteEmptySourceFolders(source, transaction);
    }

    private void deleteEmptySourceFolders(Folder source, FolderHistory transaction) throws PersistenceException {
        this.log.debug("delete the empty source folder {}", (Object)source);
        DocumentDAO docDao = Context.get(DocumentDAO.class);
        if (docDao.findByFolder(source.getId(), null).isEmpty() && this.findByParentId(source.getId()).isEmpty()) {
            this.delete(source.getId(), new FolderHistory(transaction));
        }
    }

    private void checkOutsideParentTree(Folder source, Folder target) throws PersistenceException {
        Collection treeIds = this.findFolderIdInTree(target.getId(), true);
        if (treeIds.contains(source.getId())) {
            throw new PersistenceException("You cannot merge a folder inside a parent");
        }
    }

    private Session getSession(FolderHistory transaction) {
        Session session = null;
        if (transaction.getSessionId() != null) {
            session = SessionManager.get().get(transaction.getSessionId());
        }
        return session;
    }

    private void moveDocumentsOnMerge(Folder source, Folder target, FolderHistory transaction, Session session) throws PersistenceException {
        this.log.debug("move documents fom folder {} to folder {}", (Object)source, (Object)target);
        DocumentManager manager = Context.get(DocumentManager.class);
        DocumentDAO docDao = Context.get(DocumentDAO.class);
        List<Document> docs = docDao.findByFolder(source.getId(), null);
        for (Document document : docs) {
            DocumentHistory hist = new DocumentHistory();
            hist.setDocument(document);
            hist.setSessionId(transaction.getSessionId());
            if (session != null) {
                hist.setSession(session);
            }
            hist.setUser(transaction.getUser());
            manager.moveToFolder(document, target, hist);
        }
    }
}

