/*
 * Decompiled with CFR 0.152.
 */
package com.logicaldoc.core.folder;

import com.logicaldoc.core.PersistenceException;
import com.logicaldoc.core.automation.AutomationException;
import com.logicaldoc.core.folder.Folder;
import com.logicaldoc.core.folder.FolderEvent;
import com.logicaldoc.core.folder.FolderHistory;
import com.logicaldoc.core.folder.FolderListener;
import com.logicaldoc.core.metadata.validation.Validator;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FolderValidator
extends Validator
implements FolderListener {
    private static final String VALIDATED_FLAG = "validated";
    private static final Logger log = LoggerFactory.getLogger(FolderValidator.class);

    @Override
    public void beforeStore(Folder folder, FolderHistory transaction, Map<String, Object> dictionary) throws PersistenceException {
        try {
            if ("true".equals(dictionary.get(VALIDATED_FLAG)) || "true".equals(System.getProperty("ld.bulkloadextreme"))) {
                return;
            }
            if (transaction == null || !FolderEvent.CHANGED.toString().equals(transaction.getEvent()) && !FolderEvent.CREATED.toString().equals(transaction.getEvent())) {
                return;
            }
            try {
                this.validate(folder, folder.getTemplate(), transaction);
            }
            catch (AutomationException e) {
                log.warn(e.getMessage(), e);
                dictionary.put(VALIDATED_FLAG, "false");
            }
        }
        finally {
            dictionary.put(VALIDATED_FLAG, "true");
        }
    }

    @Override
    public void afterStore(Folder folder, FolderHistory transaction, Map<String, Object> dictionary) throws PersistenceException {
    }
}

