/*
 * Decompiled with CFR 0.152.
 */
package com.logicaldoc.core.folder;

import com.logicaldoc.core.folder.Folder;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;

public abstract class FolderComparator
implements Comparator<Folder> {
    private static final FolderComparator ID_SORT = new FolderComparator(){

        @Override
        public int compare(Folder f1, Folder f2) {
            return Long.compare(f1.getId(), f2.getId());
        }
    };
    private static final FolderComparator NAME_SORT_CS = new FolderComparator(){

        @Override
        public int compare(Folder f1, Folder f2) {
            return f1.getName().compareTo(f2.getName());
        }
    };
    private static final FolderComparator NAME_SORT_CI = new FolderComparator(){

        @Override
        public int compare(Folder f1, Folder f2) {
            return f1.getName().toLowerCase().compareTo(f2.getName().toLowerCase());
        }
    };
    private static final FolderComparator LASTMODIFIED_SORT = new FolderComparator(){

        @Override
        public int compare(Folder f1, Folder f2) {
            return f1.getLastModified().compareTo(f2.getLastModified());
        }
    };
    private static final FolderComparator CREATED_SORT = new FolderComparator(){

        @Override
        public int compare(Folder f1, Folder f2) {
            return f1.getCreation().compareTo(f2.getCreation());
        }
    };
    private static final FolderComparator TEMPLATE_NAME_SORT_CS = new FolderComparator(){

        @Override
        public int compare(Folder f1, Folder f2) {
            if (f1.getTemplate() != null && f2.getTemplate() != null) {
                return f1.getTemplate().getName().compareTo(f2.getTemplate().getName());
            }
            return f1.getTemplateName().compareTo(f2.getTemplateName());
        }
    };
    private static final FolderComparator TEMPLATE_NAME_SORT_CI = new FolderComparator(){

        @Override
        public int compare(Folder f1, Folder f2) {
            if (f1.getTemplate() != null && f2.getTemplate() != null) {
                return f1.getTemplate().getName().compareTo(f2.getTemplate().getName());
            }
            return f1.getTemplateName().toLowerCase().compareTo(f2.getTemplateName().toLowerCase());
        }
    };
    private static final Map<String, FolderComparator> legacyComparators = new HashMap<String, FolderComparator>();

    static {
        legacyComparators.put("name-CS", NAME_SORT_CS);
        legacyComparators.put("name-CI", NAME_SORT_CI);
        legacyComparators.put("id-CS", ID_SORT);
        legacyComparators.put("id-CI", ID_SORT);
        legacyComparators.put("lastModified-CS", LASTMODIFIED_SORT);
        legacyComparators.put("lastModified-CI", LASTMODIFIED_SORT);
        legacyComparators.put("creation-CS", CREATED_SORT);
        legacyComparators.put("creation-CI", CREATED_SORT);
        legacyComparators.put("template-CS", TEMPLATE_NAME_SORT_CS);
        legacyComparators.put("template-CI", TEMPLATE_NAME_SORT_CI);
    }

    private FolderComparator() {
    }

    private static final FolderComparator descending(final Comparator<Folder> other) {
        return new FolderComparator(){

            @Override
            public int compare(Folder f1, Folder f2) {
                return -1 * other.compare(f1, f2);
            }
        };
    }

    private static final FolderComparator newComparatorForExtendedAttribute(final String attribute, final boolean caseSensitive) {
        return new FolderComparator(){

            @Override
            public int compare(Folder f1, Folder f2) {
                Comparable val1 = (Comparable)f1.getValue(attribute);
                Comparable val2 = (Comparable)f2.getValue(attribute);
                if (val1 == null && val2 == null) {
                    return 0;
                }
                if (val1 == null) {
                    return -1;
                }
                if (val2 == null) {
                    return 1;
                }
                if (val1 instanceof String && !caseSensitive) {
                    return val1.toString().toLowerCase().compareTo(val2.toString().toLowerCase());
                }
                return val1.compareTo(val2);
            }
        };
    }

    public static Comparator<Folder> getComparator(String sort) {
        StringTokenizer st = new StringTokenizer(sort, ",", false);
        ArrayList<Comparator<Folder>> comparators = new ArrayList<Comparator<Folder>>();
        while (st.hasMoreTokens()) {
            String token = st.nextToken().trim();
            String field = token.substring(0, token.indexOf(32));
            boolean asc = "asc".equals(token.substring(token.indexOf(32) + 1));
            boolean caseSensitive = true;
            if (field.startsWith("lower(") || field.startsWith("upper(")) {
                caseSensitive = false;
                field = field.substring(field.indexOf(40) + 1, field.lastIndexOf(41));
            }
            FolderComparator comp = null;
            comp = field.startsWith("ext_") ? FolderComparator.newComparatorForExtendedAttribute(field.substring(field.indexOf(95) + 1), caseSensitive) : legacyComparators.get(field + "-" + (caseSensitive ? "CS" : "CI"));
            if (comp != null && asc) {
                comparators.add(comp);
                continue;
            }
            if (comp == null || asc) continue;
            comparators.add(FolderComparator.descending(comp));
        }
        return FolderComparator.getComparator(comparators);
    }

    private static Comparator<Folder> getComparator(List<Comparator<Folder>> multipleOptions) {
        return (f1, f2) -> {
            for (Comparator option : multipleOptions) {
                int result = option.compare(f1, f2);
                if (result == 0) continue;
                return result;
            }
            return 0;
        };
    }
}

