/*
 * Decompiled with CFR 0.152.
 */
package com.logicaldoc.core.folder;

import com.logicaldoc.core.document.FolderAccessControlEntry;
import com.logicaldoc.core.document.Tag;
import com.logicaldoc.core.metadata.Attribute;
import com.logicaldoc.core.metadata.ExtensibleObject;
import com.logicaldoc.core.metadata.Template;
import com.logicaldoc.core.security.AccessControlEntry;
import com.logicaldoc.core.security.Secure;
import com.logicaldoc.util.spring.Context;
import jakarta.persistence.Cacheable;
import jakarta.persistence.CascadeType;
import jakarta.persistence.CollectionTable;
import jakarta.persistence.Column;
import jakarta.persistence.ElementCollection;
import jakarta.persistence.Entity;
import jakarta.persistence.FetchType;
import jakarta.persistence.JoinColumn;
import jakarta.persistence.ManyToOne;
import jakarta.persistence.MapKeyColumn;
import jakarta.persistence.OrderBy;
import jakarta.persistence.Table;
import jakarta.persistence.Transient;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;
import org.apache.commons.lang.StringUtils;
import org.hibernate.LazyInitializationException;

@Entity
@Table(name="ld_folder")
@Cacheable
public class Folder
extends ExtensibleObject
implements Secure<FolderAccessControlEntry>,
Comparable<Folder> {
    private static final long serialVersionUID = 1L;
    public static final long ROOTID = 5L;
    public static final long DEFAULTWORKSPACEID = 4L;
    public static final String DEFAULTWORKSPACENAME = "Default";
    public static final int TYPE_DEFAULT = 0;
    public static final int TYPE_WORKSPACE = 1;
    public static final int TYPE_ALIAS = 2;
    @Column(name="ld_name", length=255)
    private String name = "";
    @Column(name="ld_position", nullable=false)
    private int position = 1;
    @Column(name="ld_parentid", nullable=false)
    private long parentId = 4L;
    @Column(name="ld_foldref")
    private Long foldRef;
    @Column(name="ld_securityref")
    private Long securityRef;
    @Column(name="ld_description", length=4000)
    private String description = "";
    @Column(name="ld_type", nullable=false)
    private int type = 0;
    @Column(name="ld_creator", length=255)
    private String creator;
    @Column(name="ld_creatorid")
    private Long creatorId;
    @Column(name="ld_templocked", nullable=false)
    private int templateLocked = 0;
    @Column(name="ld_deleteuserid")
    private Long deleteUserId;
    @Column(name="ld_deleteuser", length=255)
    private String deleteUser;
    @Column(name="ld_hidden", nullable=false)
    private int hidden = 0;
    @Column(name="ld_quotadocs")
    private Long quotaDocs = null;
    @Column(name="ld_quotasize")
    private Long quotaSize = null;
    @Column(name="ld_qthreshold")
    private Integer quotaThreshold = null;
    @Column(name="ld_qrecipients", length=1000)
    private String quotaAlertRecipients = null;
    @Column(name="ld_maxversions")
    private Integer maxVersions;
    @Column(name="ld_color", length=255)
    private String color;
    @Column(name="ld_path")
    private String path;
    @Column(name="ld_grid")
    private String grid;
    @Column(name="ld_ocrtemplateid")
    private Long ocrTemplateId = null;
    @Column(name="ld_barcodetemplateid")
    private Long barcodeTemplateId = null;
    @Column(name="ld_tile")
    private String tile;
    @Column(name="ld_tgs", length=1000)
    private String tgs;
    @ElementCollection
    @CollectionTable(name="ld_folder_store", joinColumns={@JoinColumn(name="ld_folderid")})
    @MapKeyColumn(name="ld_nodeid")
    @Column(name="ld_storeid")
    private Map<String, Integer> stores = new HashMap<String, Integer>();
    @ElementCollection
    @CollectionTable(name="ld_foldertag", joinColumns={@JoinColumn(name="ld_folderid")})
    @OrderBy(value="ld_tag")
    private Set<Tag> tags = new HashSet<Tag>();
    @Transient
    private String pathExtended;
    @ElementCollection(fetch=FetchType.LAZY)
    @CollectionTable(name="ld_folder_acl", joinColumns={@JoinColumn(name="ld_folderid")})
    private Set<FolderAccessControlEntry> accessControlList = new HashSet<FolderAccessControlEntry>();
    @ElementCollection(fetch=FetchType.LAZY)
    @CollectionTable(name="ld_folder_ext", joinColumns={@JoinColumn(name="ld_folderid")})
    @MapKeyColumn(name="ld_name")
    @OrderBy(value="ld_position ASC, ld_name ASC")
    private Map<String, Attribute> attributes = new HashMap<String, Attribute>();
    @ManyToOne(cascade={CascadeType.DETACH})
    @JoinColumn(name="ld_templateid")
    private Template template;

    public Folder() {
    }

    public Folder(Folder source) {
        this.setId(source.getId());
        this.name = source.name;
        this.parentId = source.parentId;
        this.securityRef = source.securityRef;
        this.description = source.description;
        this.type = source.type;
        this.setCreation(source.getCreation());
        this.creator = source.creator;
        this.creatorId = source.creatorId;
        this.position = source.position;
        this.hidden = source.hidden;
        this.templateLocked = source.templateLocked;
        this.deleteUserId = source.deleteUserId;
        this.deleteUser = source.deleteUser;
        this.quotaDocs = source.quotaDocs;
        this.quotaSize = source.quotaSize;
        this.quotaThreshold = source.quotaThreshold;
        this.quotaAlertRecipients = source.quotaAlertRecipients;
        this.foldRef = source.foldRef;
        this.stores = source.stores;
        this.maxVersions = source.maxVersions;
        this.color = source.color;
        this.tags = source.tags;
        this.tgs = source.tgs;
        this.path = source.path;
        this.pathExtended = source.pathExtended;
        this.grid = source.grid;
        this.ocrTemplateId = source.ocrTemplateId;
        this.barcodeTemplateId = source.barcodeTemplateId;
        this.tile = source.tile;
        this.setTemplate(source.getTemplate());
        this.setTemplateId(source.getTemplateId());
        this.setTemplateName(source.getTemplateName());
        this.setTenantId(source.getTenantId());
        try {
            if (source instanceof Folder) {
                Folder folder = source;
                for (FolderAccessControlEntry ace : folder.getAccessControlList()) {
                    this.getAccessControlList().add(new FolderAccessControlEntry(ace));
                }
            }
        }
        catch (LazyInitializationException folder) {
            // empty catch block
        }
        this.setAttributes(new HashMap<String, Attribute>());
        try {
            for (String attName : source.getAttributes().keySet()) {
                this.getAttributes().put(attName, source.getAttributes().get(attName));
            }
        }
        catch (LazyInitializationException attName) {
            // empty catch block
        }
        try {
            this.setTags(new HashSet<Tag>());
            for (Tag tag : source.getTags()) {
                this.getTags().add(tag);
            }
        }
        catch (LazyInitializationException tag) {
            // empty catch block
        }
        this.setStores(new HashMap<String, Integer>());
        try {
            for (String nodeId : source.getStores().keySet()) {
                this.getStores().put(nodeId, source.getStores().get(nodeId));
            }
        }
        catch (LazyInitializationException lazyInitializationException) {
            // empty catch block
        }
    }

    @Override
    public Set<FolderAccessControlEntry> getAccessControlList() {
        return this.accessControlList;
    }

    @Override
    public void setAccessControlList(Set<FolderAccessControlEntry> accessControlList) {
        this.accessControlList = accessControlList;
    }

    public boolean isWorkspace() {
        return this.type == 1;
    }

    public boolean isAlias() {
        return this.type == 2;
    }

    public long getParentId() {
        return this.parentId;
    }

    public void setParentId(long parentId) {
        this.parentId = parentId;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public Long getSecurityRef() {
        return this.securityRef;
    }

    public void setSecurityRef(Long securityRef) {
        this.securityRef = securityRef;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public int getType() {
        return this.type;
    }

    public void setType(int type) {
        this.type = type;
    }

    public String getCreator() {
        return this.creator;
    }

    public void setCreator(String creator) {
        this.creator = creator;
    }

    public Long getCreatorId() {
        return this.creatorId;
    }

    public void setCreatorId(Long creatorId) {
        this.creatorId = creatorId;
    }

    public int getTemplateLocked() {
        return this.templateLocked;
    }

    public void setTemplateLocked(int templateLocked) {
        this.templateLocked = templateLocked;
    }

    public Long getDeleteUserId() {
        return this.deleteUserId;
    }

    public void setDeleteUserId(Long deleteUserId) {
        this.deleteUserId = deleteUserId;
    }

    public int getPosition() {
        return this.position;
    }

    public void setPosition(int position) {
        this.position = position;
    }

    public int getHidden() {
        return this.hidden;
    }

    public void setHidden(int hidden) {
        this.hidden = hidden;
    }

    public Long getQuotaDocs() {
        return this.quotaDocs;
    }

    public void setQuotaDocs(Long quotaDocs) {
        this.quotaDocs = quotaDocs;
    }

    public Long getQuotaSize() {
        return this.quotaSize;
    }

    public void setQuotaSize(Long quotaSize) {
        this.quotaSize = quotaSize;
    }

    public Long getFoldRef() {
        return this.foldRef;
    }

    public void setFoldRef(Long foldRef) {
        this.foldRef = foldRef;
    }

    public Integer getStore() {
        try {
            return this.stores.get(Context.get().getProperties().get("id"));
        }
        catch (Exception t) {
            return null;
        }
    }

    public void setStore(Integer store) {
        try {
            String nodeId = Context.get().getProperties().getProperty("id");
            if (store == null) {
                this.stores.remove(nodeId);
            } else {
                this.stores.put(nodeId, store);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public Integer getMaxVersions() {
        return this.maxVersions;
    }

    public void setMaxVersions(Integer maxVersions) {
        this.maxVersions = maxVersions;
    }

    public String getColor() {
        return this.color;
    }

    public void setColor(String color) {
        this.color = color;
    }

    public Set<Tag> getTags() {
        return this.tags;
    }

    public void setTags(Set<Tag> tags) {
        this.tags = tags;
    }

    public String getTgs() {
        return this.tgs;
    }

    public void setTgs(String tgs) {
        this.tgs = tgs;
    }

    public void addTag(String word) {
        Tag tg = new Tag();
        tg.setTenantId(this.getTenantId());
        tg.setTag(word);
        this.tags.add(tg);
    }

    public void clearTags() {
        this.tags.clear();
        this.tags = new HashSet<Tag>();
        this.tgs = null;
    }

    public void setTagsFromWords(Set<String> tgs) {
        if (this.tags != null) {
            this.tags.clear();
        } else {
            this.tags = new HashSet<Tag>();
        }
        if (tgs != null) {
            for (String word : tgs) {
                Tag tag = new Tag(this.getTenantId(), word);
                this.tags.add(tag);
            }
        }
    }

    public Set<String> getTagsAsWords() {
        HashSet<String> words = new HashSet<String>();
        if (this.tags != null) {
            for (Tag tag : this.tags) {
                words.add(tag.getTag());
            }
        }
        return words;
    }

    public String getGrid() {
        return this.grid;
    }

    public void setGrid(String grid) {
        this.grid = grid;
    }

    public String getTagsString() {
        StringBuilder sb = new StringBuilder(",");
        if (this.tags == null) {
            return "";
        }
        Iterator<Tag> iter = this.tags.iterator();
        boolean start = true;
        while (iter.hasNext()) {
            String words = iter.next().toString();
            if (!start) {
                sb.append(",");
            } else {
                start = false;
            }
            sb.append(words);
        }
        sb.append(",");
        return sb.toString();
    }

    public Integer getQuotaThreshold() {
        return this.quotaThreshold;
    }

    public void setQuotaThreshold(Integer quotaThreshold) {
        this.quotaThreshold = quotaThreshold;
    }

    public String getQuotaAlertRecipients() {
        return this.quotaAlertRecipients;
    }

    public void setQuotaAlertRecipients(String quotaAlertRecipients) {
        this.quotaAlertRecipients = quotaAlertRecipients;
    }

    public List<String> getQuotaAlertRecipientsAsList() {
        ArrayList<String> list = new ArrayList<String>();
        if (!StringUtils.isEmpty(this.getQuotaAlertRecipients())) {
            StringTokenizer st = new StringTokenizer(this.getQuotaAlertRecipients(), ",", false);
            while (st.hasMoreTokens()) {
                list.add(st.nextToken().trim());
            }
        }
        return list;
    }

    public void addQuotaAlertRecipient(String recipient) {
        if (StringUtils.isEmpty(recipient)) {
            return;
        }
        Object str = this.getQuotaAlertRecipients();
        str = StringUtils.isEmpty((String)str) ? recipient : (String)str + "," + recipient;
        this.setQuotaAlertRecipients((String)str);
    }

    public void setPath(String path) {
        this.path = path;
    }

    public String getPath() {
        return this.path;
    }

    public Folder(String name) {
        this.name = name;
    }

    public String getDeleteUser() {
        return this.deleteUser;
    }

    public void setDeleteUser(String deleteUser) {
        this.deleteUser = deleteUser;
    }

    public String getPathExtended() {
        return this.pathExtended;
    }

    public void setPathExtended(String pathExtended) {
        this.pathExtended = pathExtended;
    }

    public Long getOcrTemplateId() {
        return this.ocrTemplateId;
    }

    public void setOcrTemplateId(Long ocrTemplateId) {
        this.ocrTemplateId = ocrTemplateId;
    }

    public Long getBarcodeTemplateId() {
        return this.barcodeTemplateId;
    }

    public void setBarcodeTemplateId(Long barcodeTemplateId) {
        this.barcodeTemplateId = barcodeTemplateId;
    }

    @Override
    public String toString() {
        return this.getName() + "(" + this.getId() + ")";
    }

    public Map<String, Integer> getStores() {
        return this.stores;
    }

    public void setStores(Map<String, Integer> stores) {
        this.stores = stores;
    }

    public String getTile() {
        return this.tile;
    }

    public void setTile(String tile) {
        this.tile = tile;
    }

    @Override
    public Map<String, Attribute> getAttributes() {
        return this.attributes;
    }

    @Override
    public void setAttributes(Map<String, Attribute> attributes) {
        this.attributes = attributes;
    }

    @Override
    public Long getTemplateId() {
        return this.getTemplate() != null ? Long.valueOf(this.getTemplate().getId()) : null;
    }

    @Override
    public void setTemplateId(Long templateId) {
    }

    @Override
    public String getTemplateName() {
        return this.getTemplate() != null ? this.getTemplate().getName() : null;
    }

    @Override
    public void setTemplateName(String templateName) {
    }

    @Override
    public Template getTemplate() {
        return this.template;
    }

    @Override
    public void setTemplate(Template template) {
        this.template = template;
    }

    @Override
    public AccessControlEntry getAccessControlEntry(long groupId) {
        return this.getAccessControlList().stream().filter(ace -> ace.getGroupId() == groupId).findFirst().orElse(null);
    }

    @Override
    public void addAccessControlEntry(FolderAccessControlEntry ace) {
        if (!this.getAccessControlList().add(ace)) {
            this.getAccessControlList().remove(ace);
            this.getAccessControlList().add(ace);
        }
    }

    @Override
    public int compareTo(Folder other) {
        if (this.equals(other)) {
            return 0;
        }
        int comparison = Integer.compare(this.position, other.position);
        if (comparison != 0) {
            return comparison;
        }
        return this.name.compareTo(other.name);
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = super.hashCode();
        result = 31 * result + (this.name == null ? 0 : this.name.hashCode());
        result = 31 * result + (int)(this.parentId ^ this.parentId >>> 32);
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Folder other = (Folder)obj;
        if (this.name == null ? other.name != null : !this.name.equals(other.name)) {
            return false;
        }
        return this.parentId == other.parentId;
    }
}

