/*
 * Decompiled with CFR 0.152.
 */
package com.logicaldoc.core.document.thumbnail;

import com.logicaldoc.core.document.Document;
import com.logicaldoc.core.document.thumbnail.AbstractThumbnailBuilder;
import com.logicaldoc.core.document.thumbnail.ImageThumbnailBuilder;
import com.logicaldoc.util.io.FileUtil;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.IOException;
import javax.imageio.ImageIO;
import org.apache.commons.io.FileUtils;
import org.bytedeco.javacv.FFmpegFrameGrabber;
import org.bytedeco.javacv.Frame;
import org.bytedeco.javacv.FrameGrabber;
import org.bytedeco.javacv.Java2DFrameUtils;
import org.bytedeco.javacv.OpenCVFrameGrabber;

public class VideoThumbnailBuilder
extends AbstractThumbnailBuilder {
    @Override
    public synchronized void buildThumbnail(String sid, Document document, String fileVersion, File src, File dest, int size, int quality) throws IOException {
        File frameImage = FileUtil.createTempFile("album-", ".png");
        try {
            try {
                if (document.getFileName().toLowerCase().endsWith(".mp4")) {
                    this.writeMp4Frame(src, frameImage);
                } else {
                    this.writeVideoFrame(src, frameImage);
                }
                ImageThumbnailBuilder imageTBuilder = new ImageThumbnailBuilder();
                imageTBuilder.buildThumbnail(sid, document, fileVersion, frameImage, dest, size, quality);
            }
            catch (FrameGrabber.Exception e) {
                throw new IOException("Error in extracting video frame", e);
            }
        }
        finally {
            FileUtils.deleteQuietly(frameImage);
        }
    }

    private void writeMp4Frame(File videoFile, File frameFile) throws FrameGrabber.Exception {
        Throwable throwable = null;
        Object var4_5 = null;
        try (FFmpegFrameGrabber grabber = new FFmpegFrameGrabber(videoFile);){
            grabber.start();
            int startFrame = grabber.getLengthInVideoFrames() / 2;
            grabber.setVideoFrameNumber(startFrame);
            int i = startFrame;
            while (i < grabber.getLengthInFrames() && frameFile.length() == 0L) {
                try {
                    BufferedImage img = Java2DFrameUtils.toBufferedImage((Frame)grabber.grab());
                    ImageIO.write((RenderedImage)img, "png", frameFile);
                }
                catch (Exception exception) {
                    // empty catch block
                }
                ++i;
            }
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    private void writeVideoFrame(File videoFile, File frameFile) throws FrameGrabber.Exception {
        Throwable throwable = null;
        Object var4_5 = null;
        try (OpenCVFrameGrabber grabber = new OpenCVFrameGrabber(videoFile);){
            grabber.start();
            double frameRate = grabber.getFrameRate();
            int fiveSecondsFrame = (int)(60.0 * frameRate);
            if (fiveSecondsFrame > grabber.getLengthInFrames()) {
                fiveSecondsFrame = 1;
            }
            int i = 0;
            while (i < grabber.getLengthInFrames() && frameFile.length() == 0L) {
                try {
                    if (i < fiveSecondsFrame) {
                        grabber.grab();
                    } else {
                        BufferedImage img = Java2DFrameUtils.toBufferedImage((Frame)grabber.grab());
                        ImageIO.write((RenderedImage)img, "png", frameFile);
                    }
                }
                catch (IOException iOException) {
                    // empty catch block
                }
                ++i;
            }
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }
}

