/*
 * Decompiled with CFR 0.152.
 */
package com.logicaldoc.core.document.thumbnail;

import com.logicaldoc.core.document.Document;
import com.logicaldoc.core.document.thumbnail.ThumbnailBuilder;
import com.logicaldoc.core.security.TenantDAO;
import com.logicaldoc.core.store.Store;
import com.logicaldoc.core.util.DocUtil;
import com.logicaldoc.util.MimeType;
import com.logicaldoc.util.io.FileUtil;
import com.logicaldoc.util.plugin.PluginRegistry;
import com.logicaldoc.util.spring.Context;
import jakarta.annotation.PostConstruct;
import jakarta.annotation.Resource;
import java.io.File;
import java.io.IOException;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.java.plugin.registry.Extension;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component(value="thumbnailManager")
public class ThumbnailManager {
    public static final String SUFFIX_PREVIEW = "conversion.pdf";
    public static final String SUFFIX_TILE = "tile.png";
    public static final String THUMB = "thumb";
    public static final String SUFFIX_THUMB = "thumb.png";
    public static final String SUFFIX_MOBILE = "mobile.png";
    private static final Logger log = LoggerFactory.getLogger(ThumbnailManager.class);
    @Resource(name="Store")
    private Store store;
    private Map<String, ThumbnailBuilder> builders = new HashMap<String, ThumbnailBuilder>();

    public void createTumbnail(Document document, String fileVersion, String sid) throws IOException {
        this.createImage(document, fileVersion, "thumbnail", SUFFIX_THUMB, sid);
    }

    public void createTumbnail(Document document, String sid) throws IOException {
        this.createTumbnail(document, null, sid);
    }

    public void createTumbnail(Document document, String fileVersion, int size, Integer quality, String sid) throws IOException {
        this.createImage(document, fileVersion, size, quality, SUFFIX_THUMB, sid);
    }

    public void createTile(Document document, String fileVersion, String sid) throws IOException {
        this.createImage(document, fileVersion, "tile", SUFFIX_TILE, sid);
    }

    public void createTile(Document document, String sid) throws IOException {
        this.createTile(document, null, sid);
    }

    public void createMobile(Document document, String fileVersion, String sid) throws IOException {
        this.createImage(document, fileVersion, "mobile", SUFFIX_MOBILE, sid);
    }

    public void createMobile(Document document, String sid) throws IOException {
        this.createImage(document, null, "mobile", SUFFIX_MOBILE, sid);
    }

    protected void createImage(Document document, String fileVersion, int size, Integer quality, String suffix, String sid) throws IOException {
        block6: {
            TenantDAO tDao = Context.get(TenantDAO.class);
            ThumbnailBuilder builder = this.getBuilder(document);
            if (builder == null) {
                log.warn("No builder found for document {}", (Object)document.getId());
                return;
            }
            File src = null;
            File dest = FileUtil.createTempFile("dest", suffix);
            try {
                try {
                    src = this.writeToTempFile(document, fileVersion);
                    builder.buildThumbnail(sid, document, fileVersion, src, dest, size, quality != null ? quality.intValue() : Context.get().getProperties().getInt(tDao.getTenantName(document.getTenantId()) + ".gui.thumbnail.quality", 93));
                    String resource = this.store.getResourceName(document, this.getSuitableFileVersion(document, fileVersion), suffix);
                    this.store.store(dest, document.getId(), resource);
                }
                catch (Exception e) {
                    log.warn("Error rendering image for document: {} - {}", document.getId(), document.getFileName(), e);
                    FileUtil.delete(src);
                    FileUtil.delete(dest);
                    break block6;
                }
            }
            catch (Throwable throwable) {
                FileUtil.delete(src);
                FileUtil.delete(dest);
                throw throwable;
            }
            FileUtil.delete(src);
            FileUtil.delete(dest);
        }
    }

    protected void createImage(Document document, String fileVersion, String type, String suffix, String sid) throws IOException {
        String tenantName = DocUtil.getTenantName(document);
        this.createImage(document, fileVersion, Context.get().getProperties().getInt(tenantName + ".gui." + type + ".size", 200), Context.get().getProperties().getInt(tenantName + ".gui." + type + ".quality", 93), suffix, sid);
    }

    public ThumbnailBuilder getBuilder(String filename) {
        String ext = filename.contains(".") ? FileUtil.getExtension(filename.toLowerCase()) : filename.toLowerCase();
        ThumbnailBuilder builder = this.getBuilders().get(ext);
        if (builder == null) {
            log.warn("No registered thumbnail builder for extension {}", (Object)ext);
            try {
                String mime = MimeType.getByFilename(filename);
                if ("text/plain".equals(mime)) {
                    log.warn("Try to use a txt builder");
                    builder = this.getBuilders().get("txt");
                } else {
                    builder = this.getBuilders().get("*");
                }
            }
            catch (Exception e) {
                log.error(e.getMessage());
            }
        }
        return builder;
    }

    private ThumbnailBuilder getBuilder(Document document) {
        return this.getBuilder(document.getFileExtension().toLowerCase());
    }

    private File writeToTempFile(Document document, String fileVersion) throws IOException {
        File target = FileUtil.createTempFile("scr", "." + FileUtil.getExtension(DocUtil.getFileName(document, fileVersion)));
        String fver = this.getSuitableFileVersion(document, fileVersion);
        String resource = this.store.getResourceName(document, fver, null);
        this.store.writeToFile(document.getId(), resource, target);
        return target;
    }

    private String getSuitableFileVersion(Document document, String fileVersion) {
        String fver = fileVersion;
        if (fver == null) {
            fver = document.getFileVersion();
        }
        return fver;
    }

    @PostConstruct
    public synchronized void init() {
        if (!this.builders.isEmpty()) {
            return;
        }
        PluginRegistry registry = PluginRegistry.getInstance();
        Collection<Extension> exts = registry.getExtensions("logicaldoc-core", "ThumbnailBuilder");
        for (Extension ext : exts) {
            String className = ext.getParameter("class").valueAsString();
            String extension = ext.getParameter("extension").valueAsString().toLowerCase();
            try {
                Class<?> clazz = Class.forName(className);
                Object builder = clazz.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
                if (!(builder instanceof ThumbnailBuilder)) {
                    throw new ClassNotFoundException("The specified builder " + className + " doesn't implement ThumbnailBuilder interface");
                }
                this.builders.put(extension, (ThumbnailBuilder)builder);
                log.info("Added new thumbnail builder {} for extension {}", (Object)className, (Object)extension);
            }
            catch (Exception e) {
                log.error(e.getMessage(), e);
            }
        }
    }

    public Map<String, ThumbnailBuilder> getBuilders() {
        if (this.builders.isEmpty()) {
            this.init();
        }
        return this.builders;
    }

    public void setStore(Store store) {
        this.store = store;
    }
}

