/*
 * Decompiled with CFR 0.152.
 */
package com.logicaldoc.core.document.thumbnail;

import com.logicaldoc.core.document.Document;
import com.logicaldoc.core.document.thumbnail.AbstractThumbnailBuilder;
import com.logicaldoc.core.document.thumbnail.ImageThumbnailBuilder;
import com.logicaldoc.util.io.FileUtil;
import com.mpatric.mp3agic.ID3v2;
import com.mpatric.mp3agic.Mp3File;
import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import org.apache.commons.io.FileUtils;

public class Mp3ThumbnailBuilder
extends AbstractThumbnailBuilder {
    @Override
    public synchronized void buildThumbnail(String sid, Document document, String fileVersion, File src, File dest, int size, int quality) throws IOException {
        block16: {
            try {
                String extension;
                Mp3File mp3file = new Mp3File(src);
                ID3v2 id3v2tag = mp3file.getId3v2Tag();
                if (id3v2tag == null) break block16;
                Object mimeType = id3v2tag.getAlbumImageMimeType();
                byte[] albumData = id3v2tag.getAlbumImage();
                int idx = ((String)mimeType).indexOf(47);
                if (idx > 0) {
                    extension = "." + ((String)mimeType).substring(idx + 1).toLowerCase();
                } else {
                    extension = "." + ((String)mimeType).toLowerCase();
                    mimeType = extension;
                }
                File albumImage = FileUtil.createTempFile("album-", extension);
                try {
                    Throwable throwable = null;
                    Object var16_18 = null;
                    try (RandomAccessFile file = new RandomAccessFile(albumImage, "rw");){
                        file.write(albumData);
                        ImageThumbnailBuilder imageTBuilder = new ImageThumbnailBuilder();
                        imageTBuilder.buildThumbnail(sid, document, fileVersion, albumImage, dest, size, quality);
                    }
                    catch (Throwable throwable2) {
                        if (throwable == null) {
                            throwable = throwable2;
                        } else if (throwable != throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                        throw throwable;
                    }
                }
                finally {
                    FileUtils.deleteQuietly(albumImage);
                }
            }
            catch (Exception e) {
                throw new IOException("Error in extracting album image from the MP3", e);
            }
        }
    }
}

