/*
 * Decompiled with CFR 0.152.
 */
package com.logicaldoc.core.document.thumbnail;

import com.logicaldoc.core.document.Document;
import com.logicaldoc.core.document.thumbnail.AbstractThumbnailBuilder;
import com.logicaldoc.util.config.ContextProperties;
import com.logicaldoc.util.exec.Exec;
import com.logicaldoc.util.io.FileUtil;
import com.logicaldoc.util.spring.Context;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.io.FileUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ImageThumbnailBuilder
extends AbstractThumbnailBuilder {
    private static final Logger log = LoggerFactory.getLogger(ImageThumbnailBuilder.class);

    @Override
    public synchronized void buildThumbnail(String sid, Document document, String fileVersion, File src, File dest, int size, int quality) throws IOException {
        String outExt = FileUtil.getExtension(dest.getName().toLowerCase());
        ContextProperties conf = Context.get().getProperties();
        ArrayList<String> commandLine = new ArrayList<String>();
        commandLine.add(conf.getProperty("converter.ImageConverter.path"));
        if ("png".equals(outExt)) {
            commandLine.add("-alpha");
            commandLine.add("on");
        }
        commandLine.addAll(List.of("-compress", "JPEG", "-quality", Integer.toString(quality), "-resize", "x" + Integer.toString(size), src.getPath(), dest.getPath()));
        log.debug("Executing: {}", (Object)commandLine);
        new Exec().exec(commandLine, null, null, conf.getInt("converter.ImageConverter.timeout", 10));
        if (!dest.exists() || dest.length() == 0L) {
            String basename = FileUtil.getBaseName(dest.getName());
            String testname = basename + "-0." + outExt;
            File test = new File(dest.getParentFile(), testname);
            if (test.exists()) {
                String[] pages;
                FileUtils.copyFile(test, dest);
                String[] stringArray = pages = dest.getParentFile().list((dir, name) -> name.startsWith(basename + "-") && name.endsWith("." + outExt));
                int n = pages.length;
                int n2 = 0;
                while (n2 < n) {
                    String page = stringArray[n2];
                    FileUtils.deleteQuietly(new File(page));
                    ++n2;
                }
            }
        }
        if (dest.length() < 1L) {
            throw new IOException("Empty thumbnail image");
        }
    }
}

