/*
 * Decompiled with CFR 0.152.
 */
package com.logicaldoc.core.document.thumbnail;

import com.github.mertakdut.Reader;
import com.logicaldoc.core.conversion.FormatConverter;
import com.logicaldoc.core.conversion.FormatConverterManager;
import com.logicaldoc.core.conversion.NotAvailableConverter;
import com.logicaldoc.core.document.Document;
import com.logicaldoc.core.document.thumbnail.ImageThumbnailBuilder;
import com.logicaldoc.core.document.thumbnail.ThumbnailBuilder;
import com.logicaldoc.core.document.thumbnail.ThumbnailManager;
import com.logicaldoc.util.io.FileUtil;
import com.logicaldoc.util.spring.Context;
import java.io.File;
import java.io.IOException;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.lang.StringUtils;

public class EpubThumbnailBuilder
extends ImageThumbnailBuilder {
    private static final String EBOOKCOVER = "ebookcover";

    @Override
    public synchronized void buildThumbnail(String sid, Document document, String fileVersion, File src, File dest, int size, int compression) throws IOException {
        File tmp;
        block10: {
            tmp = null;
            try {
                try {
                    Reader reader = new Reader();
                    reader.setIsIncludingTextContent(true);
                    reader.setFullContent(src.getAbsolutePath());
                    if (reader.getCoverImage() != null) {
                        tmp = FileUtil.createTempFile(EBOOKCOVER, "." + (reader.getCoverImageFileName() != null ? FileUtil.getExtension(reader.getCoverImageFileName()) : "png"));
                        FileUtil.writeFile(reader.getCoverImage(), tmp.getAbsolutePath());
                        super.buildThumbnail(sid, document, fileVersion, tmp, dest, size, compression);
                        break block10;
                    }
                    tmp = FileUtil.createTempFile(EBOOKCOVER, ".pdf");
                    ThumbnailBuilder pdfBuilder = Context.get(ThumbnailManager.class).getBuilder("pdf");
                    FormatConverter pdfConverter = Context.get(FormatConverterManager.class).getConverter("epub", "pdf");
                    if (pdfBuilder != null && pdfConverter != null && !(pdfConverter instanceof NotAvailableConverter)) {
                        pdfConverter.convert(src, tmp);
                        pdfBuilder.buildThumbnail(sid, document, fileVersion, tmp, dest, size, compression);
                        break block10;
                    }
                    tmp = FileUtil.createTempFile(EBOOKCOVER, ".txt");
                    List navPoints = reader.getToc().getNavMap().getNavPoints();
                    String toc = navPoints.stream().map(p -> p.getNavLabel()).filter(StringUtils::isNotEmpty).collect(Collectors.joining("\n"));
                    FileUtil.writeFile(toc, tmp.getAbsolutePath());
                    File pdf = FileUtil.createTempFile(EBOOKCOVER, ".pdf");
                    try {
                        pdfConverter = Context.get(FormatConverterManager.class).getConverter("txt", "pdf");
                        pdfConverter.convert(tmp, pdf);
                        if (pdfBuilder != null) {
                            pdfBuilder.buildThumbnail(sid, document, fileVersion, pdf, dest, size, compression);
                        }
                    }
                    finally {
                        FileUtil.delete(pdf);
                    }
                }
                catch (Exception e) {
                    throw new IOException("Thumbnail building " + e.getMessage(), e);
                }
            }
            catch (Throwable throwable) {
                FileUtil.delete(tmp);
                throw throwable;
            }
        }
        FileUtil.delete(tmp);
    }
}

