/*
 * Decompiled with CFR 0.152.
 */
package com.logicaldoc.core.document;

import com.logicaldoc.core.document.AbstractDocument;
import com.logicaldoc.core.document.Document;
import com.logicaldoc.core.document.DocumentEvent;
import com.logicaldoc.core.document.IndexingStatus;
import com.logicaldoc.core.metadata.Attribute;
import com.logicaldoc.core.metadata.Template;
import com.logicaldoc.core.security.user.User;
import com.logicaldoc.util.config.ContextProperties;
import jakarta.persistence.Cacheable;
import jakarta.persistence.CollectionTable;
import jakarta.persistence.Column;
import jakarta.persistence.ElementCollection;
import jakarta.persistence.Entity;
import jakarta.persistence.FetchType;
import jakarta.persistence.JoinColumn;
import jakarta.persistence.MapKeyColumn;
import jakarta.persistence.OrderBy;
import jakarta.persistence.Table;
import java.io.IOException;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.StringTokenizer;
import org.apache.commons.beanutils.BeanUtils;
import org.apache.commons.lang.StringUtils;

@Entity
@Table(name="ld_version")
@Cacheable
public class Version
extends AbstractDocument
implements Comparable<Version> {
    private static final long serialVersionUID = 1L;
    @Column(name="ld_documentid", nullable=false)
    private long docId;
    @Column(name="ld_username", length=255)
    private String username;
    @Column(name="ld_userid")
    private long userId;
    @Column(name="ld_versiondate", columnDefinition="DATETIME(3)")
    private Date versionDate = new Date();
    @Column(name="ld_folderid")
    private long folderId;
    @Column(name="ld_foldername", length=1000)
    private String folderName;
    @Column(name="ld_event", length=255)
    private String event;
    @Column(name="ld_creator", length=255)
    private String creator;
    @Column(name="ld_creatorid", nullable=false)
    private long creatorId;
    @Column(name="ld_templateid")
    private Long templateId;
    @Column(name="ld_templatename")
    private String templateName;
    @ElementCollection(fetch=FetchType.LAZY)
    @CollectionTable(name="ld_version_ext", joinColumns={@JoinColumn(name="ld_versionid")})
    @MapKeyColumn(name="ld_name", length=255)
    @OrderBy(value="ld_position ASC, ld_name ASC")
    private Map<String, Attribute> attributes = new HashMap<String, Attribute>();

    public Version() {
    }

    public Version(Version source) {
        this.copyAttributes(source);
        this.setId(source.getId());
        this.setFolderId(source.getFolderId());
        if (source.getIndexed() != IndexingStatus.INDEXED) {
            this.setIndexingStatus(source.getIndexed());
        }
        this.setCustomId(null);
    }

    @Override
    public Map<String, Attribute> getAttributes() {
        return this.attributes;
    }

    @Override
    public void setAttributes(Map<String, Attribute> attributes) {
        this.attributes = attributes;
    }

    public long getUserId() {
        return this.userId;
    }

    public void setUserId(long userId) {
        this.userId = userId;
    }

    public String getUsername() {
        return this.username;
    }

    public void setUsername(String username) {
        this.username = username;
    }

    private String getNewVersionName(String oldVersionName, boolean major) {
        if (StringUtils.isEmpty(oldVersionName)) {
            try {
                ContextProperties config = new ContextProperties();
                return config.getProperty("document.startversion");
            }
            catch (IOException e) {
                return "1.0";
            }
        }
        return Version.calculateNewVersion(oldVersionName, major);
    }

    public static String calculateNewVersion(String oldVersionName, boolean major) {
        String rel = oldVersionName.substring(0, oldVersionName.indexOf("."));
        String version = oldVersionName.substring(oldVersionName.lastIndexOf(".") + 1);
        if (major) {
            int number = Integer.parseInt(rel);
            rel = String.valueOf(number + 1);
            version = "0";
        } else {
            int number = Integer.parseInt(version);
            version = String.valueOf(number + 1);
        }
        return rel + "." + version;
    }

    @Override
    public int compareTo(Version other) {
        try {
            StringTokenizer st1 = new StringTokenizer(this.getVersion().trim(), ".", false);
            StringTokenizer st2 = new StringTokenizer(other.getVersion().trim(), ".", false);
            Integer num1 = Integer.parseInt(st1.nextToken());
            Integer num2 = Integer.parseInt(st2.nextToken());
            if (num1.compareTo(num2) != 0) {
                return num1.compareTo(num2);
            }
            num1 = Integer.parseInt(st1.nextToken());
            num2 = Integer.parseInt(st2.nextToken());
            return num1.compareTo(num2);
        }
        catch (Exception t) {
            if (this.getDate() != null && other.getDate() != null) {
                return this.getDate().compareTo(other.getDate());
            }
            return -1;
        }
    }

    @Override
    public String toString() {
        return this.getVersion() + (String)(this.getComment() != null ? "-" + this.getComment() : "");
    }

    public Date getVersionDate() {
        return this.versionDate;
    }

    public void setVersionDate(Date versionDate) {
        this.versionDate = versionDate;
    }

    @Override
    public long getFolderId() {
        return this.folderId;
    }

    public void setFolderId(long folderId) {
        this.folderId = folderId;
    }

    public String getFolderName() {
        return this.folderName;
    }

    public void setFolderName(String folderName) {
        this.folderName = folderName;
    }

    @Override
    public String getTemplateName() {
        return this.templateName;
    }

    @Override
    public void setTemplateName(String templateName) {
        this.templateName = templateName;
    }

    public static Version create(Document document, User user, String comment, DocumentEvent event, boolean release) {
        Version version = new Version();
        try {
            BeanUtils.copyProperties((Object)version, (Object)document);
        }
        catch (Exception exception) {
            // empty catch block
        }
        version.setRevision(document.getRevision() != null ? document.getRevision() : document.getVersion());
        version.setVersion(document.getVersion());
        version.setType(document.getType());
        version.setTenantId(document.getTenantId());
        version.setDeleted(0);
        version.setRecordVersion(0L);
        version.setComment(comment);
        document.setComment(comment);
        version.setEvent(event);
        version.setUserId(user.getId());
        version.setUsername(user.getFullName());
        version.setOcrTemplateId(document.getOcrTemplateId());
        version.setBarcodeTemplateId(document.getBarcodeTemplateId());
        version.setWorkflowStatus(document.getWorkflowStatus());
        version.setWorkflowStatusDisplay(document.getWorkflowStatusDisplay());
        version.setColor(document.getColor());
        version.setLastNote(document.getLastNote());
        if (document.getTemplate() != null) {
            version.setTemplateId(document.getTemplate().getId());
            version.setTemplateName(document.getTemplate().getName());
        }
        version.setAttributes(new HashMap<String, Attribute>());
        if (document.getAttributes() != null) {
            try {
                for (String name : document.getAttributeNames()) {
                    version.getAttributes().put(name, document.getAttributes().get(name));
                }
            }
            catch (Exception name) {
                // empty catch block
            }
        }
        version.setFolderId(document.getFolder().getId());
        version.setFolderName(document.getFolder().getName());
        version.setTgs(document.getTagsString());
        version.setDocId(document.getId());
        version.setLinks(document.getLinks());
        version.setDocAttrs(document.getDocAttrs());
        version.setPublished(document.getPublished());
        version.setStartPublishing(document.getStartPublishing());
        version.setStopPublishing(document.getStopPublishing());
        String newVersionName = document.getVersion();
        if (!event.equals((Object)DocumentEvent.STORED)) {
            newVersionName = version.getNewVersionName(document.getVersion(), release);
            version.setVersion(newVersionName);
            document.setVersion(newVersionName);
        }
        if (DocumentEvent.CHECKEDIN.equals((Object)event) || DocumentEvent.STORED.equals((Object)event) || StringUtils.isEmpty(document.getFileVersion())) {
            version.setFileVersion(newVersionName);
            document.setFileVersion(newVersionName);
        }
        version.setExtResId(document.getExtResId());
        version.setId(0L);
        return version;
    }

    public void setEvent(DocumentEvent event) {
        this.event = event != null ? event.toString() : null;
    }

    public DocumentEvent getEventEnum() {
        if (this.event == null) {
            return null;
        }
        return DocumentEvent.fromKey(this.event);
    }

    public String getEvent() {
        return this.event;
    }

    @Override
    public String getCreator() {
        return this.creator;
    }

    @Override
    public void setCreator(String creator) {
        this.creator = creator;
    }

    @Override
    public long getCreatorId() {
        return this.creatorId;
    }

    @Override
    public void setCreatorId(long creatorId) {
        this.creatorId = creatorId;
    }

    public long getDocId() {
        return this.docId;
    }

    public void setDocId(long docId) {
        this.docId = docId;
    }

    @Override
    public Long getTemplateId() {
        return this.templateId;
    }

    @Override
    public void setTemplateId(Long templateId) {
        this.templateId = templateId;
    }

    @Override
    public Template getTemplate() {
        return null;
    }

    @Override
    public void setTemplate(Template template) {
        if (template != null) {
            this.templateId = template.getId();
            this.setTemplateName(template.getName());
        } else {
            this.templateId = null;
        }
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = super.hashCode();
        result = 31 * result + (int)(this.creatorId ^ this.creatorId >>> 32);
        result = 31 * result + (int)(this.docId ^ this.docId >>> 32);
        result = 31 * result + (this.versionDate == null ? 0 : this.versionDate.hashCode());
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Version other = (Version)obj;
        if (this.creatorId != other.creatorId) {
            return false;
        }
        if (this.docId != other.docId) {
            return false;
        }
        return !(this.versionDate == null ? other.versionDate != null : !this.versionDate.equals(other.versionDate));
    }
}

