/*
 * Decompiled with CFR 0.152.
 */
package com.logicaldoc.core.document;

import com.logicaldoc.core.PersistenceException;
import com.logicaldoc.core.document.DocumentDAO;
import com.logicaldoc.core.task.Task;
import com.logicaldoc.core.task.TaskException;
import jakarta.annotation.Resource;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component(value="tagsProcessor")
public class TagsProcessor
extends Task {
    public static final String NAME = "TagsProcessor";
    @Resource(name="documentDAO")
    private DocumentDAO documentDao;

    public TagsProcessor() {
        super(NAME);
        this.log = LoggerFactory.getLogger(TagsProcessor.class);
    }

    @Override
    public boolean isIndeterminate() {
        return false;
    }

    @Override
    public boolean isConcurrent() {
        return false;
    }

    @Override
    public long getSize() {
        return 3L;
    }

    @Override
    protected void runTask() throws TaskException {
        this.log.info("Start tags processing");
        try {
            if (!this.interruptRequested) {
                this.log.info("Clean unexisting tags");
                this.documentDao.cleanUnexistingUniqueTags();
                this.next();
            }
            if (!this.interruptRequested) {
                this.log.info("Detect new unique tags");
                this.documentDao.insertNewUniqueTags();
                this.next();
            }
            if (!this.interruptRequested) {
                this.log.info("Count tags occurrences");
                this.documentDao.updateCountUniqueTags();
                this.next();
            }
        }
        catch (PersistenceException e) {
            throw new TaskException(e.getMessage(), e);
        }
        this.log.info("End of tags processing");
    }
}

