/*
 * Decompiled with CFR 0.152.
 */
package com.logicaldoc.core.document;

import jakarta.persistence.Column;
import jakarta.persistence.Embeddable;
import java.io.Serializable;

@Embeddable
public class Tag
implements Comparable<Tag>,
Serializable {
    private static final long serialVersionUID = 1L;
    @Column(name="ld_tag", length=255, nullable=false)
    private String tagWord;
    @Column(name="ld_tenantid", nullable=false)
    private long tenantId = 1L;

    public Tag() {
    }

    public Tag(long tenantId, String tag) {
        this.tenantId = tenantId;
        this.tagWord = tag;
    }

    @Override
    public int compareTo(Tag o) {
        int comp = this.tagWord.compareTo(o.tagWord);
        if (comp != 0) {
            return comp;
        }
        return Long.compare(this.tenantId, o.tenantId);
    }

    public String getTag() {
        return this.tagWord;
    }

    public void setTag(String tag) {
        this.tagWord = tag;
    }

    public long getTenantId() {
        return this.tenantId;
    }

    public void setTenantId(long tenantId) {
        this.tenantId = tenantId;
    }

    public String toString() {
        if (this.tagWord == null) {
            return "";
        }
        return this.tagWord;
    }

    public int hashCode() {
        if (this.tagWord == null) {
            return 0;
        }
        return (this.tagWord + this.tenantId).hashCode();
    }

    public boolean equals(Object o) {
        if (o == null) {
            return false;
        }
        if (this.getClass() != o.getClass()) {
            return false;
        }
        Tag other = (Tag)o;
        return other.tenantId == this.tenantId && this.tagWord != null && this.tagWord.equals(other.tagWord);
    }
}

