/*
 * Decompiled with CFR 0.152.
 */
package com.logicaldoc.core.document;

import com.logicaldoc.core.HibernatePersistentObjectDAO;
import com.logicaldoc.core.PersistenceException;
import com.logicaldoc.core.document.Version;
import com.logicaldoc.core.document.VersionDAO;
import com.logicaldoc.core.folder.Folder;
import com.logicaldoc.core.folder.FolderDAO;
import com.logicaldoc.core.store.Store;
import com.logicaldoc.util.config.ContextProperties;
import com.logicaldoc.util.io.FileUtil;
import jakarta.annotation.Resource;
import jakarta.transaction.Transactional;
import java.io.IOException;
import java.io.InputStream;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Repository;

@Repository(value="versionDAO")
@Transactional
public class HibernateVersionDAO
extends HibernatePersistentObjectDAO<Version>
implements VersionDAO {
    private static final String DOC_ID = ".docId=";
    @Resource(name="Store")
    protected Store store;
    @Resource(name="folderDAO")
    protected FolderDAO folderDAO;

    public HibernateVersionDAO() {
        super(Version.class);
        this.log = LoggerFactory.getLogger(HibernateVersionDAO.class);
    }

    @Override
    public List<Version> findByDocId(long docId) throws PersistenceException {
        return this.findByWhere(" _entity.docId=" + docId, "_entity.versionDate desc", null);
    }

    @Override
    public Version findByVersion(long docId, String version) throws PersistenceException {
        List versions = this.findByWhere(" _entity.docId=" + docId + " and _entity.version = :version", Map.of("version", StringUtils.defaultString(version)), null, null);
        if (!versions.isEmpty()) {
            return (Version)versions.get(0);
        }
        return null;
    }

    @Override
    public Version findByFileVersion(long docId, String fileVersion) throws PersistenceException {
        List versions = this.findByWhere(" _entity.docId=" + docId + " and _entity.fileVersion = :fileVersion", Map.of("fileVersion", StringUtils.defaultString(fileVersion)), "_entity.date asc", null);
        if (!versions.isEmpty()) {
            return (Version)versions.get(0);
        }
        return null;
    }

    @Override
    public void initialize(Version version) {
        this.refresh(version);
        if (version.getAttributes() != null) {
            this.log.trace("Initialized {} attributes", (Object)version.getAttributes().keySet().size());
        }
    }

    @Override
    public void store(Version version) throws PersistenceException {
        super.store(version);
        try {
            List<Version> versions;
            ContextProperties bean = new ContextProperties();
            int maxVersions = bean.getInt("document.maxversions", -1);
            Folder workspace = this.folderDAO.findWorkspace(version.getFolderId());
            if (workspace != null && workspace.getMaxVersions() != null && workspace.getMaxVersions() > 0) {
                maxVersions = workspace.getMaxVersions();
            }
            if (maxVersions > 0 && (versions = this.findByDocId(version.getDocId())).size() > maxVersions) {
                this.deleteOldestVersions(versions, maxVersions);
            }
        }
        catch (IOException e) {
            throw new PersistenceException(e.getMessage(), e);
        }
    }

    private void deleteOldestVersions(List<Version> versions, int maxVersions) {
        if (versions.size() <= maxVersions) {
            return;
        }
        Collections.sort(versions, Collections.reverseOrder());
        List oldestVersionsToDelete = versions.stream().skip(maxVersions).toList();
        for (Version versionToDelete : oldestVersionsToDelete) {
            this.deleteVersion(versionToDelete, 1);
        }
    }

    @Override
    public void updateDigest(Version version) throws PersistenceException {
        this.initialize(version);
        String resource = this.store.getResourceName(version.getDocId(), version.getFileVersion(), null);
        if (this.store.exists(version.getDocId(), resource)) {
            try {
                Throwable throwable = null;
                Object var4_6 = null;
                try (InputStream in = this.store.getStream(version.getDocId(), resource);){
                    version.setDigest(FileUtil.computeDigest(in));
                }
                catch (Throwable throwable2) {
                    if (throwable == null) {
                        throwable = throwable2;
                    } else if (throwable != throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
            }
            catch (IOException e) {
                this.log.error("Cannot retrieve the content of version {}", (Object)version);
                this.log.error(e.getMessage(), e);
            }
            this.saveOrUpdate(version);
        }
    }

    @Override
    public void delete(long versionId, int delCode) throws PersistenceException {
        if (!this.checkStoringAspect()) {
            return;
        }
        Version ver = (Version)this.findById(versionId);
        if (ver != null) {
            this.deleteVersion(ver, delCode);
        }
    }

    protected void deleteVersion(Version versionToDelete, int delCode) {
        if (delCode == 0) {
            throw new IllegalArgumentException("delCode cannot be 0");
        }
        versionToDelete.setDeleted(delCode);
        versionToDelete.setLastModified(new Date());
        versionToDelete.setVersion(StringUtils.right(versionToDelete.getId() + "." + versionToDelete.getVersion(), 10));
        this.saveOrUpdate(versionToDelete);
        try {
            long referencesToFileversion = this.queryForLong("select count(*) from ld_version where ld_deleted=0 and ld_documentid = :documentid and ld_fileversion = :fileversion and not ld_id = :currentid", Map.of("documentid", versionToDelete.getDocId(), "fileversion", versionToDelete.getFileVersion(), "currentid", versionToDelete.getId()));
            if (referencesToFileversion == 0L) {
                this.store.delete(versionToDelete.getDocId(), versionToDelete.getFileVersion());
            }
        }
        catch (PersistenceException e) {
            this.log.warn(e.getMessage(), e);
        }
    }

    @Override
    public void deleteAll(Collection<Version> entities, int code) throws PersistenceException {
        for (Version version : entities) {
            this.deleteVersion(version, code);
        }
    }
}

