/*
 * Decompiled with CFR 0.152.
 */
package com.logicaldoc.core.document;

import com.logicaldoc.core.HibernatePersistentObjectDAO;
import com.logicaldoc.core.PersistenceException;
import com.logicaldoc.core.document.Document;
import com.logicaldoc.core.document.DocumentDAO;
import com.logicaldoc.core.document.DocumentEvent;
import com.logicaldoc.core.document.DocumentHistory;
import com.logicaldoc.core.document.Rating;
import com.logicaldoc.core.document.RatingDAO;
import com.logicaldoc.core.security.Session;
import com.logicaldoc.core.security.SessionManager;
import com.logicaldoc.util.spring.Context;
import jakarta.transaction.Transactional;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.slf4j.LoggerFactory;
import org.springframework.jdbc.core.BeanPropertyRowMapper;
import org.springframework.stereotype.Repository;

@Repository(value="ratingDAO")
@Transactional
public class HibernateRatingDAO
extends HibernatePersistentObjectDAO<Rating>
implements RatingDAO {
    public HibernateRatingDAO() {
        super(Rating.class);
        this.log = LoggerFactory.getLogger(HibernateRatingDAO.class);
    }

    @Override
    public void store(Rating rating, DocumentHistory transaction) throws PersistenceException {
        super.store(rating);
        this.flush();
        try {
            if (transaction != null) {
                transaction.setEvent(DocumentEvent.RATING_NEW);
                transaction.setComment("rating: " + rating.getVote());
            }
            this.updateDocumentRating(rating.getDocId(), transaction);
        }
        catch (Exception e) {
            if (transaction != null && StringUtils.isNotEmpty(transaction.getSessionId())) {
                Session session = SessionManager.get().get(transaction.getSessionId());
                session.logError(e.getMessage());
            }
            this.log.error(e.getMessage(), e);
        }
    }

    @Override
    public int updateDocumentRating(long docId, DocumentHistory transaction) throws PersistenceException {
        Rating votesDoc = this.findVotesByDocId(docId);
        DocumentDAO docDao = Context.get(DocumentDAO.class);
        Document doc = (Document)docDao.findById(docId);
        if (doc == null) {
            return 0;
        }
        docDao.initialize(doc);
        int average = 0;
        if (votesDoc != null && votesDoc.getAverage() != null) {
            average = votesDoc.getAverage().intValue();
        }
        doc.setRating(average);
        docDao.store(doc, transaction);
        return average;
    }

    @Override
    public Rating findVotesByDocId(long docId) throws PersistenceException {
        BeanPropertyRowMapper ratingMapper;
        String query = "select count(*), SUM(ld_vote) from ld_rating where ld_deleted=0 and ld_docid = " + docId;
        List coll = this.query(query, ratingMapper = new BeanPropertyRowMapper(){

            public Object mapRow(ResultSet rs, int rowNum) throws SQLException {
                Rating rating = new Rating();
                rating.setCount(rs.getInt(1));
                if (rs.getInt(1) > 0) {
                    float div = (float)rs.getInt(2) / (float)rs.getInt(1);
                    double avg = (double)Math.round((double)div * 100.0) / 100.0;
                    rating.setAverage(Float.valueOf((float)avg));
                } else {
                    rating.setAverage(Float.valueOf(0.0f));
                }
                return rating;
            }
        }, (Integer)null);
        if (!coll.isEmpty() && ((Rating)coll.get(0)).getCount() != 0) {
            return (Rating)coll.get(0);
        }
        return null;
    }

    @Override
    public Rating findByDocIdAndUserId(long docId, long userId) throws PersistenceException {
        List results = this.findByWhere("_entity.docId =" + docId + " and _entity.userId =" + userId, null, null);
        if (results.isEmpty()) {
            return null;
        }
        return (Rating)results.get(0);
    }

    @Override
    public List<Rating> findByDocId(long docId) throws PersistenceException {
        return this.findByWhere("_entity.docId = " + docId, "_entity.lastModified desc", null);
    }

    @Override
    public void delete(long id, int code) throws PersistenceException {
        if (!this.checkStoringAspect()) {
            return;
        }
        Rating rat = (Rating)this.findById(id);
        long docId = rat.getDocId();
        this.jdbcUpdate("delete from ld_rating where ld_id=" + id);
        this.updateDocumentRating(docId, null);
    }
}

