/*
 * Decompiled with CFR 0.152.
 */
package com.logicaldoc.core.document;

import com.logicaldoc.core.HibernatePersistentObjectDAO;
import com.logicaldoc.core.PersistenceException;
import com.logicaldoc.core.document.Document;
import com.logicaldoc.core.document.DocumentDAO;
import com.logicaldoc.core.document.DocumentEvent;
import com.logicaldoc.core.document.DocumentHistory;
import com.logicaldoc.core.document.DocumentNote;
import com.logicaldoc.core.document.DocumentNoteDAO;
import com.logicaldoc.core.document.IndexingStatus;
import com.logicaldoc.core.security.Session;
import com.logicaldoc.core.security.SessionManager;
import com.logicaldoc.core.threading.ThreadPools;
import com.logicaldoc.util.html.HTMLSanitizer;
import com.logicaldoc.util.spring.Context;
import jakarta.transaction.Transactional;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Repository;

@Repository(value="documentNoteDAO")
@Transactional
public class HibernateDocumentNoteDAO
extends HibernatePersistentObjectDAO<DocumentNote>
implements DocumentNoteDAO {
    private static final String DELETED_0 = ".deleted=0";
    private static final String DOC_ID_DOC_ID_AND = ".docId = :docId and ";
    private static final String DOC_ID = "docId";

    public HibernateDocumentNoteDAO() {
        super(DocumentNote.class);
        this.log = LoggerFactory.getLogger(HibernateDocumentNoteDAO.class);
    }

    @Override
    public void store(DocumentNote note) throws PersistenceException {
        DocumentDAO documentDao = Context.get(DocumentDAO.class);
        Document doc = (Document)documentDao.findById(note.getDocId());
        if (doc == null) {
            throw new PersistenceException("Cannot save note for undexisting document " + note.getDocId());
        }
        if (note.getFileVersion() == null) {
            note.setFileVersion(doc.getFileVersion());
        }
        super.store(note);
        if (note.getPage() == 0) {
            documentDao.initialize(doc);
            doc.setLastNote(HTMLSanitizer.sanitizeSimpleText(note.getMessage()));
            if (doc.getIndexed() == IndexingStatus.INDEXED) {
                doc.setIndexingStatus(IndexingStatus.TO_INDEX);
            }
            documentDao.store(doc);
        }
    }

    private void updateLastNote(DocumentNote note) {
        if (note.getPage() == 0) {
            ThreadPools.get().execute(() -> {
                try {
                    DocumentDAO dao = Context.get(DocumentDAO.class);
                    Document doc = (Document)dao.findById(note.getDocId());
                    dao.initialize(doc);
                    String lastNoteMessage = dao.queryForList("select ld_message from ld_note where ld_page=0 and ld_deleted=0 and ld_docid=:id order by ld_date desc", Map.of("id", note.getDocId()), String.class, null).stream().findFirst().orElse("");
                    lastNoteMessage = HTMLSanitizer.sanitizeSimpleText(lastNoteMessage);
                    if (!lastNoteMessage.equals(doc.getLastNote())) {
                        doc.setLastNote(HTMLSanitizer.sanitizeSimpleText(lastNoteMessage));
                        if (doc.getIndexed() == IndexingStatus.INDEXED) {
                            doc.setIndexingStatus(IndexingStatus.TO_INDEX);
                        }
                        dao.store(doc);
                    }
                }
                catch (Exception e) {
                    this.log.error(e.getMessage(), e);
                }
                return null;
            }, "Note");
        }
    }

    @Override
    public void store(DocumentNote note, DocumentHistory transaction) throws PersistenceException {
        this.store(note);
        try {
            if (transaction != null) {
                DocumentDAO documentDao = Context.get(DocumentDAO.class);
                Document doc = (Document)documentDao.findById(note.getDocId());
                transaction.setEvent(DocumentEvent.NEW_NOTE);
                documentDao.saveDocumentHistory(doc, transaction);
            }
        }
        catch (Exception e) {
            if (StringUtils.isNotEmpty(transaction.getSessionId())) {
                Session session = SessionManager.get().get(transaction.getSessionId());
                session.logError(e.getMessage());
            }
            this.log.error(e.getMessage(), e);
        }
    }

    @Override
    public List<DocumentNote> findByDocId(long docId, String fileVersion) throws PersistenceException {
        return this.findByDocIdAndType(docId, fileVersion, null);
    }

    @Override
    public List<DocumentNote> findByDocIdAndType(long docId, String fileVersion, String type) throws PersistenceException {
        return this.findByDocIdAndTypes(docId, fileVersion, StringUtils.isEmpty(type) ? null : Arrays.asList(type));
    }

    @Override
    public List<DocumentNote> findByDocIdAndTypes(long docId, String fileVersion, Collection<String> types) throws PersistenceException {
        if (StringUtils.isEmpty(fileVersion)) {
            if (types == null || types.isEmpty()) {
                return this.findByWhere("_entity.docId = " + docId, null, null);
            }
            HashMap<String, Object> params = new HashMap<String, Object>();
            params.put(DOC_ID, docId);
            params.put("types", types);
            return this.findByWhere("_entity.docId = :docId and _entity.type in (:types) and _entity.deleted=0", params, null, null);
        }
        if (types == null || types.isEmpty()) {
            HashMap<String, Object> params = new HashMap<String, Object>();
            params.put(DOC_ID, docId);
            params.put("fileVersion", fileVersion);
            return this.findByWhere("_entity.docId = :docId and _entity.fileVersion = :fileVersion and _entity.deleted=0", params, null, null);
        }
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put(DOC_ID, docId);
        params.put("fileVersion", fileVersion);
        params.put("types", types);
        return this.findByWhere("_entity.docId = :docId and _entity.fileVersion = :fileVersion and _entity.type in (:types) and _entity.deleted=0", params, null, null);
    }

    @Override
    public List<DocumentNote> findByUserId(long userId) throws PersistenceException {
        return this.findByWhere("_entity.userId =" + userId, "_entity.date desc", null);
    }

    @Override
    public void delete(long id, int code) throws PersistenceException {
        DocumentNote note = (DocumentNote)this.findById(id);
        if (note != null) {
            super.delete(id, code);
            this.updateLastNote(note);
        }
    }

    @Override
    public int copyAnnotations(long docId, String oldFileVersion, String newFileVersion) throws PersistenceException {
        List<DocumentNote> oldNotes = this.findByDocId(docId, oldFileVersion);
        int count = 0;
        for (DocumentNote oldNote : oldNotes) {
            if (oldNote.getPage() > 0) continue;
            DocumentNote newNote = new DocumentNote(oldNote);
            newNote.setId(0L);
            newNote.setFileVersion(newFileVersion);
            this.store(newNote);
            ++count;
        }
        return count;
    }
}

