/*
 * Decompiled with CFR 0.152.
 */
package com.logicaldoc.core.document;

import com.logicaldoc.core.HibernatePersistentObjectDAO;
import com.logicaldoc.core.PersistenceException;
import com.logicaldoc.core.document.DocumentLink;
import com.logicaldoc.core.document.DocumentLinkDAO;
import jakarta.transaction.Transactional;
import java.util.HashMap;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Repository;

@Repository(value="documentLinkDAO")
@Transactional
public class HibernateDocumentLinkDAO
extends HibernatePersistentObjectDAO<DocumentLink>
implements DocumentLinkDAO {
    public HibernateDocumentLinkDAO() {
        super(DocumentLink.class);
        this.log = LoggerFactory.getLogger(HibernateDocumentLinkDAO.class);
    }

    @Override
    public List<DocumentLink> findByDocId(long docId) throws PersistenceException {
        return this.findByDocId(docId, null);
    }

    @Override
    public List<DocumentLink> findByDocId(long docId, String type) throws PersistenceException {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("docId", docId);
        StringBuilder query = new StringBuilder("(_entity.document1.id = :docId ");
        query.append(" or _entity.document2.id = :docId) ");
        if (StringUtils.isNotEmpty(type)) {
            query.append("and _entity.type = :type");
            params.put("type", type);
        }
        return this.findByWhere(query.toString(), params, null, null);
    }

    @Override
    public DocumentLink findByDocIdsAndType(long docId1, long docId2, String type) throws PersistenceException {
        if (type == null) {
            return null;
        }
        DocumentLink link = null;
        StringBuilder query = new StringBuilder("_entity.document1.id = :docId1 and _entity.document2.id = :docId2 ");
        query.append(" and _entity.type = :type");
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("docId1", docId1);
        params.put("docId2", docId2);
        params.put("type", type);
        List links = this.findByWhere(query.toString(), params, null, null);
        if (!links.isEmpty()) {
            link = (DocumentLink)links.iterator().next();
        }
        return link;
    }

    @Override
    public void delete(long id, int code) throws PersistenceException {
        if (!this.checkStoringAspect()) {
            return;
        }
        DocumentLink link = (DocumentLink)this.findById(id);
        if (link != null) {
            long docId1 = link.getDocument1() != null ? link.getDocument1().getId() : 0L;
            long docId2 = link.getDocument2() != null ? link.getDocument2().getId() : 0L;
            super.delete(id, code);
            this.flush();
            this.updateLinksCount(docId1);
            this.updateLinksCount(docId2);
        }
    }

    @Override
    public void store(DocumentLink entity) throws PersistenceException {
        boolean newLink = entity.getId() == 0L;
        super.store(entity);
        this.flush();
        if (newLink) {
            if (entity.getDocument1() != null) {
                this.updateLinksCount(entity.getDocument1().getId());
            }
            if (entity.getDocument2() != null) {
                this.updateLinksCount(entity.getDocument2().getId());
            }
        }
    }

    private void updateLinksCount(long docId) throws PersistenceException {
        this.jdbcUpdate("update ld_document set ld_links = (select count(*) from ld_link  where ld_deleted=0 and (ld_docid1=" + docId + " or ld_docid2=" + docId + ")) where ld_id=" + docId);
    }
}

