/*
 * Decompiled with CFR 0.152.
 */
package com.logicaldoc.core.document;

import com.logicaldoc.core.PersistenceException;
import com.logicaldoc.core.document.DocumentEvent;
import com.logicaldoc.core.document.DocumentHistory;
import com.logicaldoc.core.document.DocumentHistoryDAO;
import com.logicaldoc.core.history.HibernateHistoryDAO;
import com.logicaldoc.util.sql.SqlUtil;
import jakarta.transaction.Transactional;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Repository;

@Repository(value="documentHistoryDAO")
@Transactional
public class HibernateDocumentHistoryDAO
extends HibernateHistoryDAO<DocumentHistory>
implements DocumentHistoryDAO {
    private static final String DATE_ASC = ".date asc";
    private static final String AND = " and ";

    private HibernateDocumentHistoryDAO() {
        super(DocumentHistory.class);
        this.log = LoggerFactory.getLogger(HibernateDocumentHistoryDAO.class);
    }

    @Override
    public List<DocumentHistory> findByDocId(long docId) throws PersistenceException {
        return this.findByDocIdAndEvent(docId, null);
    }

    @Override
    public List<DocumentHistory> findByDocIdAndEvent(long docId, DocumentEvent event) throws PersistenceException {
        StringBuilder query = new StringBuilder("_entity.docId = " + docId);
        if (event != null && StringUtils.isNotEmpty(event.toString())) {
            query.append(" and _entity.event='" + SqlUtil.doubleQuotes(event.toString()) + "'");
        }
        return this.findByWhere(query.toString(), "_entity.date desc", null);
    }

    @Override
    public List<DocumentHistory> findByUserId(long userId) throws PersistenceException {
        return this.findByUserIdAndEvent(userId, null, null);
    }

    @Override
    public List<DocumentHistory> findByFolderId(long folderId) throws PersistenceException {
        return this.findByWhere("_entity.folderId =" + folderId, "_entity.date asc", null);
    }

    @Override
    public List<DocumentHistory> findNotNotified(Integer max) throws PersistenceException {
        return this.findByWhere("_entity.notified = 0", "_entity.date asc", max);
    }

    @Override
    public void cleanOldHistories(int ttl) throws PersistenceException {
        this.log.info("cleanOldHistories rows updated: {}", (Object)this.cleanOldRecords(ttl, "ld_history"));
    }

    @Override
    public List<DocumentHistory> findByUserIdAndEvent(long userId, String event, String sessionId) throws PersistenceException {
        String query = "_entity.userId =" + userId;
        if (event != null && StringUtils.isNotEmpty(event)) {
            query = query + " and _entity.event = '" + SqlUtil.doubleQuotes(event) + "'";
        }
        if (sessionId != null && StringUtils.isNotEmpty(sessionId)) {
            query = query + " and _entity.sessionId = '" + sessionId + "'";
        }
        return this.findByWhere(query, "_entity.date asc", null);
    }

    @Override
    public void markHistoriesAsRead(String event, long userId) throws PersistenceException {
        String statement = "update ld_history set ld_new=0 where ld_new=1 and ld_userid=" + userId + " and ld_event='" + SqlUtil.doubleQuotes(event) + "'";
        this.jdbcUpdate(statement);
    }

    @Override
    public List<DocumentHistory> findByPath(String pathExpression, Date oldestDate, Collection<String> events, Integer max) throws PersistenceException {
        StringBuilder query = new StringBuilder("(_entity.path like :pathExpression or _entity.pathOld like :pathExpression) ");
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("pathExpression", pathExpression);
        if (oldestDate != null) {
            query.append(" and _entity.date >= :oldestDate ");
            params.put("oldestDate", oldestDate);
        }
        if (events != null && !events.isEmpty()) {
            StringBuilder eventsStr = new StringBuilder("(");
            for (String event : events) {
                if (eventsStr.length() > 1) {
                    eventsStr.append(",");
                }
                eventsStr.append("'" + event + "'");
            }
            eventsStr.append(")");
            query.append(" and _entity.event in " + String.valueOf(eventsStr));
        }
        return this.findByWhere(query.toString(), params, " order by _entity.date asc", max);
    }
}

