/*
 * Decompiled with CFR 0.152.
 */
package com.logicaldoc.core.document;

import com.logicaldoc.core.HibernatePersistentObjectDAO;
import com.logicaldoc.core.PersistenceException;
import com.logicaldoc.core.RunLevel;
import com.logicaldoc.core.communication.EventCollector;
import com.logicaldoc.core.document.Document;
import com.logicaldoc.core.document.DocumentAccessControlEntry;
import com.logicaldoc.core.document.DocumentDAO;
import com.logicaldoc.core.document.DocumentEvent;
import com.logicaldoc.core.document.DocumentHistory;
import com.logicaldoc.core.document.DocumentHistoryDAO;
import com.logicaldoc.core.document.DocumentLink;
import com.logicaldoc.core.document.DocumentLinkDAO;
import com.logicaldoc.core.document.DocumentListener;
import com.logicaldoc.core.document.DocumentListenerManager;
import com.logicaldoc.core.document.DocumentNote;
import com.logicaldoc.core.document.DocumentNoteDAO;
import com.logicaldoc.core.document.DocumentStatus;
import com.logicaldoc.core.document.IndexingStatus;
import com.logicaldoc.core.document.Tag;
import com.logicaldoc.core.document.TagCloud;
import com.logicaldoc.core.document.TooManyDocumentsException;
import com.logicaldoc.core.document.Version;
import com.logicaldoc.core.document.VersionDAO;
import com.logicaldoc.core.folder.Folder;
import com.logicaldoc.core.folder.FolderDAO;
import com.logicaldoc.core.generic.GenericDAO;
import com.logicaldoc.core.metadata.Attribute;
import com.logicaldoc.core.security.Permission;
import com.logicaldoc.core.security.Session;
import com.logicaldoc.core.security.SessionManager;
import com.logicaldoc.core.security.Tenant;
import com.logicaldoc.core.security.TenantDAO;
import com.logicaldoc.core.security.user.Group;
import com.logicaldoc.core.security.user.GroupDAO;
import com.logicaldoc.core.security.user.User;
import com.logicaldoc.core.security.user.UserDAO;
import com.logicaldoc.core.store.Store;
import com.logicaldoc.util.config.ContextProperties;
import com.logicaldoc.util.io.FileUtil;
import com.logicaldoc.util.spring.Context;
import com.logicaldoc.util.sql.SqlUtil;
import jakarta.annotation.Resource;
import jakarta.transaction.Transactional;
import java.io.IOException;
import java.io.InputStream;
import java.security.NoSuchAlgorithmException;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.time.Instant;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.time.temporal.ChronoUnit;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.slf4j.LoggerFactory;
import org.springframework.jdbc.core.BeanPropertyRowMapper;
import org.springframework.jdbc.core.RowMapper;
import org.springframework.stereotype.Repository;

@Repository(value="documentDAO")
@Transactional
public class HibernateDocumentDAO
extends HibernatePersistentObjectDAO<Document>
implements DocumentDAO {
    private static final String DOC_ID = "docId";
    private static final String TRANSACTION_CANNOT_BE_NULL = "transaction cannot be null";
    private static final String AND = " and ";
    private static final String AND_LD_TENANTID = " and ld_tenantid=";
    private static final String STATUS = ".status=";
    @Resource(name="documentHistoryDAO")
    private DocumentHistoryDAO documentHistoryDAO;
    @Resource(name="versionDAO")
    private VersionDAO versionDAO;
    @Resource(name="tenantDAO")
    private TenantDAO tenantDAO;
    @Resource(name="documentNoteDAO")
    private DocumentNoteDAO noteDAO;
    @Resource(name="folderDAO")
    private FolderDAO folderDAO;
    @Resource(name="userDAO")
    private UserDAO userDAO;
    @Resource(name="groupDAO")
    private GroupDAO groupDAO;
    @Resource(name="documentLinkDAO")
    private DocumentLinkDAO linkDAO;
    @Resource(name="documentListenerManager")
    private DocumentListenerManager listenerManager;
    @Resource(name="Store")
    private Store store;
    @Resource(name="ContextProperties")
    private ContextProperties config;

    private HibernateDocumentDAO() {
        super(Document.class);
        this.log = LoggerFactory.getLogger(HibernateDocumentDAO.class);
    }

    @Override
    public void archive(long docId, DocumentHistory transaction) throws PersistenceException {
        Document doc = (Document)this.findById(docId);
        doc.setStatus(DocumentStatus.ARCHIVED);
        if (doc.getIndexed() != IndexingStatus.SKIP) {
            doc.setIndexingStatus(IndexingStatus.TO_INDEX);
        }
        doc.setLockUserId(transaction.getUserId());
        transaction.setEvent(DocumentEvent.ARCHIVED);
        this.store(doc, transaction);
        this.log.debug("Archived document {}", (Object)docId);
    }

    @Override
    public void unarchive(long docId, DocumentHistory transaction) throws PersistenceException {
        Document doc = (Document)this.findById(docId);
        doc.setStatus(DocumentStatus.UNLOCKED);
        doc.setLockUserId(null);
        transaction.setEvent(DocumentEvent.RESTORED);
        this.store(doc, transaction);
        this.log.debug("Unarchived document {}", (Object)docId);
    }

    @Override
    public void delete(long docId, DocumentHistory transaction) throws PersistenceException {
        this.delete(docId, 1, transaction);
    }

    @Override
    public void delete(long docId, int delCode, DocumentHistory transaction) throws PersistenceException {
        if (delCode == 0) {
            throw new IllegalArgumentException("delCode cannot be 0");
        }
        if (transaction == null) {
            throw new IllegalArgumentException(TRANSACTION_CANNOT_BE_NULL);
        }
        if (transaction.getUser() == null) {
            throw new IllegalArgumentException("transaction user cannot be null");
        }
        if (!this.checkStoringAspect()) {
            return;
        }
        Document doc = (Document)this.findById(docId);
        if (doc != null && doc.getImmutable() == 0 || doc != null && doc.getImmutable() == 1 && transaction.getUser().isMemberOf("admin")) {
            this.removeVersions(docId, delCode);
            this.removeNotes(docId, delCode);
            this.removeLinks(docId, delCode);
            doc.setDeleted(delCode);
            doc.setDeleteUserId(transaction.getUserId());
            if (transaction.getUser() != null) {
                doc.setDeleteUser(transaction.getUser().getFullName());
            } else {
                doc.setDeleteUser(transaction.getUsername());
            }
            if (doc.getCustomId() != null) {
                doc.setCustomId(doc.getCustomId() + "." + doc.getId());
            }
            this.store(doc, transaction);
        }
    }

    private void removeLinks(long docId, int delCode) throws PersistenceException {
        for (DocumentLink link : this.linkDAO.findByDocId(docId)) {
            link.setDeleted(delCode);
            this.saveOrUpdate(link);
        }
    }

    private void removeNotes(long docId, int delCode) throws PersistenceException {
        for (DocumentNote note : this.noteDAO.findByDocId(docId, null)) {
            note.setDeleted(delCode);
            this.saveOrUpdate(note);
        }
    }

    private void removeVersions(long docId, int delCode) throws PersistenceException {
        for (Version version : this.versionDAO.findByDocId(docId)) {
            version.setDeleted(delCode);
            this.saveOrUpdate(version);
        }
    }

    @Override
    public List<Long> findByUserId(long userId) throws PersistenceException {
        List<Folder> folders = this.folderDAO.findByUserId(userId);
        if (folders.isEmpty()) {
            return new ArrayList<Long>();
        }
        StringBuilder query = new StringBuilder();
        query.append("_entity.folder.id in (");
        boolean first = true;
        for (Folder folder : folders) {
            if (!first) {
                query.append(",");
            }
            query.append(folder.getId());
            first = false;
        }
        query.append(") and not _entity.status=" + DocumentStatus.ARCHIVED.ordinal());
        return this.findIdsByWhere(query.toString(), null, null);
    }

    @Override
    public List<Document> findByLockUserAndStatus(Long userId, DocumentStatus status) {
        StringBuilder sb = new StringBuilder("select ld_id, ld_folderid, ld_version, ld_fileversion, ld_lastmodified, ld_filename from ld_document where ld_deleted = 0 ");
        if (userId != null) {
            sb.append(" and ld_lockuserid=" + String.valueOf(userId));
        }
        if (status != null) {
            sb.append(" and ld_status=" + status.ordinal());
        }
        try {
            return this.query(sb.toString(), (resultSet, col) -> {
                Document doc = new Document();
                doc.setId(resultSet.getLong(1));
                Folder folder = new Folder();
                folder.setId(resultSet.getLong(2));
                doc.setFolder(folder);
                doc.setVersion(resultSet.getString(3));
                doc.setFileVersion(resultSet.getString(4));
                doc.setLastModified(resultSet.getTimestamp(5));
                doc.setFileName(resultSet.getString(6));
                return doc;
            }, null);
        }
        catch (PersistenceException e) {
            this.log.error(e.getMessage(), e);
            return new ArrayList<Document>();
        }
    }

    @Override
    public List<Long> findDocIdByTag(String tag) throws PersistenceException {
        StringBuilder query = new StringBuilder("select distinct(A.ld_docid) from ld_tag A, ld_document B where A.ld_docid=B.ld_id and not B.ld_status=" + DocumentStatus.ARCHIVED.ordinal());
        query.append(" and lower(ld_tag)='" + SqlUtil.doubleQuotesAndBackslashes(tag).toLowerCase() + "'");
        return this.queryForList(query.toString(), Long.class);
    }

    @Override
    public void store(Document doc) throws PersistenceException {
        this.store(doc, null);
    }

    @Override
    public void store(Document doc, DocumentHistory transaction) throws PersistenceException {
        if (!this.checkStoringAspect()) {
            return;
        }
        try {
            Tenant tenant = (Tenant)this.tenantDAO.findById(doc.getTenantId());
            if (transaction != null) {
                transaction.setTenantId(doc.getTenantId());
                transaction.setTenant(tenant.getName());
            }
            this.truncatePublishingDates(doc);
            this.setIndexed(doc, tenant);
            this.setTags(doc);
            this.removeForbiddenPermissionsForGuests(doc);
            this.setType(doc);
            doc.getAttributes().values().removeIf(Attribute::isSection);
            doc.setDocAttrs((int)doc.getAttributes().values().stream().filter(a -> a.getType() == 7 && a.getIntValue() != null && a.getIntValue() != 0L).count());
            this.setFolder(doc);
            if (doc.getDocRef() == null) {
                this.copyFolderMetadata(doc);
            }
            if (!RunLevel.current().aspectEnabled("customId")) {
                doc.setCustomId(UUID.randomUUID().toString());
                this.log.debug("Aspect customId is disabled so force the the Custom ID to a random UUID");
            }
            this.checkMaxDocsPerFolder(doc);
            this.log.debug("Invoke listeners before store");
            HashMap<String, Object> dictionary = new HashMap<String, Object>();
            for (DocumentListener listener : this.listenerManager.getListeners()) {
                listener.beforeStore(doc, transaction, dictionary);
            }
            if (StringUtils.isEmpty(doc.getCustomId())) {
                doc.setCustomId(UUID.randomUUID().toString());
            }
            if (StringUtils.isEmpty(doc.getRevision())) {
                doc.setRevision(doc.getVersion());
            }
            this.setUniqueFilename(doc);
            this.saveOrUpdate(doc);
            if (doc.getDeleted() == 0 && doc.getId() != 0L) {
                doc = (Document)this.findById(doc.getId());
                this.initialize(doc);
            }
            doc.setModified(false);
            this.log.debug("Invoke listeners after store");
            for (DocumentListener listener : this.listenerManager.getListeners()) {
                listener.afterStore(doc, transaction, dictionary);
            }
            if (StringUtils.isEmpty(doc.getCustomId())) {
                doc.setCustomId(Long.toString(doc.getId()));
                doc.setModified(true);
            }
            if (StringUtils.isEmpty(doc.getRevision())) {
                doc.setRevision(doc.getVersion());
                doc.setModified(true);
            }
            if (doc.isModified()) {
                this.saveOrUpdate(doc);
            }
            this.saveDocumentHistory(doc, transaction, dictionary);
            this.updateAliases(doc);
        }
        catch (Exception e) {
            this.handleStoreError(transaction, e);
        }
    }

    private void removeForbiddenPermissionsForGuests(Document document) throws PersistenceException {
        for (DocumentAccessControlEntry ace : document.getAccessControlList()) {
            Group group = (Group)this.groupDAO.findById(ace.getGroupId());
            if (group == null || !group.isGuest()) continue;
            ace.setArchive(0);
            ace.setAutomation(0);
            ace.setCalendar(0);
            ace.setDelete(0);
            ace.setImmutable(0);
            ace.setMove(0);
            ace.setPassword(0);
            ace.setRename(0);
            ace.setSecurity(0);
            ace.setSign(0);
            ace.setWorkflow(0);
            ace.setWrite(0);
        }
    }

    private void checkMaxDocsPerFolder(Document document) throws PersistenceException {
        long count;
        long maxDocsPerFolder = this.config.getLong("maxdocsperfolder", -1L);
        if (document.getId() == 0L && maxDocsPerFolder > 0L && (count = this.folderDAO.countDocs(document.getFolder().getId())) >= maxDocsPerFolder) {
            throw new TooManyDocumentsException(document.getFolder(), maxDocsPerFolder);
        }
    }

    private void setType(Document doc) {
        if (StringUtils.isEmpty(doc.getType()) && doc.getFileName().contains(".")) {
            doc.setType(FileUtil.getExtension(doc.getFileName()).toLowerCase());
        }
    }

    private boolean handleStoreError(DocumentHistory transaction, Throwable e) throws PersistenceException {
        if (transaction != null && StringUtils.isNotEmpty(transaction.getSessionId())) {
            Session session = SessionManager.get().get(transaction.getSessionId());
            session.logError(e.getMessage());
        }
        this.log.error(e.getMessage(), e);
        if (e instanceof PersistenceException) {
            PersistenceException pe = (PersistenceException)e;
            throw pe;
        }
        throw new PersistenceException(e);
    }

    private void updateAliases(Document doc) throws PersistenceException {
        if (doc.getDocRef() == null) {
            this.jdbcUpdate("update ld_document set ld_filesize= " + doc.getFileSize() + ", ld_pages= " + doc.getPages() + ", ld_version='" + doc.getVersion() + "', ld_fileversion='" + doc.getFileVersion() + "' where ld_docref= " + doc.getId());
        }
    }

    private void copyFolderMetadata(Document doc) {
        if (doc.getFolder().getTemplate() != null) {
            this.copyFolderExtendedAttributes(doc);
        }
        if (doc.getOcrTemplateId() == null && doc.getFolder().getOcrTemplateId() != null) {
            doc.setOcrTemplateId(doc.getFolder().getOcrTemplateId());
        }
        if (doc.getBarcodeTemplateId() == null && doc.getFolder().getBarcodeTemplateId() != null) {
            doc.setBarcodeTemplateId(doc.getFolder().getBarcodeTemplateId());
        }
        if (doc.getTemplate() == null) {
            doc.setOcrTemplateId(null);
        }
    }

    private void copyFolderExtendedAttributes(Document doc) {
        this.folderDAO.initialize(doc.getFolder());
        if (doc.getTemplate() == null || doc.getTemplate().equals(doc.getFolder().getTemplate())) {
            doc.setTemplate(doc.getFolder().getTemplate());
            for (String name : doc.getFolder().getAttributeNames()) {
                Attribute fAtt = doc.getFolder().getAttribute(name);
                if (fAtt.getValue() == null || StringUtils.isEmpty(fAtt.getValue().toString())) continue;
                Attribute dAtt = doc.getAttribute(name);
                if (dAtt == null) {
                    dAtt = new Attribute();
                    dAtt.setType(fAtt.getType());
                    dAtt.setEditor(fAtt.getEditor());
                    dAtt.setLabel(fAtt.getLabel());
                    dAtt.setMandatory(fAtt.getMandatory());
                    dAtt.setHidden(fAtt.getHidden());
                    dAtt.setMultiple(fAtt.getMultiple());
                    dAtt.setPosition(fAtt.getPosition());
                    doc.getAttributes().put(name, dAtt);
                }
                if (dAtt.getValue() != null && !StringUtils.isEmpty(dAtt.getValue().toString())) continue;
                dAtt.setStringValue(fAtt.getStringValue());
                dAtt.setDateValue(fAtt.getDateValue());
                dAtt.setDoubleValue(fAtt.getDoubleValue());
                dAtt.setIntValue(fAtt.getIntValue());
            }
        }
    }

    private void setFolder(Document doc) throws PersistenceException {
        if (doc.getFolder().getFoldRef() != null) {
            Folder fld = (Folder)this.folderDAO.findById(doc.getFolder().getFoldRef());
            if (fld == null) {
                throw new PersistenceException(String.format("Unable to find refrenced folder %s", doc.getFolder().getFoldRef()));
            }
            this.folderDAO.initialize(fld);
            doc.setFolder(fld);
        }
    }

    private void setTags(Document doc) {
        Set<Tag> src = doc.getTags();
        if (CollectionUtils.isNotEmpty(src)) {
            HashSet<Tag> dst = new HashSet<Tag>();
            for (Tag str : src) {
                str.setTenantId(doc.getTenantId());
                String s = str.getTag();
                if (s == null) continue;
                if (s.length() > 255) {
                    s = s.substring(0, 255);
                    str.setTag(s);
                }
                if (dst.contains(str)) continue;
                dst.add(str);
            }
            doc.setTags(dst);
            doc.setTgs(doc.getTagsString());
        }
    }

    private void setIndexed(Document doc, Tenant tenant) {
        if (doc.getIndexed() == IndexingStatus.TO_INDEX || doc.getIndexed() == IndexingStatus.TO_INDEX_METADATA) {
            if (!FileUtil.matches(doc.getFileName(), this.config.getProperty(tenant.getName() + ".index.includes", ""), this.config.getProperty(tenant.getName() + ".index.excludes", ""))) {
                doc.setIndexingStatus(IndexingStatus.SKIP);
            }
            if (doc.getIndexed() == IndexingStatus.SKIP && FileUtil.matches(doc.getFileName(), this.config.getProperty(tenant.getName() + ".index.includes.metadata", ""), this.config.getProperty(tenant.getName() + ".index.excludes.metadata", ""))) {
                doc.setIndexingStatus(IndexingStatus.TO_INDEX_METADATA);
            }
        }
    }

    private void truncatePublishingDates(Document doc) {
        Instant truncatedInstant;
        ZonedDateTime truncatedZonedDateTime;
        ZonedDateTime zonedDateTime;
        Instant instant;
        if (doc.getStartPublishing() != null) {
            instant = doc.getStartPublishing().toInstant();
            zonedDateTime = instant.atZone(ZoneId.systemDefault());
            truncatedZonedDateTime = zonedDateTime.truncatedTo(ChronoUnit.DAYS);
            truncatedInstant = truncatedZonedDateTime.toInstant();
            doc.setStartPublishing(Date.from(truncatedInstant));
        }
        if (doc.getStopPublishing() != null) {
            instant = doc.getStopPublishing().toInstant();
            zonedDateTime = instant.atZone(ZoneId.systemDefault());
            truncatedZonedDateTime = zonedDateTime.truncatedTo(ChronoUnit.DAYS);
            truncatedInstant = truncatedZonedDateTime.toInstant();
            doc.setStopPublishing(Date.from(truncatedInstant));
        }
    }

    private void setUniqueFilename(Document doc) throws PersistenceException {
        if (!RunLevel.current().aspectEnabled("uniquenessFilename")) {
            return;
        }
        String baseName = doc.getFileName();
        Object ext = "";
        if (doc.getFileName().indexOf(".") != -1) {
            baseName = FileUtil.getBaseName(doc.getFileName());
            ext = "." + FileUtil.getExtension(doc.getFileName());
        }
        HashSet fileNames = new HashSet();
        StringBuilder query = new StringBuilder("select ld_filename from ld_document where ld_deleted=0 and ld_folderid=");
        query.append(Long.toString(doc.getFolder().getId()));
        query.append(" and ld_filename like '");
        query.append(SqlUtil.doubleQuotes(baseName));
        query.append("%' and not ld_id=");
        query.append(Long.toString(doc.getId()));
        this.queryForResultSet(query.toString(), null, null, rs -> {
            while (rs.next()) {
                String file = rs.getString(1);
                if (file == null || fileNames.contains(file)) continue;
                fileNames.add(file.toLowerCase());
            }
        });
        int counter = 1;
        while (fileNames.contains(doc.getFileName().toLowerCase())) {
            doc.setFileName(baseName + "(" + counter++ + ")" + (String)ext);
        }
    }

    @Override
    public void updateDigest(Document doc) throws PersistenceException {
        String resource = this.store.getResourceName(doc, doc.getFileVersion(), null);
        if (this.store.exists(doc.getId(), resource)) {
            try {
                Throwable throwable = null;
                Object var4_6 = null;
                try (InputStream in = this.store.getStream(doc.getId(), resource);){
                    doc.setDigest(FileUtil.computeDigest(in));
                }
                catch (Throwable throwable2) {
                    if (throwable == null) {
                        throwable = throwable2;
                    } else if (throwable != throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
            }
            catch (IOException e) {
                this.log.error("Cannot retrieve the content of document {}", (Object)doc);
                this.log.error(e.getMessage(), e);
            }
            this.saveOrUpdate(doc);
            this.flush();
            this.evict(doc);
            HashMap<String, Object> params = new HashMap<String, Object>();
            params.put("fileVersion", doc.getFileVersion());
            params.put("digest", doc.getDigest());
            params.put(DOC_ID, doc.getId());
            this.jdbcUpdate("update ld_version set ld_digest = :digest  where ld_documentid = :docId and ld_fileversion = :fileVersion", params);
        }
    }

    @Override
    public List<Document> findLastModifiedByUserId(long userId, int maxElements) throws PersistenceException {
        ArrayList<Document> coll = new ArrayList<Document>();
        StringBuilder query = new StringBuilder("SELECT _history.docId from DocumentHistory _history");
        query.append(" WHERE _history.userId = " + Long.toString(userId) + " ");
        query.append(" ORDER BY _history.date DESC");
        List<Object> results = new ArrayList();
        try {
            results = this.findByQuery(query.toString(), null, Long.class, null);
        }
        catch (PersistenceException persistenceException) {
            this.log.error(persistenceException.getMessage(), persistenceException);
        }
        for (Long l : results) {
            Document document;
            if (coll.size() >= maxElements) break;
            if (l == null || !this.folderDAO.isReadAllowed((document = (Document)this.findById(l)).getFolder().getId(), userId)) continue;
            coll.add(document);
        }
        return coll;
    }

    @Override
    public List<String> findTags(long docId) throws PersistenceException {
        return this.queryForList("select ld_tag from ld_tag where ld_docid=" + docId + " order by ld_tag", String.class);
    }

    @Override
    public Map<String, Long> findTags(String firstLetter, Long tenantId) throws PersistenceException {
        final HashMap<String, Long> map = new HashMap<String, Long>();
        StringBuilder query = new StringBuilder("SELECT ld_count, ld_tag from ld_uniquetag where 1=1 ");
        if (StringUtils.isNotEmpty(firstLetter)) {
            query.append(" and lower(ld_tag) like '" + firstLetter.toLowerCase() + "%' ");
        }
        if (tenantId != null) {
            query.append(AND_LD_TENANTID + String.valueOf(tenantId));
        }
        this.query(query.toString(), new RowMapper<Object>(){

            public Object mapRow(ResultSet rs, int rowNumber) throws SQLException {
                Long value = rs.getLong(1);
                String key = rs.getString(2);
                map.put(key, value);
                return null;
            }
        }, null);
        return map;
    }

    @Override
    public List<String> findAllTags(String firstLetter, Long tenantId) throws PersistenceException {
        StringBuilder sb = new StringBuilder("select ld_tag from ld_uniquetag where 1=1 ");
        if (tenantId != null) {
            sb.append(AND_LD_TENANTID + String.valueOf(tenantId));
        }
        HashMap<String, Object> params = new HashMap<String, Object>();
        if (firstLetter != null) {
            sb.append(" and lower(ld_tag) like :tagLike ");
            params.put("tagLike", firstLetter.toLowerCase() + "%");
        }
        return this.queryForList(sb.toString(), params, String.class, null);
    }

    @Override
    public List<Document> findByUserIdAndTag(long userId, String tag, Integer max) throws PersistenceException {
        List<Document> coll = new ArrayList<Document>();
        List<Long> ids = this.findDocIdByUserIdAndTag(userId, tag);
        if (!ids.isEmpty()) {
            StringBuilder query = new StringBuilder("select A from Document A where A.id in (");
            query.append(ids.stream().map(Object::toString).collect(Collectors.joining(",")));
            query.append(")");
            try {
                coll = this.findByObjectQuery(query.toString(), null, max);
            }
            catch (PersistenceException e) {
                this.log.error(e.getMessage(), e);
            }
        }
        return coll;
    }

    @Override
    public List<Long> findDocIdByUserIdAndTag(long userId, String tag) throws PersistenceException {
        List<Long> ids = new ArrayList<Long>();
        User user = (User)this.userDAO.findById(userId);
        if (user == null) {
            return ids;
        }
        StringBuilder query = new StringBuilder();
        if (user.isMemberOf("admin")) {
            ids = this.findDocIdByTag(tag);
        } else {
            Collection<Long> precoll = this.folderDAO.findFolderIdByUserId(userId, null, true);
            String precollString = precoll.toString().replace('[', '(').replace(']', ')');
            query.append("select distinct(C.ld_id) from ld_document C, ld_tag D  where C.ld_id=D.ld_docid AND C.ld_deleted=0 and not C.ld_status=" + DocumentStatus.ARCHIVED.ordinal());
            query.append(" AND C.ld_folderid in ");
            query.append(precollString);
            query.append(" AND lower(D.ld_tag)='" + SqlUtil.doubleQuotes(tag.toLowerCase()) + "' ");
            this.log.debug("Find by tag: {}", (Object)query);
            ids.addAll(this.queryForList(query.toString(), Long.class));
        }
        return ids;
    }

    @Override
    public List<Document> findLastDownloadsByUserId(long userId, int maxResults) throws PersistenceException {
        ArrayList<Long> tmpal;
        ArrayList<Document> coll = new ArrayList<Document>();
        StringBuilder query = new StringBuilder("select docId from DocumentHistory ");
        query.append(" where userId = " + userId);
        query.append(" and event = '" + String.valueOf((Object)DocumentEvent.DOWNLOADED) + "' ");
        query.append(" order by date desc");
        ArrayList<Long> docIds = tmpal = new ArrayList<Long>(this.findByQuery(query.toString(), null, Long.class, null));
        if (docIds.isEmpty()) {
            return coll;
        }
        if (docIds.size() > maxResults) {
            tmpal.subList(0, maxResults - 1);
        }
        query = new StringBuilder("from Document _entity ");
        query.append(" where not _entity.status=" + DocumentStatus.ARCHIVED.ordinal());
        query.append(" and _entity.id in (");
        int i = 0;
        while (i < docIds.size()) {
            Long docId = (Long)docIds.get(i);
            if (i > 0) {
                query.append(",");
            }
            query.append(docId);
            ++i;
        }
        query.append(")");
        List<Document> unorderdColl = this.findByQuery(query.toString(), null, Document.class, null);
        HashMap<Long, Document> hm = new HashMap<Long, Document>();
        for (Document doc : unorderdColl) {
            hm.put(doc.getId(), doc);
        }
        for (Long docId : docIds) {
            Document myDoc = (Document)hm.get(docId);
            if (myDoc == null) continue;
            coll.add(myDoc);
        }
        return coll;
    }

    @Override
    public List<Long> findDocIdByFolder(long folderId, Integer max) throws PersistenceException {
        String sql = "select ld_id from ld_document where ld_deleted=0 and ld_folderid = " + folderId + " and not ld_status=" + DocumentStatus.ARCHIVED.ordinal();
        return this.queryForList(sql, null, Long.class, max);
    }

    @Override
    public List<Document> findByFolder(long folderId, Integer max) throws PersistenceException {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("folderId", folderId);
        return this.findByWhere("_entity.folder.id = :folderId ", params, null, max);
    }

    @Override
    public List<Document> findArchivedByFolder(long folderId) throws PersistenceException {
        return this.findByWhere("_entity.folder.id = " + folderId + " and _entity.status=" + DocumentStatus.ARCHIVED.ordinal(), null, null);
    }

    @Override
    public List<Document> findLinkedDocuments(long docId, String linkType, Integer direction) throws PersistenceException {
        StringBuilder query = new StringBuilder("");
        if (direction == null) {
            query.append("select distinct(ld_docid2) from ld_link where ld_deleted=0 and (ld_docid1 = :docId) UNION select distinct(ld_docid1) from ld_link where ld_deleted=0 and (ld_docid2 = :docId)");
        } else if (direction == 1) {
            query.append("select distinct(ld_docid2) from ld_link where ld_deleted=0 and (ld_docid1 = :docId)");
        } else if (direction == 2) {
            query.append("select distinct(ld_docid1) from ld_link where ld_deleted=0 and (ld_docid2 = :docId)");
        }
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put(DOC_ID, docId);
        List<Long> ids = this.queryForList(query.toString(), params, Long.class, null);
        if (ids.isEmpty()) {
            return new ArrayList<Document>();
        }
        return this.findByWhere("_entity.id in (" + ids.stream().map(Object::toString).collect(Collectors.joining(",")) + ") and not _entity.status=" + DocumentStatus.ARCHIVED.ordinal(), null, null);
    }

    @Override
    public List<Document> findByFileNameAndParentFolderId(Long folderId, String fileName, Long excludeId, Long tenantId, Integer max) throws PersistenceException {
        String query = "lower(_entity.fileName) like '%" + SqlUtil.doubleQuotes(fileName.toLowerCase()) + "%'";
        if (tenantId != null) {
            query = query + " and _entity.tenantId = " + String.valueOf(tenantId);
        }
        if (folderId != null) {
            query = query + " and _entity.folder.id = " + String.valueOf(folderId);
        }
        if (excludeId != null) {
            query = query + " and not(_entity.id = " + String.valueOf(excludeId) + ")";
        }
        query = query + " and not _entity.status=" + DocumentStatus.ARCHIVED.ordinal();
        return this.findByWhere(query, null, max);
    }

    @Override
    public void initialize(Document doc) {
        if (doc == null) {
            return;
        }
        this.refresh(doc);
        if (doc.getAttributes() != null) {
            this.log.trace("Initialized {} attributes", (Object)doc.getAttributes().keySet().size());
        }
        if (doc.getTags() != null) {
            this.log.trace("Initialized {} tags", (Object)doc.getTags().size());
        }
        if (doc.getAccessControlList() != null) {
            this.log.trace("Initialized {} aces", (Object)doc.getAccessControlList().size());
        }
    }

    @Override
    public List<Long> findDeletedDocIds() throws PersistenceException {
        String query = "select ld_id from ld_document where ld_deleted=1 order by ld_lastmodified desc";
        return this.queryForList(query, Long.class);
    }

    @Override
    public List<Document> findDeletedDocs() throws PersistenceException {
        String query = "select ld_id, ld_customid, ld_lastModified, ld_filename from ld_document where ld_deleted=1 order by ld_lastmodified desc";
        BeanPropertyRowMapper docMapper = new BeanPropertyRowMapper(){

            public Object mapRow(ResultSet rs, int rowNum) throws SQLException {
                Document doc = new Document();
                doc.setId(rs.getLong(1));
                doc.setCustomId(rs.getString(2));
                doc.setLastModified(rs.getDate(3));
                doc.setFileName(rs.getString(4));
                return doc;
            }
        };
        return this.query(query, docMapper, (Integer)null);
    }

    @Override
    public long computeTotalSize(Long tenantId, Long userId, boolean computeDeleted) throws PersistenceException {
        String query = "select sum(ld_filesize) from ld_version where ld_version = ld_fileversion" + (computeDeleted ? "" : " and ld_deleted=0 ") + (String)(userId != null ? " and ld_publisherid=" + String.valueOf(userId) : "") + (String)(tenantId != null ? AND_LD_TENANTID + String.valueOf(tenantId) : "");
        return this.queryForLong(query);
    }

    @Override
    public long count(Long tenantId, boolean computeDeleted, boolean computeArchived) throws PersistenceException {
        Object query = "select count(*) from ld_document where 1=1 ";
        if (!computeDeleted) {
            query = (String)query + " and ld_deleted = 0 ";
        }
        if (!computeArchived) {
            query = (String)query + " and not ld_status = " + DocumentStatus.ARCHIVED.ordinal();
        }
        if (tenantId != null) {
            query = (String)query + " and ld_tenantid = " + String.valueOf(tenantId);
        }
        return this.queryForLong((String)query);
    }

    @Override
    public List<Document> findByIndexingStatus(IndexingStatus indexingStatus) throws PersistenceException {
        return this.findByWhere("_entity.docRef is null and _entity.indexingStatus = " + indexingStatus.ordinal(), "_entity.lastModified asc", null);
    }

    @Override
    public void restore(long docId, long folderId, DocumentHistory transaction) throws PersistenceException {
        this.bulkUpdate("set deleted=0, lastModified=CURRENT_TIMESTAMP where id = :docId", Map.of(DOC_ID, docId));
        this.bulkUpdate("set folder = :folder where id = :docId", Map.of("folder", this.getCurrentSession().get(Folder.class, (Object)folderId), DOC_ID, docId));
        this.versionDAO.bulkUpdate("set deleted=0, lastModified=CURRENT_TIMESTAMP where id = :docId", Map.of(DOC_ID, docId));
        this.versionDAO.bulkUpdate("set folderId = :folderId where id = :docId", Map.of("folderId", folderId, DOC_ID, docId));
        Document doc = (Document)this.findById(docId);
        if (doc != null && transaction != null) {
            transaction.setDocId(docId);
            transaction.setEvent(DocumentEvent.RESTORED);
            this.initialize(doc);
            this.store(doc, transaction);
        }
    }

    @Override
    public Document findByCustomId(String customId, long tenantId) throws PersistenceException {
        String query;
        List coll;
        Document doc = null;
        if (customId != null && !(coll = this.findByWhere(query = "_entity.customId = '" + SqlUtil.doubleQuotes(customId) + "'  and _entity.tenantId=" + tenantId, null, null)).isEmpty() && (doc = (Document)coll.get(0)).getDeleted() == 1) {
            doc = null;
        }
        return doc;
    }

    @Override
    public void makeImmutable(long docId, DocumentHistory transaction) throws PersistenceException {
        Document doc = (Document)this.findById(docId);
        this.initialize(doc);
        doc.setImmutable(1);
        doc.setStatus(DocumentStatus.UNLOCKED);
        this.store(doc, transaction);
    }

    @Override
    public void deleteAll(Collection<Document> documents, DocumentHistory transaction) throws PersistenceException {
        this.deleteAll(documents, 1, transaction);
    }

    @Override
    public void deleteAll(Collection<Document> documents, int delCode, DocumentHistory transaction) throws PersistenceException {
        for (Document document : documents) {
            DocumentHistory deleteHistory = new DocumentHistory(transaction);
            deleteHistory.setEvent(DocumentEvent.DELETED);
            this.delete(document.getId(), delCode, deleteHistory);
        }
    }

    @Override
    public void saveDocumentHistory(Document doc, DocumentHistory transaction) throws PersistenceException {
        HashMap<String, Object> dictionary = new HashMap<String, Object>();
        this.saveDocumentHistory(doc, transaction, dictionary);
    }

    private void saveDocumentHistory(Document doc, DocumentHistory transaction, Map<String, Object> dictionary) throws PersistenceException {
        if (doc == null || transaction == null || !RunLevel.current().aspectEnabled("saveHistory")) {
            return;
        }
        try {
            transaction.setTenantId(doc.getTenantId());
            transaction.setDocId(doc.getId());
            transaction.setFolderId(doc.getFolder().getId());
            transaction.setVersion(doc.getVersion());
            transaction.setFileVersion(doc.getFileVersion());
            transaction.setRevision(doc.getRevision());
            transaction.setFilename(doc.getFileName());
            transaction.setFileSize(doc.getFileSize());
            transaction.setNotified(0);
            transaction.setDocument(doc);
            transaction.setPath(this.folderDAO.computePathExtended(doc.getFolder().getId()));
            this.documentHistoryDAO.store(transaction);
            this.log.debug("Invoke listeners after store");
            for (DocumentListener listener : this.listenerManager.getListeners()) {
                listener.afterSaveHistory(doc, transaction, dictionary);
            }
            EventCollector.get().newEvent(transaction);
        }
        catch (PersistenceException e) {
            if (StringUtils.isNotEmpty(transaction.getSessionId())) {
                Session session = SessionManager.get().get(transaction.getSessionId());
                session.logError(e.getMessage());
            }
            this.log.error(e.getMessage(), e);
            if (e instanceof PersistenceException) {
                throw e;
            }
            throw new PersistenceException(e);
        }
    }

    @Override
    public long countByIndexed(IndexingStatus indexingStatus) throws PersistenceException {
        return this.queryForLong("select count(*) from ld_document where ld_deleted=0 and ld_indexed = " + indexingStatus.ordinal());
    }

    @Override
    public List<Long> findAliasIds(long docId) throws PersistenceException {
        return this.findIdsByWhere("_entity.docRef = " + Long.toString(docId), null, null);
    }

    @Override
    public List<Document> findDeleted(long userId, Integer maxHits) throws PersistenceException {
        String query = "select ld_id, ld_lastmodified, ld_filename, ld_customid, ld_tenantid, ld_folderid, ld_color from ld_document where ld_deleted=1 and ld_deleteuserid = " + userId + " order by ld_lastmodified desc";
        BeanPropertyRowMapper docMapper = new BeanPropertyRowMapper(){

            public Object mapRow(ResultSet rs, int rowNum) throws SQLException {
                Document doc = new Document();
                doc.setId(rs.getLong(1));
                doc.setLastModified(rs.getTimestamp(2));
                doc.setFileName(rs.getString(3));
                doc.setCustomId(rs.getString(4));
                doc.setTenantId(rs.getLong(5));
                Folder folder = new Folder();
                folder.setId(rs.getLong(6));
                doc.setFolder(folder);
                doc.setColor(rs.getString(7));
                return doc;
            }
        };
        return this.query(query, docMapper, maxHits);
    }

    @Override
    public List<Document> findByIds(Set<Long> ids, Integer max) {
        List<Document> docs = new ArrayList<Document>();
        if (CollectionUtils.isEmpty(ids)) {
            return docs;
        }
        try {
            docs = this.findByWhere("_entity.id in(" + ids.stream().map(id -> Long.toString(id)).collect(Collectors.joining(",")) + ")", null, max);
        }
        catch (PersistenceException e) {
            this.log.error(e.getMessage(), e);
        }
        return docs;
    }

    @Override
    public void deleteOrphaned(long deleteUserId) throws PersistenceException {
        String dbms = this.config.getProperty("jdbc.dbms") != null ? this.config.getProperty("jdbc.dbms").toLowerCase() : "mysql";
        String concat = "CONCAT(ld_id,CONCAT('.',ld_customid))";
        if (dbms.contains("postgre")) {
            concat = "ld_id || '.' || ld_customid";
        }
        if (dbms.contains("mssql")) {
            concat = "CAST(ld_id AS varchar) + '.' + ld_customid";
        }
        this.jdbcUpdate("update ld_document set ld_deleted=1,ld_customid=" + concat + ", ld_deleteuserid=" + deleteUserId + " where ld_deleted=0 and ld_folderid in (select ld_id from ld_folder where ld_deleted  > 0)");
    }

    @Override
    public Collection<Long> findPublishedIds(Collection<Long> folderIds) throws PersistenceException {
        StringBuilder query = new StringBuilder("select ld_id from ld_document where ld_deleted=0 and not ld_status=" + DocumentStatus.ARCHIVED.ordinal());
        if (folderIds != null && !folderIds.isEmpty()) {
            query.append(" and ld_folderid in (");
            query.append(folderIds.toString().replace('[', ' ').replace(']', ' '));
            query.append(" ) ");
        }
        query.append(" and ld_published = 1 ");
        query.append(" and ld_startpublishing <= :now ");
        query.append(" and ( ld_stoppublishing is null or ld_stoppublishing > :now )");
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("now", new Date());
        List<Long> buf = this.queryForList(query.toString(), params, Long.class, null);
        HashSet<Long> ids = new HashSet<Long>();
        for (Long id : buf) {
            if (ids.contains(id)) continue;
            ids.add(id);
        }
        return ids;
    }

    @Override
    public void cleanExpiredTransactions() throws PersistenceException {
        List<String> transactionIds = this.queryForList("select ld_string1 from ld_generic where ld_type='lock' and ld_string1 is not null", String.class);
        String transactionIdsStr = transactionIds.toString().replace("[", "('").replace("]", "')").replace(", ", "','");
        this.bulkUpdate("set transactionId=null where transactionId is not null and transactionId not in " + transactionIdsStr, null);
    }

    @Override
    public void cleanUnexistingUniqueTags() throws PersistenceException {
        try {
            StringBuilder deleteStatement = new StringBuilder("DELETE FROM ld_uniquetag WHERE ");
            deleteStatement.append(" ld_uniquetag.ld_tag NOT IN ( SELECT DISTINCT t.ld_tag FROM ld_tag t JOIN ld_document d ON d.ld_id = t.ld_docid WHERE ld_uniquetag.ld_tenantid = t.ld_tenantid AND ld_uniquetag.ld_tag = t.ld_tag AND d.ld_deleted = 0 ) ");
            deleteStatement.append(" AND ld_uniquetag.ld_tag NOT IN ( SELECT DISTINCT ft.ld_tag FROM ld_foldertag ft JOIN ld_folder f ON f.ld_id = ft.ld_folderid WHERE ld_uniquetag.ld_tenantid = ft.ld_tenantid AND ld_uniquetag.ld_tag = ft.ld_tag AND f.ld_deleted = 0 ); ");
            this.jdbcUpdate(deleteStatement.toString());
        }
        catch (PersistenceException e) {
            this.cleanUnexistingUniqueTagsOneByOne();
        }
    }

    @Override
    public void cleanUnexistingUniqueTagsOneByOne() throws PersistenceException {
        List<Long> tenantIds = this.tenantDAO.findAllIds();
        for (Long tenantId : tenantIds) {
            String currentlyUsedTagsStr;
            this.log.debug("Clean unique tags of tenant {}", (Object)tenantId);
            Set currentlyUsedTags = this.queryForList("select distinct(B.ld_tag) from ld_tag B, ld_document C where B.ld_tenantid=" + String.valueOf(tenantId) + " and C.ld_id=B.ld_docid and C.ld_deleted=0  UNION select distinct(D.ld_tag) from ld_foldertag D, ld_folder E where D.ld_tenantid=" + String.valueOf(tenantId) + " and E.ld_id=D.ld_folderid and E.ld_deleted=0", String.class).stream().collect(Collectors.groupingBy(Function.identity())).keySet();
            if (this.isOracle()) {
                currentlyUsedTagsStr = currentlyUsedTags.stream().map(tag -> "('" + SqlUtil.doubleQuotes(tag) + "',0)").collect(Collectors.joining(","));
                if (!StringUtils.isNotEmpty(currentlyUsedTagsStr)) continue;
                this.jdbcUpdate("delete from ld_uniquetag where ld_tenantid=" + String.valueOf(tenantId) + " and (ld_tag,0) not in (" + currentlyUsedTagsStr + ")");
                continue;
            }
            currentlyUsedTagsStr = currentlyUsedTags.stream().map(tag -> "'" + SqlUtil.doubleQuotes(tag) + "'").collect(Collectors.joining(","));
            if (!StringUtils.isNotEmpty(currentlyUsedTagsStr)) continue;
            this.jdbcUpdate("delete from ld_uniquetag where ld_tenantid=" + String.valueOf(tenantId) + " and ld_tag not in (" + currentlyUsedTagsStr + ")");
        }
    }

    @Override
    public void insertNewUniqueTags() throws PersistenceException {
        StringBuilder insertStatement = new StringBuilder("insert into ld_uniquetag(ld_tag, ld_tenantid, ld_count) ");
        insertStatement.append(" select distinct(B.ld_tag), B.ld_tenantid, 0 from ld_tag B, ld_document D ");
        insertStatement.append(" where B.ld_docid = D.ld_id and D.ld_deleted = 0 and B.ld_tag not in (select A.ld_tag from ld_uniquetag A where A.ld_tenantid=B.ld_tenantid) ");
        this.jdbcUpdate(insertStatement.toString());
        insertStatement = new StringBuilder("insert into ld_uniquetag(ld_tag, ld_tenantid, ld_count) ");
        insertStatement.append(" select distinct(B.ld_tag), B.ld_tenantid, 0 from ld_foldertag B, ld_folder F ");
        insertStatement.append(" where B.ld_folderid = F.ld_id and F.ld_deleted = 0 and B.ld_tag not in (select A.ld_tag from ld_uniquetag A where A.ld_tenantid=B.ld_tenantid) ");
        this.jdbcUpdate(insertStatement.toString());
    }

    @Override
    public void updateCountUniqueTags() throws PersistenceException {
        List<Long> tenantIds = this.tenantDAO.findAllIds();
        for (Long tenantId : tenantIds) {
            List<String> uniqueTags = this.queryForList("select ld_tag from ld_uniquetag", String.class);
            for (String tag : uniqueTags) {
                try {
                    HashMap<String, Object> params = new HashMap<String, Object>();
                    params.put("tag", tag);
                    params.put("tenantId", tenantId);
                    this.jdbcUpdate("update ld_uniquetag set ld_count = (select count(T.ld_tag) from ld_tag T, ld_document D where T.ld_tag = :tag and T.ld_tenantid = :tenantId  and T.ld_docid = D.ld_id and D.ld_deleted=0 ) where ld_tag = :tag and ld_tenantid = :tenantId", params);
                }
                catch (PersistenceException e) {
                    this.log.warn(e.getMessage(), e);
                }
            }
        }
    }

    @Override
    public List<TagCloud> getTagCloud(long tenantId, int maxTags) throws PersistenceException {
        List<TagCloud> list;
        GenericDAO gendao = Context.get(GenericDAO.class);
        List<TagCloud> mostUsedTags = list = gendao.query("select ld_tag, ld_count from ld_uniquetag where ld_tenantid=" + tenantId + " order by ld_count desc", new RowMapper<TagCloud>(){

            public TagCloud mapRow(ResultSet rs, int arg1) throws SQLException {
                return new TagCloud(rs.getString(1), rs.getLong(2));
            }
        }, null);
        if (maxTags > 0 && mostUsedTags.size() > maxTags) {
            mostUsedTags = new ArrayList<TagCloud>(list.subList(0, maxTags));
        }
        if (mostUsedTags != null && !mostUsedTags.isEmpty()) {
            long maxValue = mostUsedTags.get(0).getCount();
            for (TagCloud cloud : mostUsedTags) {
                double scale = (double)cloud.getCount() / (double)maxValue;
                int scaleInt = (int)Math.ceil(scale * 10.0);
                cloud.setScale(scaleInt);
            }
            Collections.sort(mostUsedTags);
        }
        return mostUsedTags;
    }

    @Override
    public List<TagCloud> getTagCloud(String sid) throws PersistenceException {
        Session session = SessionManager.get().get(sid);
        int maxTags = Context.get().getProperties().getInt(session.getTenantName() + ".tagcloud.maxtags", 30);
        return this.getTagCloud(session.getTenantId(), maxTags);
    }

    @Override
    public Document findDocument(long docId) throws PersistenceException {
        Document doc = (Document)this.findById(docId);
        if (doc != null && doc.getDocRef() != null) {
            doc = (Document)this.findById(doc.getDocRef());
        }
        return doc;
    }

    @Override
    public Folder getWorkspace(long docId) throws PersistenceException {
        Document doc = (Document)this.findById(docId);
        if (doc == null) {
            return null;
        }
        return this.folderDAO.findWorkspace(doc.getFolder().getId());
    }

    @Override
    public void setPassword(long docId, String password, DocumentHistory transaction) throws PersistenceException {
        if (transaction == null) {
            throw new IllegalArgumentException(TRANSACTION_CANNOT_BE_NULL);
        }
        if (transaction.getUsername() == null) {
            throw new IllegalArgumentException("transaction username cannot be null");
        }
        transaction.setEvent(DocumentEvent.PASSWORD_PROTECTED);
        Document doc = this.findDocument(docId);
        if (doc != null) {
            if (StringUtils.isNotEmpty(doc.getPassword())) {
                throw new PersistenceException("The document already has a password, unset it first");
            }
            this.initialize(doc);
            try {
                doc.setDecodedPassword(password);
            }
            catch (NoSuchAlgorithmException e) {
                throw new PersistenceException("Cannot cript the password", e);
            }
            this.store(doc, transaction);
            List<Version> versions = this.versionDAO.findByDocId(docId);
            for (Version ver : versions) {
                this.versionDAO.initialize(ver);
                ver.setPassword(doc.getPassword());
                this.versionDAO.store(ver);
            }
        }
    }

    @Override
    public void unsetPassword(long docId, DocumentHistory transaction) throws PersistenceException {
        if (transaction == null) {
            throw new IllegalArgumentException(TRANSACTION_CANNOT_BE_NULL);
        }
        if (transaction.getUsername() == null) {
            throw new IllegalArgumentException("transaction username cannot be null");
        }
        transaction.setEvent(DocumentEvent.PASSWORD_UNPROTECTED);
        Document doc = this.findDocument(docId);
        if (doc != null) {
            this.initialize(doc);
            doc.setPassword(null);
            this.store(doc, transaction);
            List<Version> versions = this.versionDAO.findByDocId(docId);
            for (Version ver : versions) {
                this.versionDAO.initialize(ver);
                ver.setPassword(null);
                this.versionDAO.store(ver);
            }
        }
    }

    @Override
    public Document findByPath(String path, long tenantId) throws PersistenceException {
        String folderPath = FileUtil.getPath(path);
        Folder folder = this.folderDAO.findByPathExtended(folderPath, tenantId);
        if (folder == null) {
            return null;
        }
        String fileName = FileUtil.getName(path);
        List<Document> docs = this.findByFileNameAndParentFolderId(folder.getId(), fileName, null, tenantId, null);
        for (Document doc : docs) {
            if (!doc.getFileName().equals(fileName)) continue;
            return doc;
        }
        return null;
    }

    @Override
    public List<String> findDuplicatedDigests(Long tenantId, Long folderId) throws PersistenceException {
        StringBuilder digestQuery = new StringBuilder("select ld_digest from ld_document where ld_deleted = 0 ");
        if (tenantId != null) {
            digestQuery.append(" and ld_tenantid = ");
            digestQuery.append(Long.toString(tenantId));
        }
        if (folderId != null) {
            List<Long> tree = this.folderDAO.findIdsByParentId(folderId);
            if (!tree.contains(folderId)) {
                tree.add(folderId);
            }
            digestQuery.append(" and ld_folderid in (");
            digestQuery.append(tree.stream().map(Object::toString).collect(Collectors.joining(", ")));
            digestQuery.append(" ) ");
        }
        digestQuery.append(" and ld_docref is null and ld_digest is not null group by ld_digest having count(*) > 1");
        return this.query(digestQuery.toString(), (rs, rowNum) -> rs.getString(1), null);
    }

    @Override
    public boolean isPrintAllowed(long id, long userId) throws PersistenceException {
        return this.isPermissionAllowed(Permission.PRINT, id, userId);
    }

    @Override
    public boolean isWriteAllowed(long id, long userId) throws PersistenceException {
        return this.isPermissionAllowed(Permission.WRITE, id, userId);
    }

    @Override
    public boolean isDownloadAllowed(long id, long userId) throws PersistenceException {
        return this.isPermissionAllowed(Permission.DOWNLOAD, id, userId);
    }

    @Override
    public boolean isMoveAllowed(long id, long userId) throws PersistenceException {
        return this.isPermissionAllowed(Permission.MOVE, id, userId);
    }

    @Override
    public boolean isReadAllowed(long docId, long userId) throws PersistenceException {
        return this.isPermissionAllowed(Permission.READ, docId, userId);
    }

    @Override
    public boolean isPreviewAllowed(long docId, long userId) throws PersistenceException {
        return this.isPermissionAllowed(Permission.PREVIEW, docId, userId);
    }

    @Override
    public boolean isPermissionAllowed(Permission permission, long documentId, long userId) throws PersistenceException {
        Set<Permission> permissions = this.getAllowedPermissions(documentId, userId);
        return permissions.contains((Object)permission);
    }

    private User getExistingtUser(long userId) throws PersistenceException {
        User user = (User)this.userDAO.findById(userId);
        if (user == null) {
            throw new PersistenceException("Unexisting user " + userId);
        }
        return user;
    }

    @Override
    public Set<Permission> getAllowedPermissions(long docId, long userId) throws PersistenceException {
        HashSet<Permission> permissions = new HashSet<Permission>();
        User user = this.getExistingtUser(userId);
        this.userDAO.initialize(user);
        if (this.findById(docId) == null) {
            return new HashSet<Permission>();
        }
        if (user.isAdmin()) {
            return Permission.all();
        }
        StringBuilder query = new StringBuilder("select ld_read as LDREAD, ld_write as LDWRITE, ld_security as LDSECURITY, ld_immutable as LDIMMUTABLE, ld_delete as LDDELETE,\nld_rename as LDRENAME, ld_sign as LDSIGN, ld_archive as LDARCHIVE, ld_workflow as LDWORKFLOW, ld_download as LDDOWNLOAD,\nld_calendar as LDCALENDAR, ld_subscription as LDSUBSCRIPTION, ld_print as LDPRINT, ld_password as LDPASSWORD,\nld_move as LDMOVE, ld_email as LDEMAIL, ld_automation as LDAUTOMATION, ld_readingreq as LDREADINGREQ, ld_preview as LDPREVIEW,\nld_customid as LDCUSTOMID, ld_revision as LDREVISION from ld_document_acl where ld_docid=\n");
        query.append(Long.toString(docId));
        query.append(" and ld_groupid in (select ld_groupid from ld_usergroup where ld_userid=");
        query.append(Long.toString(userId));
        query.append(")");
        HashMap<String, Permission> permissionColumn = new HashMap<String, Permission>();
        permissionColumn.put("LDDELETE", Permission.DELETE);
        permissionColumn.put("LDIMMUTABLE", Permission.IMMUTABLE);
        permissionColumn.put("LDSECURITY", Permission.SECURITY);
        permissionColumn.put("LDRENAME", Permission.RENAME);
        permissionColumn.put("LDWRITE", Permission.WRITE);
        permissionColumn.put("LDREAD", Permission.READ);
        permissionColumn.put("LDSIGN", Permission.SIGN);
        permissionColumn.put("LDARCHIVE", Permission.ARCHIVE);
        permissionColumn.put("LDWORKFLOW", Permission.WORKFLOW);
        permissionColumn.put("LDDOWNLOAD", Permission.DOWNLOAD);
        permissionColumn.put("LDCALENDAR", Permission.CALENDAR);
        permissionColumn.put("LDSUBSCRIPTION", Permission.SUBSCRIPTION);
        permissionColumn.put("LDPRINT", Permission.PRINT);
        permissionColumn.put("LDPASSWORD", Permission.PASSWORD);
        permissionColumn.put("LDMOVE", Permission.MOVE);
        permissionColumn.put("LDEMAIL", Permission.EMAIL);
        permissionColumn.put("LDAUTOMATION", Permission.AUTOMATION);
        permissionColumn.put("LDREADINGREQ", Permission.READINGREQ);
        permissionColumn.put("LDPREVIEW", Permission.PREVIEW);
        permissionColumn.put("LDCUSTOMID", Permission.CUSTOMID);
        permissionColumn.put("LDREVISION", Permission.REVISION);
        this.queryForResultSet(query.toString(), null, null, rows -> {
            while (rows.next()) {
                for (Map.Entry entry : permissionColumn.entrySet()) {
                    String column = (String)entry.getKey();
                    Permission permission = (Permission)((Object)((Object)entry.getValue()));
                    if (rows.getInt(column) != 1) continue;
                    permissions.add(permission);
                }
            }
        });
        if (permissions.isEmpty()) {
            long folderId = this.queryForLong("select ld_folderid from ld_document where ld_id = " + docId);
            return this.folderDAO.getAllowedPermissions(folderId, userId);
        }
        return permissions;
    }

    @Override
    public void applyParentFolderSecurity(long docId, DocumentHistory transaction) throws PersistenceException {
        Folder folder = (Folder)this.folderDAO.findById(this.queryForLong("select ld_folderid from ld_document where ld_id=" + docId));
        while (folder.getSecurityRef() != null) {
            folder = (Folder)this.folderDAO.findById(folder.getSecurityRef());
        }
        int count = this.jdbcUpdate("delete from ld_document_acl where ld_docid=" + docId);
        this.log.debug("Removed {} security policies of document {}", (Object)count, (Object)docId);
        StringBuilder update = new StringBuilder(" insert into ld_document_acl(ld_docId,ld_groupid,ld_read,ld_preview,ld_write,ld_security,\n                              ld_immutable,ld_delete,ld_rename,ld_sign,ld_archive,\n                              ld_workflow,ld_download,ld_calendar,ld_subscription,\n                              ld_print,ld_password,ld_move,ld_email,ld_automation,\n                              ld_readingreq, ld_customid, ld_revision)\n");
        update.append(" select ");
        update.append(Long.toString(docId));
        update.append(",ld_groupid,ld_read,ld_preview,ld_write,ld_security,\n                              ld_immutable,ld_delete,ld_rename,ld_sign,ld_archive,\n                              ld_workflow,ld_download,ld_calendar,ld_subscription,\n                              ld_print,ld_password,ld_move,ld_email,ld_automation,\n                              ld_readingreq, ld_customid, ld_revision from ld_folder_acl where ld_folderid=\n");
        update.append(Long.toString(folder.getId()));
        count = this.jdbcUpdate(update.toString());
        this.log.debug("Copied {} security policies of folder {} into document {}", count, folder.getId(), docId);
        if (transaction != null) {
            transaction.setEvent(DocumentEvent.PERMISSION);
            Document document = (Document)this.findById(docId);
            this.saveDocumentHistory(document, transaction);
        }
    }
}

